/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.google.typography.font.tools.fontinfo;

import cfca.com.google.typography.font.sfntly.Font;
import cfca.com.google.typography.font.sfntly.FontFactory;
import cfca.com.google.typography.font.sfntly.Tag;
import cfca.com.google.typography.font.sfntly.table.Table;
import cfca.com.google.typography.font.sfntly.table.core.CMap;
import cfca.com.google.typography.font.sfntly.table.core.CMapTable;
import cfca.com.google.typography.font.sfntly.table.truetype.GlyphTable;
import cfca.com.google.typography.font.sfntly.table.truetype.LocaTable;
import com.ibm.icu.lang.UCharacter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FontUtils {
    public static Font[] getFonts(String fontFile) throws IOException {
        return FontUtils.getFonts(new FileInputStream(fontFile));
    }

    public static Font[] getFonts(InputStream is) throws IOException {
        FontFactory fontFactory = FontFactory.getInstance();
        fontFactory.fingerprintFont(true);
        Font[] fonts = null;
        try {
            fonts = fontFactory.loadFonts(is);
        }
        finally {
            is.close();
        }
        return fonts;
    }

    public static Table getTable(Font font, int tag) {
        Object table = font.getTable(tag);
        if (table == null) {
            throw new RuntimeException("Font has no " + Tag.stringValue(tag) + " table");
        }
        return table;
    }

    public static CMapTable getCMapTable(Font font) {
        return (CMapTable)FontUtils.getTable(font, Tag.cmap);
    }

    public static CMap getUCSCMap(Font font) {
        CMapTable cmapTable = FontUtils.getCMapTable(font);
        CMap cmap = null;
        cmap = cmapTable.cmap(Font.PlatformId.Windows.value(), Font.WindowsEncodingId.UnicodeUCS4.value());
        if (cmap == null) {
            cmap = cmapTable.cmap(Font.PlatformId.Windows.value(), Font.WindowsEncodingId.UnicodeUCS2.value());
        }
        if (cmap == null) {
            throw new UnsupportedOperationException("Font has no UCS-4 or UCS-2 cmap");
        }
        return cmap;
    }

    public static LocaTable getLocaTable(Font font) {
        return (LocaTable)FontUtils.getTable(font, Tag.loca);
    }

    public static GlyphTable getGlyphTable(Font font) {
        return (GlyphTable)FontUtils.getTable(font, Tag.glyf);
    }

    public static String getFormattedCodePointString(int codePoint) {
        if (UCharacter.isValidCodePoint((int)codePoint)) {
            if (UCharacter.isBMP((int)codePoint)) {
                return String.format("U+%04X", codePoint);
            }
            return String.format("U+%06X", codePoint);
        }
        throw new IllegalArgumentException("Invalid code point " + codePoint);
    }
}

