/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.styledxmlparser.css.resolve.shorthand.impl;

import cfca.sadk.com.itextpdf.io.util.MessageFormatUtil;
import cfca.sadk.com.itextpdf.styledxmlparser.css.CssDeclaration;
import cfca.sadk.com.itextpdf.styledxmlparser.css.resolve.shorthand.IShorthandResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBoxShorthandResolver
implements IShorthandResolver {
    private static final String _0_LEFT_1 = "{0}-left{1}";
    private static final String _0_RIGHT_1 = "{0}-right{1}";
    private static final String _0_BOTTOM_1 = "{0}-bottom{1}";
    private static final String _0_TOP_1 = "{0}-top{1}";

    protected abstract String getPrefix();

    protected abstract String getPostfix();

    @Override
    public List<CssDeclaration> resolveShorthand(String shorthandExpression) {
        String[] props = shorthandExpression.split("\\s+");
        ArrayList<CssDeclaration> resolvedDecl = new ArrayList<CssDeclaration>();
        String topProperty = MessageFormatUtil.format(_0_TOP_1, this.getPrefix(), this.getPostfix());
        String rightProperty = MessageFormatUtil.format(_0_RIGHT_1, this.getPrefix(), this.getPostfix());
        String bottomProperty = MessageFormatUtil.format(_0_BOTTOM_1, this.getPrefix(), this.getPostfix());
        String leftProperty = MessageFormatUtil.format(_0_LEFT_1, this.getPrefix(), this.getPostfix());
        if (props.length == 1) {
            resolvedDecl.add(new CssDeclaration(topProperty, props[0]));
            resolvedDecl.add(new CssDeclaration(rightProperty, props[0]));
            resolvedDecl.add(new CssDeclaration(bottomProperty, props[0]));
            resolvedDecl.add(new CssDeclaration(leftProperty, props[0]));
        } else {
            for (String prop : props) {
                if (!"inherit".equals(prop) && !"initial".equals(prop)) continue;
                Logger logger = LoggerFactory.getLogger(AbstractBoxShorthandResolver.class);
                logger.warn(MessageFormatUtil.format("Invalid css property declaration: {0}", shorthandExpression));
                return Collections.emptyList();
            }
            if (props.length == 2) {
                resolvedDecl.add(new CssDeclaration(topProperty, props[0]));
                resolvedDecl.add(new CssDeclaration(rightProperty, props[1]));
                resolvedDecl.add(new CssDeclaration(bottomProperty, props[0]));
                resolvedDecl.add(new CssDeclaration(leftProperty, props[1]));
            } else if (props.length == 3) {
                resolvedDecl.add(new CssDeclaration(topProperty, props[0]));
                resolvedDecl.add(new CssDeclaration(rightProperty, props[1]));
                resolvedDecl.add(new CssDeclaration(bottomProperty, props[2]));
                resolvedDecl.add(new CssDeclaration(leftProperty, props[1]));
            } else if (props.length == 4) {
                resolvedDecl.add(new CssDeclaration(topProperty, props[0]));
                resolvedDecl.add(new CssDeclaration(rightProperty, props[1]));
                resolvedDecl.add(new CssDeclaration(bottomProperty, props[2]));
                resolvedDecl.add(new CssDeclaration(leftProperty, props[3]));
            }
        }
        return resolvedDecl;
    }
}

