/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.io.font;

import cfca.sadk.com.itextpdf.io.util.IntHashtable;
import cfca.sadk.com.itextpdf.io.util.ResourceUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class CidFontProperties {
    @Deprecated
    public static final String RESOURCE_PATH_CMAP = "cfca/sadk/com/itextpdf/io/font/cmap/";
    private static final Map<String, Map<String, Object>> allFonts = new HashMap<String, Map<String, Object>>();
    private static final Map<String, Set<String>> registryNames = new HashMap<String, Set<String>>();

    public static boolean isCidFont(String fontName, String enc) {
        if (!registryNames.containsKey("fonts")) {
            return false;
        }
        if (!registryNames.get("fonts").contains(fontName)) {
            return false;
        }
        if (enc.equals("Identity-H") || enc.equals("Identity-V")) {
            return true;
        }
        String registry = (String)allFonts.get(fontName).get("Registry");
        Set<String> encodings = registryNames.get(registry);
        return encodings != null && encodings.contains(enc);
    }

    public static String getCompatibleFont(String enc) {
        for (Map.Entry<String, Set<String>> e : registryNames.entrySet()) {
            if (!e.getValue().contains(enc)) continue;
            String registry = e.getKey();
            for (Map.Entry<String, Map<String, Object>> e1 : allFonts.entrySet()) {
                if (!registry.equals(e1.getValue().get("Registry"))) continue;
                return e1.getKey();
            }
        }
        return null;
    }

    public static Map<String, Map<String, Object>> getAllFonts() {
        return allFonts;
    }

    public static Map<String, Set<String>> getRegistryNames() {
        return registryNames;
    }

    private static void loadRegistry() throws IOException {
        InputStream resource = ResourceUtil.getResourceStream("cfca/sadk/com/itextpdf/io/font/cmap/cjk_registry.properties");
        Properties p = new Properties();
        p.load(resource);
        resource.close();
        for (Object key : p.keySet()) {
            String value = p.getProperty((String)key);
            String[] sp = value.split(" ");
            HashSet<String> hs = new HashSet<String>();
            for (String s : sp) {
                if (s.length() <= 0) continue;
                hs.add(s);
            }
            registryNames.put((String)key, hs);
        }
    }

    private static Map<String, Object> readFontProperties(String name) throws IOException {
        name = name + ".properties";
        InputStream resource = ResourceUtil.getResourceStream(RESOURCE_PATH_CMAP + name);
        Properties p = new Properties();
        p.load(resource);
        resource.close();
        IntHashtable W = CidFontProperties.createMetric(p.getProperty("W"));
        p.remove("W");
        IntHashtable W2 = CidFontProperties.createMetric(p.getProperty("W2"));
        p.remove("W2");
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Object obj : p.keySet()) {
            map.put((String)obj, p.getProperty((String)obj));
        }
        map.put("W", W);
        map.put("W2", W2);
        return map;
    }

    private static IntHashtable createMetric(String s) {
        IntHashtable h = new IntHashtable();
        StringTokenizer tk = new StringTokenizer(s);
        while (tk.hasMoreTokens()) {
            int n1 = Integer.parseInt(tk.nextToken());
            h.put(n1, Integer.parseInt(tk.nextToken()));
        }
        return h;
    }

    static {
        try {
            CidFontProperties.loadRegistry();
            for (String font : registryNames.get("fonts")) {
                allFonts.put(font, CidFontProperties.readFontProperties(font));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

