/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.seal.base.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.com.itextpdf.io.source.RASInputStream;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDictionary;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfName;
import cfca.sadk.com.itextpdf.signatures.ITSAClient;
import cfca.sadk.com.itextpdf.signatures.PdfSigner;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.asn1.DERSet;
import cfca.sadk.seal.base.bean.sign.SignInfoConfig;
import cfca.sadk.seal.base.exception.SealException;
import cfca.sadk.seal.base.external.AbstractExternalP7Signer;
import cfca.sadk.seal.base.util.Constants;
import cfca.sadk.seal.base.util.MethodCostTimeUtil;
import cfca.sadk.seal.base.util.ParamsCheckUtil;
import cfca.sadk.seal.base.util.PdfHashUtil;
import cfca.sadk.system.Mechanisms;
import cfca.sadk.util.HashUtil;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;

public class CFCAP7AttributeSigner
extends AbstractExternalP7Signer {
    private static Logger businessLog = LoggerFactory.getLogger(CFCAP7AttributeSigner.class);
    protected Mechanism mechanism = null;
    protected Session session = null;
    protected X509Cert[] signCerts;
    protected X509Cert signCert = null;
    protected PrivateKey privatekey = null;
    protected boolean isContainChain = false;
    private int estimatedSize = 8192;
    private ITSAClient tsaClient = null;
    private boolean isAsyn = false;
    private byte[] hashValue = null;
    private byte[] originHash = null;
    private byte[] signAttr = null;

    public CFCAP7AttributeSigner(SignInfoConfig signatureConfig) throws SealException {
        ParamsCheckUtil.checkPrimaryParam(signatureConfig);
        this.signInfoConfig = signatureConfig;
        this.estimatedSize = signatureConfig.getPKCS7SigEstimatedSize();
        this.mechanism = signatureConfig.getSignAlg();
        this.privatekey = signatureConfig.getPrivateKey();
        this.session = this.getSession(signatureConfig.getSession());
        this.tsaClient = signatureConfig.getTsaClient();
        this.signCerts = signatureConfig.getCerts();
        ParamsCheckUtil.checkCertValidity(this.signCerts[0]);
        this.signCert = signatureConfig.getSignCert();
        this.isContainChain = signatureConfig.isP7ContainChain();
        this.isAsyn = signatureConfig.isAsyn();
    }

    @Override
    public void modifySigningDictionary(PdfDictionary signDic) {
        signDic.put(PdfName.Filter, PdfName.Adobe_PPKLite);
        if (Mechanisms.isSM2WithSM3((Mechanism)this.mechanism)) {
            signDic.put(PdfName.SubFilter, Constants.CFCA_SM2_FILTER);
        } else {
            signDic.put(PdfName.SubFilter, PdfName.Adbe_pkcs7_detached);
        }
    }

    @Override
    public byte[] sign(InputStream paramInputStream) throws GeneralSecurityException {
        byte[] hash = null;
        byte[] authenticatedAttributeHash = null;
        byte[] signedData = null;
        DERSet derSet = null;
        String methodid = MethodCostTimeUtil.recordStartTime("CFCAP7Signer.sign");
        try {
            byte[] authenticatedAttribute = null;
            if (Mechanisms.isSM2WithSM3((Mechanism)this.mechanism)) {
                SM2PublicKey sm2PublicKey = (SM2PublicKey)this.signCert.getPublicKey();
                if (sm2PublicKey == null) {
                    throw new GeneralSecurityException("sm2PublicKey is null");
                }
                hash = PdfHashUtil.calculateHashOfSourceData((RASInputStream)paramInputStream, this.mechanism, sm2PublicKey);
                derSet = this.getAuthenticatedAttributeSet(hash, this.signingTime, null, null, PdfSigner.CryptoStandard.CMS);
                authenticatedAttribute = derSet.getEncoded("DER");
                authenticatedAttributeHash = HashUtil.SM3HashData((byte[])authenticatedAttribute, (SM2PublicKey)sm2PublicKey, (Session)this.session, (boolean)true);
            } else {
                hash = PdfHashUtil.calculateHashOfSourceData((RASInputStream)paramInputStream, this.mechanism, null);
                derSet = this.getAuthenticatedAttributeSet(hash, this.signingTime, null, null, PdfSigner.CryptoStandard.CMS);
                authenticatedAttribute = derSet.getEncoded("DER");
                authenticatedAttributeHash = HashUtil.RSAHashData((byte[])authenticatedAttribute, (Mechanism)this.mechanism, (Session)this.session, (boolean)false);
            }
            this.signAttr = authenticatedAttribute;
            this.originHash = hash;
            byte[] timeStampPKCS7 = null;
            byte[] binarySignValue = new byte[64];
            X509Cert[] tmpSignCerts = this.signCerts;
            if (!this.isContainChain) {
                tmpSignCerts = new X509Cert[]{this.signCerts[0]};
            }
            if (this.isAsyn) {
                this.hashValue = authenticatedAttributeHash;
            } else {
                binarySignValue = this.session.signByHash(this.mechanism, this.privatekey, authenticatedAttributeHash);
            }
            timeStampPKCS7 = this.getTimeStamp(this.tsaClient, this.SM2RStoASN1(binarySignValue));
            signedData = this.packagePKCS7(this.session, null, binarySignValue, this.mechanism, timeStampPKCS7, derSet, tmpSignCerts);
            this.estimatedSize = signedData.length;
            byte[] byArray = signedData;
            return byArray;
        }
        catch (Exception e) {
            businessLog.error("CFCAP7AttributeSigner sign failed", (Throwable)e);
            throw new GeneralSecurityException("CFCAP7AttributeSigner sign failed", e);
        }
        finally {
            MethodCostTimeUtil.recordEndTime(methodid);
        }
    }

    @Override
    public int getEstimatedSize() {
        return this.estimatedSize + 64;
    }

    @Override
    public byte[] getHashValue() {
        return this.hashValue;
    }

    public byte[] getOriginHash() {
        return this.originHash;
    }

    public void setSignAttr(byte[] signAttr) {
        this.signAttr = signAttr;
    }

    public byte[] getSignAttr() {
        return this.signAttr;
    }
}

