/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.sec;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.sm2.SM2PrivateKey;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.asn1.sm2.ASN1SM2Cipher;
import cfca.sadk.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.SM2Params;
import cfca.sadk.org.bouncycastle.jce.interfaces.ECPrivateKey;
import cfca.sadk.org.bouncycastle.jce.interfaces.ECPublicKey;
import cfca.sadk.system.SADKDebugger;
import cfca.sadk.tls.sun.security.ssl.sec.CryptoFactory;
import java.io.IOException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;

public final class SM2Helper {
    private static final Logger logger = LoggerFactory.getLogger(SM2Helper.class);
    static final Mechanism mechanism_sm2 = new Mechanism("SM2");

    private SM2Helper() {
    }

    public static final byte[] encrypt(SecureRandom secureRandom, PublicKey encryptionKey, byte[] data) throws SignatureException, IOException {
        if (logger.isInfoEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("SM2Helper encrypt>>>>>>Running");
            buffer.append("\n encryptionKey: ");
            buffer.append(SADKDebugger.dump((PublicKey)encryptionKey));
            buffer.append("\n data: ");
            buffer.append(SADKDebugger.dump((byte[])data));
            logger.info(buffer.toString());
        }
        try {
            SM2PublicKey k = null;
            if (encryptionKey instanceof SM2PublicKey) {
                k = (SM2PublicKey)encryptionKey;
            } else if (encryptionKey instanceof ECPublicKey) {
                k = new SM2PublicKey(new ECPublicKeyParameters(((ECPublicKey)encryptionKey).getQ(), SM2Params.sm2DomainParameters));
            } else {
                throw new SignatureException("encrypt failure: invalid encryptionKey");
            }
            try {
                Session session = CryptoFactory.singleton().session();
                byte[] encoded = session.encrypt(mechanism_sm2, (Key)k, data);
                ASN1SM2Cipher sm2Cipher = ASN1SM2Cipher.getInstance((Object)encoded);
                return sm2Cipher.getEncoded("DER");
            }
            catch (SecurityException e) {
                throw new SignatureException(e);
            }
            catch (PKIException e) {
                e.printStackTrace();
                throw new SignatureException(e);
            }
        }
        catch (SignatureException e) {
            if (logger.isErrorEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("SM2Helper encrypt>>>>>>Failure");
                buffer.append("\n encryptionKey: ");
                buffer.append(SADKDebugger.dump((PublicKey)encryptionKey));
                buffer.append("\n data: ");
                buffer.append(SADKDebugger.dump((byte[])data));
                logger.error(buffer.toString());
            }
            throw e;
        }
    }

    public static final byte[] decrypt(PrivateKey encryptionKey, byte[] data) throws SignatureException, IOException {
        if (logger.isInfoEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("SM2Helper decrypt>>>>>>Running");
            buffer.append("\n encryptionKey: ");
            buffer.append(SADKDebugger.dump((PrivateKey)encryptionKey));
            buffer.append("\n data: ");
            buffer.append(SADKDebugger.dump((byte[])data));
            logger.info(buffer.toString());
        }
        try {
            SM2PrivateKey k = null;
            if (encryptionKey instanceof SM2PrivateKey) {
                k = (SM2PrivateKey)encryptionKey;
            } else if (encryptionKey instanceof ECPrivateKey) {
                k = new SM2PrivateKey(((ECPrivateKey)encryptionKey).getD(), null, null);
            } else {
                throw new SignatureException("encrypt failure: invalid encryptionKey");
            }
            try {
                Session session = CryptoFactory.singleton().session();
                return session.decrypt(mechanism_sm2, (Key)k, data);
            }
            catch (SecurityException e) {
                throw new SignatureException(e);
            }
            catch (PKIException e) {
                e.printStackTrace();
                throw new SignatureException(e);
            }
        }
        catch (SignatureException e) {
            if (logger.isErrorEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("SM2Helper decrypt>>>>>>Failure");
                buffer.append("\n encryptionKey: ");
                buffer.append(SADKDebugger.dump((PrivateKey)encryptionKey));
                buffer.append("\n data: ");
                buffer.append(SADKDebugger.dump((byte[])data));
                logger.error(buffer.toString());
            }
            throw e;
        }
    }
}

