/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.base.asn1;

import cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.ASN1Object;
import cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.DERIA5String;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import java.util.Enumeration;

public class SES_Header
extends ASN1Object
implements PKCSObjectIdentifiers {
    private DERIA5String ID = new DERIA5String("ES");
    private ASN1Integer version = new ASN1Integer(4L);
    private DERIA5String Vid = new DERIA5String("CFCA");

    public SES_Header() {
    }

    public static SES_Header getInstance(Object o) {
        if (o instanceof SES_Header) {
            return (SES_Header)((Object)o);
        }
        if (o != null) {
            return new SES_Header(ASN1Sequence.getInstance((Object)o));
        }
        return null;
    }

    public SES_Header(DERIA5String iD, ASN1Integer version, DERIA5String vid) {
        this.ID = iD;
        this.version = version;
        this.Vid = vid;
    }

    public SES_Header(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.ID = (DERIA5String)e.nextElement();
        this.version = (ASN1Integer)e.nextElement();
        this.Vid = (DERIA5String)e.nextElement();
    }

    public DERIA5String getID() {
        return this.ID;
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public DERIA5String getVid() {
        return this.Vid;
    }

    public void setVersion(ASN1Integer version) {
        this.version = version;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)this.ID);
        v.add((ASN1Encodable)this.version);
        v.add((ASN1Encodable)this.Vid);
        return new DERSequence(v);
    }
}

