/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.prf;

import cfca.sadk.tls.i18n.JSSEMessage;

final class TlsProtocolVersion {
    final int majorVersion;
    final int minorVersion;

    TlsProtocolVersion(int majorVersion, int minorVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.checkVersions();
    }

    private final TlsProtocolVersion checkVersions() {
        if (this.majorVersion < 0 || this.majorVersion > 255) {
            throw new IllegalArgumentException(JSSEMessage.getMessage("cfca.sadk.tls.parameters.majorVersion", this.majorVersion));
        }
        if (this.minorVersion < 0 || this.minorVersion > 255) {
            throw new IllegalArgumentException(JSSEMessage.getMessage("cfca.sadk.tls.parameters.minorVersion", this.minorVersion));
        }
        return this;
    }

    public String toString() {
        return String.format("TlsProtocolVersion [majorVersion=%s, minorVersion=%s]", this.majorVersion, this.minorVersion);
    }

    public boolean isGreaterThanTLSv11() {
        return this.majorVersion >= 3 && this.minorVersion >= 2;
    }
}

