/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.google.typography.font.sfntly;

import cfca.sadk.com.google.typography.font.sfntly.Font;
import cfca.sadk.com.google.typography.font.sfntly.Tag;
import cfca.sadk.com.google.typography.font.sfntly.data.FontData;
import cfca.sadk.com.google.typography.font.sfntly.data.ReadableFontData;
import cfca.sadk.com.google.typography.font.sfntly.data.WritableFontData;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;

public final class FontFactory {
    private static final int LOOKAHEAD_SIZE = 4;
    private boolean fingerprint = false;
    List<Integer> tableOrdering;

    private FontFactory() {
    }

    public static FontFactory getInstance() {
        return new FontFactory();
    }

    public void fingerprintFont(boolean fingerprint) {
        this.fingerprint = fingerprint;
    }

    public boolean fingerprintFont() {
        return this.fingerprint;
    }

    public Font[] loadFonts(InputStream is) throws IOException {
        PushbackInputStream pbis = new PushbackInputStream(new BufferedInputStream(is), 4);
        if (FontFactory.isCollection(pbis)) {
            return this.loadCollection(pbis);
        }
        return new Font[]{this.loadSingleOTF(pbis)};
    }

    public Font.Builder[] loadFontsForBuilding(InputStream is) throws IOException {
        PushbackInputStream pbis = new PushbackInputStream(new BufferedInputStream(is), 4);
        if (FontFactory.isCollection(pbis)) {
            return this.loadCollectionForBuilding(pbis);
        }
        return new Font.Builder[]{this.loadSingleOTFForBuilding(pbis)};
    }

    private Font loadSingleOTF(InputStream is) throws IOException {
        return this.loadSingleOTFForBuilding(is).build();
    }

    private Font[] loadCollection(InputStream is) throws IOException {
        Font.Builder[] builders = this.loadCollectionForBuilding(is);
        Font[] fonts = new Font[builders.length];
        for (int i = 0; i < fonts.length; ++i) {
            fonts[i] = builders[i].build();
        }
        return fonts;
    }

    private Font.Builder loadSingleOTFForBuilding(InputStream is) throws IOException {
        MessageDigest digest = null;
        if (this.fingerprintFont()) {
            try {
                digest = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException("Unable to get requested message digest algorithm.", e);
            }
            DigestInputStream dis = new DigestInputStream(is, digest);
            is = dis;
        }
        Font.Builder builder = Font.Builder.getOTFBuilder(this, is);
        if (this.fingerprintFont()) {
            builder.setDigest(digest.digest());
        }
        return builder;
    }

    private Font.Builder[] loadCollectionForBuilding(InputStream is) throws IOException {
        WritableFontData wfd = WritableFontData.createWritableFontData(is.available());
        wfd.copyFrom(is);
        return this.loadCollectionForBuilding(wfd);
    }

    private static boolean isCollection(PushbackInputStream pbis) throws IOException {
        byte[] tag = new byte[4];
        pbis.read(tag);
        pbis.unread(tag);
        return Tag.ttcf == Tag.intValue(tag);
    }

    public Font[] loadFonts(byte[] b) throws IOException {
        WritableFontData rfd = WritableFontData.createWritableFontData(b);
        if (FontFactory.isCollection(rfd)) {
            return this.loadCollection(rfd);
        }
        return new Font[]{this.loadSingleOTF(rfd)};
    }

    public Font.Builder[] loadFontsForBuilding(byte[] b) throws IOException {
        WritableFontData wfd = WritableFontData.createWritableFontData(b);
        if (FontFactory.isCollection(wfd)) {
            return this.loadCollectionForBuilding(wfd);
        }
        return new Font.Builder[]{this.loadSingleOTFForBuilding(wfd, 0)};
    }

    private Font loadSingleOTF(WritableFontData wfd) throws IOException {
        return this.loadSingleOTFForBuilding(wfd, 0).build();
    }

    private Font[] loadCollection(WritableFontData wfd) throws IOException {
        Font.Builder[] builders = this.loadCollectionForBuilding(wfd);
        Font[] fonts = new Font[builders.length];
        for (int i = 0; i < fonts.length; ++i) {
            fonts[i] = builders[i].build();
        }
        return fonts;
    }

    private Font.Builder loadSingleOTFForBuilding(WritableFontData wfd, int offsetToOffsetTable) throws IOException {
        Object digest = null;
        if (this.fingerprintFont()) {
            // empty if block
        }
        Font.Builder builder = Font.Builder.getOTFBuilder(this, wfd, offsetToOffsetTable);
        return builder;
    }

    private Font.Builder[] loadCollectionForBuilding(WritableFontData wfd) throws IOException {
        int ttcTag = wfd.readULongAsInt(Offset.TTCTag.offset);
        long version = wfd.readFixed(Offset.Version.offset);
        int numFonts = wfd.readULongAsInt(Offset.numFonts.offset);
        Font.Builder[] builders = new Font.Builder[numFonts];
        int offsetTableOffset = Offset.OffsetTable.offset;
        int fontNumber = 0;
        while (fontNumber < numFonts) {
            int offset = wfd.readULongAsInt(offsetTableOffset);
            builders[fontNumber] = this.loadSingleOTFForBuilding(wfd, offset);
            ++fontNumber;
            offsetTableOffset += FontData.DataSize.ULONG.size();
        }
        return builders;
    }

    private static boolean isCollection(ReadableFontData rfd) {
        byte[] tag = new byte[4];
        rfd.readBytes(0, tag, 0, tag.length);
        return Tag.ttcf == Tag.intValue(tag);
    }

    public void serializeFont(Font font, OutputStream os) throws IOException {
        font.serialize(os, this.tableOrdering);
    }

    public void setSerializationTableOrdering(List<Integer> tableOrdering) {
        this.tableOrdering = new ArrayList<Integer>(tableOrdering);
    }

    public Font.Builder newFontBuilder() {
        return Font.Builder.getOTFBuilder(this);
    }

    private static enum Offset {
        TTCTag(0),
        Version(4),
        numFonts(8),
        OffsetTable(12),
        ulDsigTag(0),
        ulDsigLength(4),
        ulDsigOffset(8);

        private final int offset;

        private Offset(int offset) {
            this.offset = offset;
        }
    }
}

