/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.google.typography.font.tools.conversion.woff;

import cfca.sadk.com.google.typography.font.sfntly.Font;
import cfca.sadk.com.google.typography.font.sfntly.Tag;
import cfca.sadk.com.google.typography.font.sfntly.data.FontData;
import cfca.sadk.com.google.typography.font.sfntly.data.WritableFontData;
import cfca.sadk.com.google.typography.font.sfntly.table.FontDataTable;
import cfca.sadk.com.google.typography.font.sfntly.table.Table;
import cfca.sadk.com.google.typography.font.sfntly.table.core.FontHeaderTable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import java.util.zip.Deflater;

public class WoffWriter {
    protected boolean woff_compression_faster = false;
    private static final long SIGNATURE = 2001684038L;
    private static final int WOFF_HEADER_SIZE = 9 * FontData.DataSize.ULONG.size() + 4 * FontData.DataSize.USHORT.size();

    public WritableFontData convert(Font font) {
        List<TableDirectoryEntry> tableDirectoryEntries = this.createTableDirectoryEntries(font);
        int length = WOFF_HEADER_SIZE + this.computeTableDirectoryEntriesLength(tableDirectoryEntries) + this.computeTablesLength(tableDirectoryEntries);
        WritableFontData writableFontData = WritableFontData.createWritableFontData(length);
        int index = 0;
        index += this.writeWoffHeader(writableFontData, index, tableDirectoryEntries, font.sfntVersion(), length, this.extractMajorVersion(font), this.extractMinorVersion(font));
        index += this.writeTableDirectoryEntries(writableFontData, index, tableDirectoryEntries);
        index += this.writeTables(writableFontData, index, tableDirectoryEntries);
        return writableFontData;
    }

    private int extractMajorVersion(Font font) {
        FontHeaderTable head = (FontHeaderTable)font.getTable(Tag.head);
        return head.fontRevision() >> 16 & 0xFFFF;
    }

    private int extractMinorVersion(Font sfntlyFont) {
        FontHeaderTable head = (FontHeaderTable)sfntlyFont.getTable(Tag.head);
        return head.fontRevision() & 0xFFFF;
    }

    private int align4(int value) {
        return value + 3 & 0xFFFFFFFC;
    }

    private int computeTableDirectoryEntriesLength(List<TableDirectoryEntry> tableDirectoryEntries) {
        return TableDirectoryEntry.ENTRY_SIZE * tableDirectoryEntries.size();
    }

    private int computeTablesLength(List<TableDirectoryEntry> tableDirectoryEntries) {
        int length = 0;
        for (TableDirectoryEntry entry : tableDirectoryEntries) {
            length += entry.getCompressedTableLength();
            length = this.align4(length);
        }
        return length;
    }

    private int writeWoffHeader(WritableFontData writableFontData, int start, List<TableDirectoryEntry> tableDirectoryEntries, int flavor, int length, int majorVersion, int minorVersion) {
        int index = start;
        index += writableFontData.writeULong(index, 2001684038L);
        index += writableFontData.writeULong(index, flavor);
        index += writableFontData.writeULong(index, length);
        index += writableFontData.writeUShort(index, tableDirectoryEntries.size());
        index += writableFontData.writeUShort(index, 0);
        index += writableFontData.writeULong(index, this.computeUncompressedTablesLength(tableDirectoryEntries) + this.computeTableSfntHeaderLength(tableDirectoryEntries));
        index += writableFontData.writeUShort(index, 1);
        index += writableFontData.writeUShort(index, 1);
        index += writableFontData.writeULong(index, 0L);
        index += writableFontData.writeULong(index, 0L);
        index += writableFontData.writeULong(index, 0L);
        index += writableFontData.writeULong(index, 0L);
        index += writableFontData.writeULong(index, 0L);
        return WOFF_HEADER_SIZE;
    }

    private int computeTableSfntHeaderLength(List<TableDirectoryEntry> tableDirectoryEntries) {
        return FontData.DataSize.ULONG.size() + 4 * FontData.DataSize.USHORT.size() + 4 * FontData.DataSize.ULONG.size() * tableDirectoryEntries.size();
    }

    private int computeUncompressedTablesLength(List<TableDirectoryEntry> tableDirectoryEntries) {
        int length = 0;
        for (TableDirectoryEntry entry : tableDirectoryEntries) {
            length = (int)((long)length + entry.getUncompressedTableLength());
            length = this.align4(length);
        }
        return length;
    }

    private int writeTableDirectoryEntries(WritableFontData writableFontData, int start, List<TableDirectoryEntry> tableDirectoryEntries) {
        int index = start;
        int tableOffset = this.align4(start + this.computeTableDirectoryEntriesLength(tableDirectoryEntries));
        for (TableDirectoryEntry entry : tableDirectoryEntries) {
            index += entry.writeEntry(writableFontData, tableOffset, index);
            tableOffset += entry.getCompressedTableLength();
            tableOffset = this.align4(tableOffset);
        }
        return this.computeTableDirectoryEntriesLength(tableDirectoryEntries);
    }

    private int writeTables(WritableFontData writableFontData, int start, List<TableDirectoryEntry> tableDirectoryEntries) {
        int index = this.align4(start);
        for (TableDirectoryEntry entry : tableDirectoryEntries) {
            index += entry.writeTable(writableFontData, index);
            index = this.align4(index);
        }
        return index - start;
    }

    private List<TableDirectoryEntry> createTableDirectoryEntries(Font font) {
        ArrayList<TableDirectoryEntry> tableDirectoryEntries = new ArrayList<TableDirectoryEntry>();
        TreeSet<Integer> tags = new TreeSet<Integer>(font.tableMap().keySet());
        tags.remove(Tag.DSIG);
        for (int tag : tags) {
            Object table = font.getTable(tag);
            TableDirectoryEntry tableDirectoryEntry = new TableDirectoryEntry();
            tableDirectoryEntry.setTag(tag);
            tableDirectoryEntry.setOrigLength(((FontDataTable)table).dataLength());
            tableDirectoryEntry.setOrigChecksum(((Table)table).calculatedChecksum());
            this.setCompressedTableData(tableDirectoryEntry, (Table)table);
            tableDirectoryEntries.add(tableDirectoryEntry);
        }
        return tableDirectoryEntries;
    }

    private void setCompressedTableData(TableDirectoryEntry tableDirectoryEntry, Table table) {
        int length = table.dataLength();
        byte[] input = new byte[length];
        table.readFontData().readBytes(0, input, 0, length);
        if (this.woff_compression_faster && (length < 100 || table.headerTag() == Tag.loca)) {
            tableDirectoryEntry.setCompTable(input);
        } else {
            byte[] output = new byte[length];
            Deflater compresser = new Deflater();
            compresser.setInput(input);
            compresser.finish();
            int compLength = compresser.deflate(output);
            tableDirectoryEntry.setCompTable(compLength == length || !compresser.finished() ? input : Arrays.copyOfRange(output, 0, compLength));
        }
    }

    private static class TableDirectoryEntry {
        public static final int ENTRY_SIZE = 5 * FontData.DataSize.ULONG.size();
        private long tag;
        private long origLength;
        private long origChecksum;
        private byte[] compTable;

        private TableDirectoryEntry() {
        }

        public void setTag(int tag) {
            this.tag = tag;
        }

        public void setOrigLength(int origLength) {
            this.origLength = origLength;
        }

        public void setOrigChecksum(long origChecksum) {
            this.origChecksum = origChecksum;
        }

        public void setCompTable(byte[] compTable) {
            this.compTable = compTable;
        }

        public int getCompressedTableLength() {
            return this.compTable.length;
        }

        public long getUncompressedTableLength() {
            return this.origLength;
        }

        public int writeEntry(WritableFontData writableFontData, int tableOffset, int start) {
            int index = start;
            index += writableFontData.writeULong(index, this.tag);
            index += writableFontData.writeULong(index, tableOffset);
            index += writableFontData.writeULong(index, this.compTable.length);
            index += writableFontData.writeULong(index, this.origLength);
            index += writableFontData.writeULong(index, this.origChecksum);
            return ENTRY_SIZE;
        }

        public int writeTable(WritableFontData writableFontData, int index) {
            writableFontData.writeBytes(index, this.compTable, 0, this.compTable.length);
            return this.getCompressedTableLength();
        }
    }
}

