/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.kernel.pdf.tagutils;

import cfca.sadk.com.itextpdf.kernel.pdf.PdfArray;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDictionary;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfName;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfNumber;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfObject;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfString;
import cfca.sadk.com.itextpdf.kernel.pdf.tagging.PdfStructElem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class AccessibilityProperties
implements Serializable {
    private static final long serialVersionUID = 3139055327755008473L;
    protected String language;
    protected String actualText;
    protected String alternateDescription;
    protected String expansion;
    protected List<PdfDictionary> attributesList = new ArrayList<PdfDictionary>();

    public String getLanguage() {
        return this.language;
    }

    public AccessibilityProperties setLanguage(String language) {
        this.language = language;
        return this;
    }

    public String getActualText() {
        return this.actualText;
    }

    public AccessibilityProperties setActualText(String actualText) {
        this.actualText = actualText;
        return this;
    }

    public String getAlternateDescription() {
        return this.alternateDescription;
    }

    public AccessibilityProperties setAlternateDescription(String alternateDescription) {
        this.alternateDescription = alternateDescription;
        return this;
    }

    public String getExpansion() {
        return this.expansion;
    }

    public AccessibilityProperties setExpansion(String expansion) {
        this.expansion = expansion;
        return this;
    }

    public AccessibilityProperties addAttributes(PdfDictionary attributes) {
        this.attributesList.add(attributes);
        return this;
    }

    public AccessibilityProperties clearAttributes() {
        this.attributesList.clear();
        return this;
    }

    public List<PdfDictionary> getAttributesList() {
        return this.attributesList;
    }

    void setToStructElem(PdfStructElem elem) {
        List<PdfDictionary> newAttributesList;
        if (this.getActualText() != null) {
            elem.setActualText(new PdfString(this.getActualText(), "UnicodeBig"));
        }
        if (this.getAlternateDescription() != null) {
            elem.setAlt(new PdfString(this.getAlternateDescription(), "UnicodeBig"));
        }
        if (this.getExpansion() != null) {
            elem.setE(new PdfString(this.getExpansion(), "UnicodeBig"));
        }
        if (this.getLanguage() != null) {
            elem.setLang(new PdfString(this.getLanguage(), "UnicodeBig"));
        }
        if ((newAttributesList = this.getAttributesList()).size() > 0) {
            PdfObject attributesObject = elem.getAttributes(false);
            PdfObject combinedAttributes = this.combineAttributesList(attributesObject, newAttributesList, ((PdfDictionary)elem.getPdfObject()).getAsNumber(PdfName.R));
            elem.setAttributes(combinedAttributes);
        }
    }

    protected PdfObject combineAttributesList(PdfObject attributesObject, List<PdfDictionary> newAttributesList, PdfNumber revision) {
        PdfObject combinedAttributes;
        if (attributesObject instanceof PdfDictionary) {
            PdfArray combinedAttributesArray = new PdfArray();
            combinedAttributesArray.add(attributesObject);
            this.addNewAttributesToAttributesArray(newAttributesList, revision, combinedAttributesArray);
            combinedAttributes = combinedAttributesArray;
        } else if (attributesObject instanceof PdfArray) {
            PdfArray combinedAttributesArray = (PdfArray)attributesObject;
            this.addNewAttributesToAttributesArray(newAttributesList, revision, combinedAttributesArray);
            combinedAttributes = combinedAttributesArray;
        } else if (newAttributesList.size() == 1) {
            combinedAttributes = newAttributesList.get(0);
        } else {
            combinedAttributes = new PdfArray();
            this.addNewAttributesToAttributesArray(newAttributesList, revision, (PdfArray)combinedAttributes);
        }
        return combinedAttributes;
    }

    protected void addNewAttributesToAttributesArray(List<PdfDictionary> newAttributesList, PdfNumber revision, PdfArray attributesArray) {
        if (revision != null) {
            for (PdfDictionary attributes : newAttributesList) {
                attributesArray.add(attributes);
                attributesArray.add(revision);
            }
        } else {
            for (PdfDictionary newAttribute : newAttributesList) {
                attributesArray.add(newAttribute);
            }
        }
    }
}

