/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.kernel.utils;

import cfca.sadk.com.itextpdf.forms.PdfAcroForm;
import cfca.sadk.com.itextpdf.forms.fields.PdfFormField;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfArray;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDictionary;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDocument;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfName;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfObject;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfPage;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfString;
import cfca.sadk.com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import cfca.sadk.com.itextpdf.kernel.pdf.annot.PdfWidgetAnnotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class PdfMerger {
    private PdfDocument pdfDocument;
    private boolean closeSrcDocuments;
    private boolean mergeTags;
    private boolean mergeOutlines;
    private boolean mergeFields;
    private PdfAcroForm toAcroForm;
    private HashSet<String> mergedFieldSet;
    private ArrayList<PdfWidgetAnnotation> widgetAnnotationList;

    public PdfMerger(PdfDocument pdfDocument) {
        this(pdfDocument, true, true);
    }

    public PdfMerger(PdfDocument pdfDocument, boolean mergeTags, boolean mergeOutlines) {
        this.pdfDocument = pdfDocument;
        this.mergeTags = mergeTags;
        this.mergeOutlines = mergeOutlines;
    }

    public PdfMerger(PdfDocument pdfDocument, boolean mergeTags, boolean mergeOutlines, boolean mergeFields) {
        this.pdfDocument = pdfDocument;
        this.mergeTags = mergeTags;
        this.mergeOutlines = mergeOutlines;
        this.mergeFields = mergeFields;
    }

    public PdfMerger setMergeFields(boolean mergeFields) {
        this.mergeFields = mergeFields;
        return this;
    }

    public PdfMerger setCloseSourceDocuments(boolean closeSourceDocuments) {
        this.closeSrcDocuments = closeSourceDocuments;
        return this;
    }

    public PdfMerger merge(PdfDocument from, int fromPage, int toPage) {
        ArrayList<Integer> pages = new ArrayList<Integer>(toPage - fromPage);
        for (int pageNum = fromPage; pageNum <= toPage; ++pageNum) {
            pages.add(pageNum);
        }
        return this.merge(from, pages);
    }

    public PdfMerger merge(PdfDocument from, List<Integer> pages) {
        if (this.mergeTags && from.isTagged()) {
            this.pdfDocument.setTagged();
        }
        if (this.mergeOutlines && from.hasOutlines()) {
            this.pdfDocument.initializeOutlines();
        }
        from.copyPagesTo(pages, this.pdfDocument);
        if (this.mergeFields) {
            this.widgetAnnotationList = this.widgetAnnotationList != null ? this.widgetAnnotationList : new ArrayList();
            this.widgetAnnotationList.clear();
            int numberOfPages = this.pdfDocument.getNumberOfPages();
            for (int i = numberOfPages - pages.size() + 1; i <= numberOfPages; ++i) {
                PdfPage tmpPage = this.pdfDocument.getPage(i);
                List<PdfAnnotation> annotList = tmpPage.getAnnotations();
                int annotSize = annotList.size();
                for (int j = 0; j < annotSize; ++j) {
                    PdfAnnotation tmpAnnotation = annotList.get(j);
                    if (!(tmpAnnotation instanceof PdfWidgetAnnotation)) continue;
                    this.widgetAnnotationList.add((PdfWidgetAnnotation)tmpAnnotation);
                }
            }
            int widgetAnnotSize = this.widgetAnnotationList.size();
            if (widgetAnnotSize > 0) {
                this.toAcroForm = this.toAcroForm != null ? this.toAcroForm : PdfAcroForm.getAcroForm(this.pdfDocument, true);
                this.mergedFieldSet = this.mergedFieldSet != null ? this.mergedFieldSet : new HashSet();
                PdfAcroForm fromAcroForm = PdfAcroForm.getAcroForm(from, false);
                PdfDictionary fromFormDic = (PdfDictionary)fromAcroForm.getPdfObject();
                PdfDictionary toFormDic = fromFormDic.copyTo(this.pdfDocument);
                ((PdfDictionary)this.toAcroForm.getPdfObject()).mergeDifferent(toFormDic);
                for (int i = 0; i < widgetAnnotSize; ++i) {
                    PdfWidgetAnnotation widgetAnnotation = this.widgetAnnotationList.get(i);
                    PdfPage tmpPage = widgetAnnotation.getPage();
                    PdfDictionary tmpDic = (PdfDictionary)widgetAnnotation.getPdfObject();
                    PdfString fieldName = tmpDic.getAsString(PdfName.T);
                    if (null == fieldName) {
                        fieldName = tmpDic.getAsDictionary(PdfName.Parent).getAsString(PdfName.T);
                        tmpDic.put(PdfName.T, fieldName);
                    }
                    String fieldNameString = fieldName.toString();
                    boolean notExisted = this.mergedFieldSet.add(fieldNameString);
                    PdfFormField tmpFormField = PdfFormField.makeFormField(tmpDic, this.pdfDocument);
                    if (notExisted) {
                        this.toAcroForm.addField(tmpFormField, tmpPage);
                        continue;
                    }
                    PdfDictionary tmpParentDic = new PdfDictionary();
                    tmpParentDic.put(PdfName.T, new PdfString(fieldNameString));
                    tmpParentDic.put(PdfName.FT, PdfName.Tx);
                    tmpParentDic.makeIndirect(this.pdfDocument);
                    PdfFormField tmpParentFormField = PdfFormField.makeFormField(tmpParentDic, this.pdfDocument);
                    Map<String, PdfFormField> fieldMap = this.toAcroForm.getFormFields();
                    ArrayList<String> visited = new ArrayList<String>();
                    for (String tmpFieldNameString : fieldMap.keySet()) {
                        PdfFormField oldField;
                        if (!tmpFieldNameString.contains(fieldNameString) || null == (oldField = this.toAcroForm.getField(tmpFieldNameString))) continue;
                        ((PdfDictionary)oldField.getPdfObject()).remove(PdfName.T);
                        ((PdfDictionary)oldField.getPdfObject()).remove(PdfName.FT);
                        PdfArray fieldsArray = ((PdfDictionary)this.toAcroForm.getPdfObject()).getAsArray(PdfName.Fields);
                        fieldsArray.remove((PdfObject)oldField.getPdfObject());
                        visited.add(tmpFieldNameString);
                        PdfArray oldFieldArray = oldField.getKids();
                        if (null != oldFieldArray) continue;
                        tmpParentFormField.addKid(oldField);
                    }
                    int size = visited.size();
                    for (int j = 0; j < size; ++j) {
                        String tmpFieldName = (String)visited.get(j);
                        fieldMap.remove(tmpFieldName);
                    }
                    ((PdfDictionary)tmpFormField.getPdfObject()).remove(PdfName.T);
                    ((PdfDictionary)tmpFormField.getPdfObject()).remove(PdfName.FT);
                    PdfArray tmpFieldArray = tmpFormField.getKids();
                    if (null == tmpFieldArray) {
                        tmpParentFormField.addKid(tmpFormField);
                    }
                    this.toAcroForm.addField(tmpParentFormField, tmpPage);
                }
            }
        }
        if (this.closeSrcDocuments) {
            from.close();
        }
        return this;
    }

    private void addKidsFromArray(PdfFormField tmpParentFormField, PdfArray oldFieldArray) {
        int arraySize = oldFieldArray.size();
        for (int j = 0; j < arraySize; ++j) {
            PdfDictionary oldFieldDic = oldFieldArray.getAsDictionary(j);
            PdfFormField oldFormField = PdfFormField.makeFormField(oldFieldDic, this.pdfDocument);
            tmpParentFormField.addKid(oldFormField);
        }
    }

    public void close() {
        this.pdfDocument.close();
    }
}

