/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.styledxmlparser.node.impl.jsoup;

import cfca.sadk.com.itextpdf.io.util.MessageFormatUtil;
import cfca.sadk.com.itextpdf.styledxmlparser.IXmlParser;
import cfca.sadk.com.itextpdf.styledxmlparser.jsoup.Jsoup;
import cfca.sadk.com.itextpdf.styledxmlparser.jsoup.nodes.Comment;
import cfca.sadk.com.itextpdf.styledxmlparser.jsoup.nodes.DataNode;
import cfca.sadk.com.itextpdf.styledxmlparser.jsoup.nodes.Document;
import cfca.sadk.com.itextpdf.styledxmlparser.jsoup.nodes.DocumentType;
import cfca.sadk.com.itextpdf.styledxmlparser.jsoup.nodes.Element;
import cfca.sadk.com.itextpdf.styledxmlparser.jsoup.nodes.Node;
import cfca.sadk.com.itextpdf.styledxmlparser.jsoup.nodes.TextNode;
import cfca.sadk.com.itextpdf.styledxmlparser.jsoup.nodes.XmlDeclaration;
import cfca.sadk.com.itextpdf.styledxmlparser.node.IDocumentNode;
import cfca.sadk.com.itextpdf.styledxmlparser.node.INode;
import cfca.sadk.com.itextpdf.styledxmlparser.node.impl.jsoup.node.JsoupDataNode;
import cfca.sadk.com.itextpdf.styledxmlparser.node.impl.jsoup.node.JsoupDocumentNode;
import cfca.sadk.com.itextpdf.styledxmlparser.node.impl.jsoup.node.JsoupDocumentTypeNode;
import cfca.sadk.com.itextpdf.styledxmlparser.node.impl.jsoup.node.JsoupElementNode;
import cfca.sadk.com.itextpdf.styledxmlparser.node.impl.jsoup.node.JsoupNode;
import cfca.sadk.com.itextpdf.styledxmlparser.node.impl.jsoup.node.JsoupTextNode;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsoupXmlParser
implements IXmlParser {
    private static Logger logger = LoggerFactory.getLogger(JsoupXmlParser.class);

    @Override
    public IDocumentNode parse(InputStream xmlStream, String charset) throws IOException {
        String baseUri = "";
        Document doc = Jsoup.parseXML(xmlStream, charset, baseUri);
        INode result = this.wrapJsoupHierarchy(doc);
        if (result instanceof IDocumentNode) {
            return (IDocumentNode)result;
        }
        throw new IllegalStateException();
    }

    @Override
    public IDocumentNode parse(String xml) {
        Document doc = Jsoup.parseXML(xml);
        INode result = this.wrapJsoupHierarchy(doc);
        if (result instanceof IDocumentNode) {
            return (IDocumentNode)result;
        }
        throw new IllegalStateException();
    }

    private INode wrapJsoupHierarchy(Node jsoupNode) {
        JsoupNode resultNode = null;
        if (jsoupNode instanceof Document) {
            resultNode = new JsoupDocumentNode((Document)jsoupNode);
        } else if (jsoupNode instanceof TextNode) {
            resultNode = new JsoupTextNode((TextNode)jsoupNode);
        } else if (jsoupNode instanceof Element) {
            resultNode = new JsoupElementNode((Element)jsoupNode);
        } else if (jsoupNode instanceof DataNode) {
            resultNode = new JsoupDataNode((DataNode)jsoupNode);
        } else if (jsoupNode instanceof DocumentType) {
            resultNode = new JsoupDocumentTypeNode((DocumentType)jsoupNode);
        } else if (!(jsoupNode instanceof Comment) && !(jsoupNode instanceof XmlDeclaration)) {
            logger.error(MessageFormatUtil.format("Could not map node type: {0}", jsoupNode.getClass()));
        }
        for (Node node : jsoupNode.childNodes()) {
            INode childNode = this.wrapJsoupHierarchy(node);
            if (childNode == null) continue;
            resultNode.addChild(childNode);
        }
        return resultNode;
    }
}

