/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.seal.base.config;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.seal.base.exception.SealException;
import cfca.sadk.seal.base.util.CrlManager;
import cfca.sadk.x509.certificate.X509Cert;
import cfca.sadk.x509.certificate.X509CertVerifier;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class SysEnv {
    private static final Logger sysLog = LoggerFactory.getLogger(SysEnv.class);
    public static boolean isUseJNIForHash = true;
    public static int defaultDPI = 96;
    public static boolean supportSVG = false;
    public static boolean changeSVG = false;
    public static boolean checkFontSizeOverflow = false;
    public static int RSAP7TSALength = 3072;
    public static int SM2P7TSALength = 3072;
    public static int diskPdfFileLength = 0x200000;
    private static boolean crlLoaded = false;
    private static int maxCRLRecode = 500000;
    private static boolean trustCertLoaded = false;
    private static float minRectWidth = 0.0f;
    private static boolean acro6Layers = false;
    private static boolean useDPIChangeSize = true;

    public static boolean isUseJNIForHash() {
        return isUseJNIForHash;
    }

    public static void setUseJNIForHash(boolean isUseJNIForHash) {
        SysEnv.isUseJNIForHash = isUseJNIForHash;
    }

    public static int getDefaultDPI() {
        return defaultDPI;
    }

    public static void setDefaultDPI(int defaultDPI) {
        SysEnv.defaultDPI = defaultDPI;
    }

    public static boolean isCheckFontSizeOverflow() {
        return checkFontSizeOverflow;
    }

    public static void setCheckFontSizeOverflow(boolean checkFontSizeOverflow) {
        SysEnv.checkFontSizeOverflow = checkFontSizeOverflow;
    }

    public static boolean isSupportSVG() {
        return supportSVG;
    }

    public static void setSupportSVG(boolean supportSVG) {
        SysEnv.supportSVG = supportSVG;
    }

    public static int getDiskPdfFileLength() {
        return diskPdfFileLength;
    }

    public static void setDiskPdfFileLength(int diskPdfFileLength) {
        SysEnv.diskPdfFileLength = diskPdfFileLength;
    }

    public static int getMaxCRLRecode() {
        return maxCRLRecode;
    }

    public static void setMaxCRLRecode(int maxCRLRecode) {
        SysEnv.maxCRLRecode = maxCRLRecode;
    }

    public static boolean isCrlLoaded() {
        return crlLoaded;
    }

    public static boolean isTrustCertLoaded() {
        return trustCertLoaded;
    }

    public static float getMinRectWidth() {
        return minRectWidth;
    }

    public static void setMinRectWidth(float minRectWidth) {
        SysEnv.minRectWidth = minRectWidth;
    }

    public static boolean isAcro6Layers() {
        return acro6Layers;
    }

    public static void setAcro6Layers(boolean acro6Layers) {
        SysEnv.acro6Layers = acro6Layers;
    }

    public static boolean isChangeSVG() {
        return changeSVG;
    }

    public static void setChangeSVG(boolean changeSVG) {
        SysEnv.changeSVG = changeSVG;
    }

    public static boolean isUseDPIChangeSize() {
        return useDPIChangeSize;
    }

    public static void setUseDPIChangeSize(boolean useDPIChangeSize) {
        SysEnv.useDPIChangeSize = useDPIChangeSize;
    }

    public static void loadCRL(String crlFilePath) throws PKIException, SealException, IOException {
        CrlManager.init(crlFilePath);
        crlLoaded = true;
        sysLog.info("CRL File is loaded,filePath is " + crlFilePath);
    }

    public static void loadTrustCerts(String trustCertPath) throws PKIException {
        if (null == trustCertPath || trustCertPath.isEmpty()) {
            throw new IllegalArgumentException("trustCertPath is null!");
        }
        File trustCertDir = new File(trustCertPath);
        ArrayList<X509Cert> trustCertList = new ArrayList<X509Cert>();
        if (trustCertDir.isDirectory()) {
            File[] files = trustCertDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].getName().toLowerCase().endsWith(".cer")) continue;
                String filePath = files[i].getAbsolutePath();
                trustCertList.add(new X509Cert(filePath));
            }
        }
        if (trustCertList.size() == 0) {
            throw new IllegalArgumentException(trustCertPath + " is empty,trustCert File is not loaded");
        }
        for (int j = 0; j < trustCertList.size(); ++j) {
            X509CertVerifier.updateTrustCertsMap((X509Cert)((X509Cert)trustCertList.get(j)));
            trustCertLoaded = true;
        }
        sysLog.info("trustCert File is loaded,filePath is " + trustCertPath);
    }
}

