/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.signature.decoder;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKCSObjectIdentifiers;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.asn1.parser.ASN1Node;
import cfca.sadk.asn1.parser.PKCS7SignFileParser;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.pkcs.SignedData;
import cfca.sadk.org.bouncycastle.asn1.pkcs.SignerInfo;
import cfca.sadk.signature.decoder.AbstractPKCS7Decoder;
import cfca.sadk.signature.rsa.RSAHashUtil;
import cfca.sadk.system.Mechanisms;
import cfca.sadk.util.HashUtil;
import java.io.InputStream;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PKCS7ECCDecoder
extends AbstractPKCS7Decoder {
    private static final Map<String, String> ECC_SIGNALG = PKCS7ECCDecoder.buildAlgs();

    public PKCS7ECCDecoder(Session session, SignedData signedData, boolean isSM2Type) throws PKIException {
        super(session, signedData, isSM2Type);
    }

    public PKCS7ECCDecoder(Session session, PKCS7SignFileParser signedFile, boolean isSM2Type) throws PKIException {
        super(session, signedFile, isSM2Type);
    }

    @Override
    final boolean isSM2Type() {
        return false;
    }

    @Override
    final byte[] getSignValue() throws PKIException {
        return SignerInfo.getInstance(this.signerInfo).getEncryptedDigest().getOctets();
    }

    @Override
    final AbstractPKCS7Decoder.SignHashAlgorithm getSignHashAlgorithm() throws PKIException {
        SignerInfo signerInfo = SignerInfo.getInstance(this.signerInfo);
        ASN1ObjectIdentifier encryptionId = signerInfo.getDigestEncryptionAlgorithm().getAlgorithm();
        String signAlg = this.getSignAlg(encryptionId);
        ASN1ObjectIdentifier digestId = signerInfo.getDigestAlgorithm().getAlgorithm();
        String hashAlg = Mechanisms.getDigestAlgorithmName(digestId);
        if (hashAlg == null) {
            throw new PKIException(PKIException.UNSUPPORT_ENCRYPT_ALG_SIGNANDENVELOP_ERR, "do not support digestId=" + digestId);
        }
        return new AbstractPKCS7Decoder.SignHashAlgorithm(new Mechanism(signAlg), hashAlg);
    }

    @Override
    final byte[] hashData(String digestAlgorithm, byte[] sourceData, PublicKey pubKey) throws PKIException {
        try {
            boolean forJNILib = this.session != null && this.session.useJniNativeOperation();
            byte[] hashValue = null;
            hashValue = forJNILib ? HashUtil.RSAHashMessageByJNI(sourceData, new Mechanism(digestAlgorithm), false) : HashUtil.RSAHashMessageByBC(sourceData, new Mechanism(digestAlgorithm), false);
            return hashValue;
        }
        catch (Exception e) {
            throw new PKIException(PKIException.VERIFY_P7_SIGNEDDATA_ERR_DES, "sourceHash do not successfully", e);
        }
    }

    @Override
    final byte[] hashData(String digestAlgorithm, InputStream sourceData, PublicKey pubKey) throws PKIException {
        try {
            return RSAHashUtil.calculateDigest(digestAlgorithm, sourceData, this.session);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.VERIFY_P7_SIGNEDDATA_ERR_DES, "sourceHash do not successfully", e);
        }
    }

    @Override
    byte[] hashData(String digestAlgorithm, ASN1Node sourceNode, PublicKey pubKey, String sourceFileOutputPath) throws PKIException {
        try {
            return RSAHashUtil.calculateDigest(digestAlgorithm, sourceNode, sourceFileOutputPath, this.session);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.VERIFY_P7_SIGNEDDATA_ERR_DES, "sourceHash do not successfully", e);
        }
    }

    private String getSignAlg(ASN1ObjectIdentifier encryptionId) throws PKIException {
        if (encryptionId == null) {
            throw new PKIException(PKIException.UNSUPPORT_ENCRYPT_ALG_SIGNANDENVELOP_ERR, "do not support encryptionId=" + encryptionId);
        }
        String signAlg = ECC_SIGNALG.get(encryptionId.getId());
        if (signAlg == null) {
            throw new PKIException(PKIException.UNSUPPORT_ENCRYPT_ALG_SIGNANDENVELOP_ERR, "do not support encryptionId=" + encryptionId);
        }
        return signAlg;
    }

    private static final Map<String, String> buildAlgs() {
        HashMap<String, String> signAlgMappings = new HashMap<String, String>();
        signAlgMappings.put(PKCSObjectIdentifiers.sha1WithECEncryption.getId(), "sha1WithECDSAEncryption");
        signAlgMappings.put(PKCSObjectIdentifiers.sha256WithECEncryption.getId(), "sha256WithECDSAEncryption");
        signAlgMappings.put(PKCSObjectIdentifiers.sha384WithECEncryption.getId(), "sha384WithECDSAEncryption");
        signAlgMappings.put(PKCSObjectIdentifiers.sha512WithECEncryption.getId(), "sha512WithECDSAEncryption");
        return signAlgMappings;
    }
}

