/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.util;

import cfca.sadk.tls.java.security.CFCAAlgorithmConstraints;
import cfca.sadk.tls.java.security.CFCACryptoPrimitive;
import cfca.sadk.tls.sun.security.util.CFCAKeyHelper;
import java.security.AccessController;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.PrivilegedAction;
import java.security.Security;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CFCADisabledAlgorithmConstraints
implements CFCAAlgorithmConstraints {
    public static final String PROPERTY_CERTPATH_DISABLED_ALGS = "jdk.certpath.disabledAlgorithms";
    public static final String PROPERTY_TLS_DISABLED_ALGS = "jdk.tls.disabledAlgorithms";
    private static final Map<String, String[]> disabledAlgorithmsMap = new HashMap<String, String[]>();
    private static final Map<String, KeySizeConstraints> keySizeConstraintsMap = new HashMap<String, KeySizeConstraints>();
    private String[] disabledAlgorithms;
    private KeySizeConstraints keySizeConstraints;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CFCADisabledAlgorithmConstraints(String propertyName) {
        Map<String, String[]> map = disabledAlgorithmsMap;
        synchronized (map) {
            if (!disabledAlgorithmsMap.containsKey(propertyName)) {
                CFCADisabledAlgorithmConstraints.loadDisabledAlgorithmsMap(propertyName);
            }
            this.disabledAlgorithms = disabledAlgorithmsMap.get(propertyName);
            this.keySizeConstraints = keySizeConstraintsMap.get(propertyName);
        }
    }

    @Override
    public final boolean permits(Set<CFCACryptoPrimitive> primitives, String algorithm, AlgorithmParameters parameters) {
        if (algorithm == null || algorithm.length() == 0) {
            throw new IllegalArgumentException("No algorithm name specified");
        }
        if (primitives == null || primitives.isEmpty()) {
            throw new IllegalArgumentException("No cryptographic primitive specified");
        }
        Set<String> components = null;
        for (String disabled : this.disabledAlgorithms) {
            if (disabled == null || disabled.length() == 0) continue;
            if (disabled.equalsIgnoreCase(algorithm)) {
                return false;
            }
            if (components == null) {
                components = this.decomposes(algorithm);
            }
            for (String element : components) {
                if (!disabled.equalsIgnoreCase(element)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public final boolean permits(Set<CFCACryptoPrimitive> primitives, Key key) {
        return this.checkConstraints(primitives, "", key, null);
    }

    @Override
    public final boolean permits(Set<CFCACryptoPrimitive> primitives, String algorithm, Key key, AlgorithmParameters parameters) {
        if (algorithm == null || algorithm.length() == 0) {
            throw new IllegalArgumentException("No algorithm name specified");
        }
        return this.checkConstraints(primitives, algorithm, key, parameters);
    }

    protected Set<String> decomposes(String algorithm) {
        if (algorithm == null || algorithm.length() == 0) {
            return new HashSet<String>();
        }
        Pattern transPattern = Pattern.compile("/");
        String[] transTockens = transPattern.split(algorithm);
        HashSet<String> components = new HashSet<String>();
        for (String transTocken : transTockens) {
            String[] tokens;
            if (transTocken == null || transTocken.length() == 0) continue;
            Pattern pattern = Pattern.compile("with|and", 2);
            for (String token : tokens = pattern.split(transTocken)) {
                if (token == null || token.length() == 0 || components.contains(token)) continue;
                components.add(token);
            }
        }
        this.registeredHashAliasname(components, "SHA1", "SHA-1");
        this.registeredHashAliasname(components, "SHA224", "SHA-224");
        this.registeredHashAliasname(components, "SHA256", "SHA-256");
        this.registeredHashAliasname(components, "SHA384", "SHA-384");
        this.registeredHashAliasname(components, "SHA512", "SHA-512");
        return components;
    }

    private final void registeredHashAliasname(Set<String> elements, String hashName, String hashAlias) {
        if (elements.contains(hashName) && !elements.contains(hashAlias)) {
            elements.add(hashAlias);
        }
        if (elements.contains(hashAlias) && !elements.contains(hashName)) {
            elements.add(hashName);
        }
    }

    private boolean checkConstraints(Set<CFCACryptoPrimitive> primitives, String algorithm, Key key, AlgorithmParameters parameters) {
        if (key == null) {
            throw new IllegalArgumentException("The key cannot be null");
        }
        if (algorithm != null && algorithm.length() != 0 && !this.permits(primitives, algorithm, parameters)) {
            return false;
        }
        if (!this.permits(primitives, key.getAlgorithm(), null)) {
            return false;
        }
        return !this.keySizeConstraints.disables(key);
    }

    private static void loadDisabledAlgorithmsMap(final String propertyName) {
        String property = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return Security.getProperty(propertyName);
            }
        });
        String[] algorithmsInProperty = null;
        if (property != null && property.length() != 0) {
            int endIndex = property.length() - 1;
            if (property.charAt(0) == '\"' && property.charAt(endIndex) == '\"') {
                property = property.substring(1, endIndex);
            }
            algorithmsInProperty = property.split(",");
            for (int i = 0; i < algorithmsInProperty.length; ++i) {
                algorithmsInProperty[i] = algorithmsInProperty[i].trim();
            }
        }
        if (algorithmsInProperty == null) {
            algorithmsInProperty = new String[]{};
        }
        disabledAlgorithmsMap.put(propertyName, algorithmsInProperty);
        keySizeConstraintsMap.put(propertyName, new KeySizeConstraints(algorithmsInProperty));
    }

    private static class KeySizeConstraint {
        private int minSize;
        private int maxSize;
        private int prohibitedSize = -1;

        public KeySizeConstraint(Operator operator, int length) {
            switch (operator) {
                case EQ: {
                    this.minSize = 0;
                    this.maxSize = Integer.MAX_VALUE;
                    this.prohibitedSize = length;
                    break;
                }
                case NE: {
                    this.minSize = length;
                    this.maxSize = length;
                    break;
                }
                case LT: {
                    this.minSize = length;
                    this.maxSize = Integer.MAX_VALUE;
                    break;
                }
                case LE: {
                    this.minSize = length + 1;
                    this.maxSize = Integer.MAX_VALUE;
                    break;
                }
                case GT: {
                    this.minSize = 0;
                    this.maxSize = length;
                    break;
                }
                case GE: {
                    this.minSize = 0;
                    this.maxSize = length > 1 ? length - 1 : 0;
                    break;
                }
                default: {
                    this.minSize = Integer.MAX_VALUE;
                    this.maxSize = -1;
                }
            }
        }

        public boolean disables(Key key) {
            int size = CFCAKeyHelper.getKeySize(key);
            if (size == 0) {
                return true;
            }
            if (size > 0) {
                return size < this.minSize || size > this.maxSize || this.prohibitedSize == size;
            }
            return false;
        }

        static enum Operator {
            EQ,
            NE,
            LT,
            LE,
            GT,
            GE;


            static Operator of(String s) {
                if (s == null) {
                    throw new IllegalArgumentException(s + " is not a legal Operator");
                }
                if ("==".equals(s)) {
                    return EQ;
                }
                if ("!=".equals(s)) {
                    return NE;
                }
                if ("<".equals(s)) {
                    return LT;
                }
                if ("<=".equals(s)) {
                    return LE;
                }
                if (">".equals(s)) {
                    return GT;
                }
                if (">=".equals(s)) {
                    return GE;
                }
                throw new IllegalArgumentException(s + " is not a legal Operator");
            }
        }
    }

    private static class KeySizeConstraints {
        private static final Pattern pattern = Pattern.compile("(\\S+)\\s+keySize\\s*(<=|<|==|!=|>|>=)\\s*(\\d+)");
        private Map<String, Set<KeySizeConstraint>> constraintsMap = Collections.synchronizedMap(new HashMap());

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public KeySizeConstraints(String[] restrictions) {
            for (String restriction : restrictions) {
                Matcher matcher;
                if (restriction == null || restriction.length() == 0 || !(matcher = pattern.matcher(restriction)).matches()) continue;
                String algorithm = matcher.group(1);
                KeySizeConstraint.Operator operator = KeySizeConstraint.Operator.of(matcher.group(2));
                int length = Integer.parseInt(matcher.group(3));
                algorithm = algorithm.toLowerCase(Locale.ENGLISH);
                Map<String, Set<KeySizeConstraint>> map = this.constraintsMap;
                synchronized (map) {
                    if (!this.constraintsMap.containsKey(algorithm)) {
                        this.constraintsMap.put(algorithm, new HashSet());
                    }
                    Set<KeySizeConstraint> constraintSet = this.constraintsMap.get(algorithm);
                    KeySizeConstraint constraint = new KeySizeConstraint(operator, length);
                    constraintSet.add(constraint);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean disables(Key key) {
            String algorithm = key.getAlgorithm().toLowerCase(Locale.ENGLISH);
            Map<String, Set<KeySizeConstraint>> map = this.constraintsMap;
            synchronized (map) {
                if (this.constraintsMap.containsKey(algorithm)) {
                    Set<KeySizeConstraint> constraintSet = this.constraintsMap.get(algorithm);
                    for (KeySizeConstraint constraint : constraintSet) {
                        if (!constraint.disables(key)) continue;
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

