/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.itextpdf.text.pdf;

import cfca.com.itextpdf.text.ExceptionConverter;
import cfca.com.itextpdf.text.pdf.AcroFields;
import cfca.com.itextpdf.text.pdf.ByteBuffer;
import cfca.com.itextpdf.text.pdf.PRStream;
import cfca.com.itextpdf.text.pdf.PdfArray;
import cfca.com.itextpdf.text.pdf.PdfDictionary;
import cfca.com.itextpdf.text.pdf.PdfIndirectReference;
import cfca.com.itextpdf.text.pdf.PdfName;
import cfca.com.itextpdf.text.pdf.PdfObject;
import cfca.com.itextpdf.text.pdf.PdfReader;
import cfca.com.itextpdf.text.pdf.PdfStream;
import cfca.com.itextpdf.text.pdf.PdfString;
import cfca.com.itextpdf.text.pdf.PdfWriter;
import cfca.com.itextpdf.text.xml.XmlDomWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XfaForm {
    private Xml2SomTemplate templateSom;
    private Node templateNode;
    private Xml2SomDatasets datasetsSom;
    private Node datasetsNode;
    private AcroFieldsSearch acroFieldsSom;
    private PdfReader reader;
    private boolean xfaPresent;
    private Document domDocument;
    private boolean changed;
    public static final String XFA_DATA_SCHEMA = "http://www.xfa.org/schema/xfa-data/1.0/";

    public XfaForm() {
    }

    public static PdfObject getXfaObject(PdfReader reader) {
        PdfDictionary af = (PdfDictionary)PdfReader.getPdfObjectRelease(reader.getCatalog().get(PdfName.ACROFORM));
        if (af == null) {
            return null;
        }
        return PdfReader.getPdfObjectRelease(af.get(PdfName.XFA));
    }

    public XfaForm(PdfReader reader) throws IOException, ParserConfigurationException, SAXException {
        this.reader = reader;
        PdfObject xfa = XfaForm.getXfaObject(reader);
        if (xfa == null) {
            this.xfaPresent = false;
            return;
        }
        this.xfaPresent = true;
        ByteBuffer bout = new ByteBuffer();
        if (xfa.isArray()) {
            PdfArray ar = (PdfArray)xfa;
            for (int k = 1; k < ar.size(); k += 2) {
                PdfObject ob = ar.getDirectObject(k);
                if (!(ob instanceof PRStream)) continue;
                byte[] b = PdfReader.getStreamBytes((PRStream)ob);
                bout.write(b);
            }
        } else if (xfa instanceof PRStream) {
            byte[] b = PdfReader.getStreamBytes((PRStream)xfa);
            bout.write(b);
        }
        bout.close();
        DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
        fact.setNamespaceAware(true);
        DocumentBuilder db = fact.newDocumentBuilder();
        this.domDocument = db.parse(new ByteArrayInputStream(bout.toByteArray()));
        this.extractNodes();
    }

    private void extractNodes() {
        Map<String, Node> xfaNodes = XfaForm.extractXFANodes(this.domDocument);
        if (xfaNodes.containsKey("template")) {
            this.templateNode = xfaNodes.get("template");
            this.templateSom = new Xml2SomTemplate(this.templateNode);
        }
        if (xfaNodes.containsKey("datasets")) {
            this.datasetsNode = xfaNodes.get("datasets");
            this.datasetsSom = new Xml2SomDatasets(this.datasetsNode.getFirstChild());
        }
        if (this.datasetsNode == null) {
            this.createDatasetsNode(this.domDocument.getFirstChild());
        }
    }

    public static Map<String, Node> extractXFANodes(Document domDocument) {
        HashMap<String, Node> xfaNodes = new HashMap<String, Node>();
        Node n = domDocument.getFirstChild();
        while (n.getChildNodes().getLength() == 0) {
            n = n.getNextSibling();
        }
        for (n = n.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            String s = n.getLocalName();
            xfaNodes.put(s, n);
        }
        return xfaNodes;
    }

    private void createDatasetsNode(Node n) {
        while (null != n && n.getChildNodes().getLength() == 0) {
            n = n.getNextSibling();
        }
        if (n != null) {
            Element e = n.getOwnerDocument().createElement("xfa:datasets");
            e.setAttribute("xmlns:xfa", XFA_DATA_SCHEMA);
            this.datasetsNode = e;
            n.appendChild(this.datasetsNode);
        }
    }

    public static void setXfa(XfaForm form, PdfReader reader, PdfWriter writer) throws IOException {
        PdfDictionary af = (PdfDictionary)PdfReader.getPdfObjectRelease(reader.getCatalog().get(PdfName.ACROFORM));
        if (af == null) {
            return;
        }
        PdfObject xfa = XfaForm.getXfaObject(reader);
        if (xfa.isArray()) {
            PdfArray ar = (PdfArray)xfa;
            int t = -1;
            int d = -1;
            for (int k = 0; k < ar.size(); k += 2) {
                PdfString s = ar.getAsString(k);
                if ("template".equals(s.toString())) {
                    t = k + 1;
                }
                if (!"datasets".equals(s.toString())) continue;
                d = k + 1;
            }
            if (t > -1 && d > -1) {
                reader.killXref(ar.getAsIndirectObject(t));
                reader.killXref(ar.getAsIndirectObject(d));
                PdfStream tStream = new PdfStream(XfaForm.serializeDoc(form.templateNode));
                tStream.flateCompress(writer.getCompressionLevel());
                ar.set(t, writer.addToBody(tStream).getIndirectReference());
                PdfStream dStream = new PdfStream(XfaForm.serializeDoc(form.datasetsNode));
                dStream.flateCompress(writer.getCompressionLevel());
                ar.set(d, writer.addToBody(dStream).getIndirectReference());
                af.put(PdfName.XFA, new PdfArray(ar));
                return;
            }
        }
        reader.killXref(af.get(PdfName.XFA));
        PdfStream str = new PdfStream(XfaForm.serializeDoc(form.domDocument));
        str.flateCompress(writer.getCompressionLevel());
        PdfIndirectReference ref = writer.addToBody(str).getIndirectReference();
        af.put(PdfName.XFA, ref);
    }

    public void setXfa(PdfWriter writer) throws IOException {
        XfaForm.setXfa(this, this.reader, writer);
    }

    public static byte[] serializeDoc(Node n) throws IOException {
        XmlDomWriter xw = new XmlDomWriter();
        ByteBuffer fout = new ByteBuffer();
        xw.setOutput(fout, null);
        xw.setCanonical(false);
        xw.write(n);
        fout.close();
        return fout.toByteArray();
    }

    public boolean isXfaPresent() {
        return this.xfaPresent;
    }

    public Document getDomDocument() {
        return this.domDocument;
    }

    public String findFieldName(String name, AcroFields af) {
        Map<String, AcroFields.Item> items = af.getFields();
        if (items.containsKey(name)) {
            return name;
        }
        if (this.acroFieldsSom == null) {
            this.acroFieldsSom = items.isEmpty() && this.xfaPresent ? new AcroFieldsSearch(this.datasetsSom.getName2Node().keySet()) : new AcroFieldsSearch(items.keySet());
        }
        if (this.acroFieldsSom.getAcroShort2LongName().containsKey(name)) {
            return this.acroFieldsSom.getAcroShort2LongName().get(name);
        }
        return this.acroFieldsSom.inverseSearchGlobal(Xml2Som.splitParts(name));
    }

    public String findDatasetsName(String name) {
        if (this.datasetsSom.getName2Node().containsKey(name)) {
            return name;
        }
        return this.datasetsSom.inverseSearchGlobal(Xml2Som.splitParts(name));
    }

    public Node findDatasetsNode(String name) {
        if (name == null) {
            return null;
        }
        if ((name = this.findDatasetsName(name)) == null) {
            return null;
        }
        return this.datasetsSom.getName2Node().get(name);
    }

    public static String getNodeText(Node n) {
        if (n == null) {
            return "";
        }
        return XfaForm.getNodeText(n, "");
    }

    private static String getNodeText(Node n, String name) {
        for (Node n2 = n.getFirstChild(); n2 != null; n2 = n2.getNextSibling()) {
            if (n2.getNodeType() == 1) {
                name = XfaForm.getNodeText(n2, name);
                continue;
            }
            if (n2.getNodeType() != 3) continue;
            name = name + n2.getNodeValue();
        }
        return name;
    }

    public void setNodeText(Node n, String text) {
        if (n == null) {
            return;
        }
        Node nc = null;
        while ((nc = n.getFirstChild()) != null) {
            n.removeChild(nc);
        }
        if (n.getAttributes().getNamedItemNS(XFA_DATA_SCHEMA, "dataNode") != null) {
            n.getAttributes().removeNamedItemNS(XFA_DATA_SCHEMA, "dataNode");
        }
        n.appendChild(this.domDocument.createTextNode(text));
        this.changed = true;
    }

    public void setXfaPresent(boolean xfaPresent) {
        this.xfaPresent = xfaPresent;
    }

    public void setDomDocument(Document domDocument) {
        this.domDocument = domDocument;
        this.extractNodes();
    }

    public PdfReader getReader() {
        return this.reader;
    }

    public void setReader(PdfReader reader) {
        this.reader = reader;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public Xml2SomTemplate getTemplateSom() {
        return this.templateSom;
    }

    public void setTemplateSom(Xml2SomTemplate templateSom) {
        this.templateSom = templateSom;
    }

    public Xml2SomDatasets getDatasetsSom() {
        return this.datasetsSom;
    }

    public void setDatasetsSom(Xml2SomDatasets datasetsSom) {
        this.datasetsSom = datasetsSom;
    }

    public AcroFieldsSearch getAcroFieldsSom() {
        return this.acroFieldsSom;
    }

    public void setAcroFieldsSom(AcroFieldsSearch acroFieldsSom) {
        this.acroFieldsSom = acroFieldsSom;
    }

    public Node getDatasetsNode() {
        return this.datasetsNode;
    }

    public void fillXfaForm(File file) throws IOException {
        this.fillXfaForm(file, false);
    }

    public void fillXfaForm(File file, boolean readOnly) throws IOException {
        this.fillXfaForm(new FileInputStream(file), readOnly);
    }

    public void fillXfaForm(InputStream is) throws IOException {
        this.fillXfaForm(is, false);
    }

    public void fillXfaForm(InputStream is, boolean readOnly) throws IOException {
        this.fillXfaForm(new InputSource(is), readOnly);
    }

    public void fillXfaForm(InputSource is) throws IOException {
        this.fillXfaForm(is, false);
    }

    public void fillXfaForm(InputSource is, boolean readOnly) throws IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document newdoc = db.parse(is);
            this.fillXfaForm(newdoc.getDocumentElement(), readOnly);
        }
        catch (ParserConfigurationException e) {
            throw new ExceptionConverter(e);
        }
        catch (SAXException e) {
            throw new ExceptionConverter(e);
        }
    }

    public void fillXfaForm(Node node) {
        this.fillXfaForm(node, false);
    }

    public void fillXfaForm(Node node, boolean readOnly) {
        NodeList list;
        if (readOnly) {
            NodeList nodeList = this.domDocument.getElementsByTagName("field");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                ((Element)nodeList.item(i)).setAttribute("access", "readOnly");
            }
        }
        NodeList allChilds = this.datasetsNode.getChildNodes();
        int len = allChilds.getLength();
        Node data = null;
        for (int k = 0; k < len; ++k) {
            Node n = allChilds.item(k);
            if (n.getNodeType() != 1 || !n.getLocalName().equals("data") || !XFA_DATA_SCHEMA.equals(n.getNamespaceURI())) continue;
            data = n;
            break;
        }
        if (data == null) {
            data = this.datasetsNode.getOwnerDocument().createElementNS(XFA_DATA_SCHEMA, "xfa:data");
            this.datasetsNode.appendChild(data);
        }
        if ((list = data.getChildNodes()).getLength() == 0) {
            data.appendChild(this.domDocument.importNode(node, true));
        } else {
            Node firstNode = this.getFirstElementNode(data);
            if (firstNode != null) {
                data.replaceChild(this.domDocument.importNode(node, true), firstNode);
            }
        }
        this.extractNodes();
        this.setChanged(true);
    }

    private Node getFirstElementNode(Node src) {
        Node result = null;
        NodeList list = src.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (list.item(i).getNodeType() != 1) continue;
            result = list.item(i);
            break;
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Xml2SomTemplate
    extends Xml2Som {
        private boolean dynamicForm;
        private int templateLevel;

        public Xml2SomTemplate(Node n) {
            this.order = new ArrayList();
            this.name2Node = new HashMap();
            this.stack = new Stack2();
            this.anform = 0;
            this.templateLevel = 0;
            this.inverseSearch = new HashMap();
            this.processTemplate(n, null);
        }

        public String getFieldType(String s) {
            Node ui;
            Node n = (Node)this.name2Node.get(s);
            if (n == null) {
                return null;
            }
            if ("exclGroup".equals(n.getLocalName())) {
                return "exclGroup";
            }
            for (ui = n.getFirstChild(); !(ui == null || ui.getNodeType() == 1 && "ui".equals(ui.getLocalName())); ui = ui.getNextSibling()) {
            }
            if (ui == null) {
                return null;
            }
            for (Node type = ui.getFirstChild(); type != null; type = type.getNextSibling()) {
                if (type.getNodeType() != 1 || "extras".equals(type.getLocalName()) && "picture".equals(type.getLocalName())) continue;
                return type.getLocalName();
            }
            return null;
        }

        private void processTemplate(Node n, HashMap<String, Integer> ff) {
            if (ff == null) {
                ff = new HashMap();
            }
            HashMap<String, Integer> ss = new HashMap<String, Integer>();
            for (Node n2 = n.getFirstChild(); n2 != null; n2 = n2.getNextSibling()) {
                if (n2.getNodeType() != 1) continue;
                String s = n2.getLocalName();
                if ("subform".equals(s)) {
                    Integer i;
                    Node name = n2.getAttributes().getNamedItem("name");
                    String nn = "#subform";
                    boolean annon = true;
                    if (name != null) {
                        nn = Xml2SomTemplate.escapeSom(name.getNodeValue());
                        annon = false;
                    }
                    if (annon) {
                        i = this.anform;
                        ++this.anform;
                    } else {
                        i = (Integer)ss.get(nn);
                        i = i == null ? Integer.valueOf(0) : Integer.valueOf(i + 1);
                        ss.put(nn, i);
                    }
                    this.stack.push(nn + "[" + i.toString() + "]");
                    ++this.templateLevel;
                    if (annon) {
                        this.processTemplate(n2, ff);
                    } else {
                        this.processTemplate(n2, null);
                    }
                    --this.templateLevel;
                    this.stack.pop();
                    continue;
                }
                if ("field".equals(s) || "exclGroup".equals(s)) {
                    Node name = n2.getAttributes().getNamedItem("name");
                    if (name == null) continue;
                    String nn = Xml2SomTemplate.escapeSom(name.getNodeValue());
                    Integer i = ff.get(nn);
                    i = i == null ? Integer.valueOf(0) : Integer.valueOf(i + 1);
                    ff.put(nn, i);
                    this.stack.push(nn + "[" + i.toString() + "]");
                    String unstack = this.printStack();
                    this.order.add(unstack);
                    this.inverseSearchAdd(unstack);
                    this.name2Node.put(unstack, n2);
                    this.stack.pop();
                    continue;
                }
                if (this.dynamicForm || this.templateLevel <= 0 || !"occur".equals(s)) continue;
                int initial = 1;
                int min = 1;
                int max = 1;
                Node a = n2.getAttributes().getNamedItem("initial");
                if (a != null) {
                    try {
                        initial = Integer.parseInt(a.getNodeValue().trim());
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if ((a = n2.getAttributes().getNamedItem("min")) != null) {
                    try {
                        min = Integer.parseInt(a.getNodeValue().trim());
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if ((a = n2.getAttributes().getNamedItem("max")) != null) {
                    try {
                        max = Integer.parseInt(a.getNodeValue().trim());
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (initial == min && min == max) continue;
                this.dynamicForm = true;
            }
        }

        public boolean isDynamicForm() {
            return this.dynamicForm;
        }

        public void setDynamicForm(boolean dynamicForm) {
            this.dynamicForm = dynamicForm;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AcroFieldsSearch
    extends Xml2Som {
        private HashMap<String, String> acroShort2LongName;

        public AcroFieldsSearch(Collection<String> items) {
            this.inverseSearch = new HashMap();
            this.acroShort2LongName = new HashMap();
            Iterator<String> i$ = items.iterator();
            while (i$.hasNext()) {
                String string;
                String itemName = string = i$.next();
                String itemShort = AcroFieldsSearch.getShortName(itemName);
                this.acroShort2LongName.put(itemShort, itemName);
                AcroFieldsSearch.inverseSearchAdd(this.inverseSearch, AcroFieldsSearch.splitParts(itemShort), itemName);
            }
        }

        public HashMap<String, String> getAcroShort2LongName() {
            return this.acroShort2LongName;
        }

        public void setAcroShort2LongName(HashMap<String, String> acroShort2LongName) {
            this.acroShort2LongName = acroShort2LongName;
        }
    }

    public static class Xml2SomDatasets
    extends Xml2Som {
        public Xml2SomDatasets(Node n) {
            this.order = new ArrayList();
            this.name2Node = new HashMap();
            this.stack = new Stack2();
            this.anform = 0;
            this.inverseSearch = new HashMap();
            this.processDatasetsInternal(n);
        }

        public Node insertNode(Node n, String shortName) {
            Stack2<String> stack = Xml2SomDatasets.splitParts(shortName);
            Document doc = n.getOwnerDocument();
            Node n2 = null;
            n = n.getFirstChild();
            while (n.getNodeType() != 1) {
                n = n.getNextSibling();
            }
            for (int k = 0; k < stack.size(); ++k) {
                String s;
                String part = (String)stack.get(k);
                int idx = part.lastIndexOf(91);
                String name = part.substring(0, idx);
                idx = Integer.parseInt(part.substring(idx + 1, part.length() - 1));
                int found = -1;
                for (n2 = n.getFirstChild(); !(n2 == null || n2.getNodeType() == 1 && (s = Xml2SomDatasets.escapeSom(n2.getLocalName())).equals(name) && ++found == idx); n2 = n2.getNextSibling()) {
                }
                while (found < idx) {
                    n2 = doc.createElementNS(null, name);
                    n2 = n.appendChild(n2);
                    Attr attr = doc.createAttributeNS(XfaForm.XFA_DATA_SCHEMA, "dataNode");
                    attr.setNodeValue("dataGroup");
                    n2.getAttributes().setNamedItemNS(attr);
                    ++found;
                }
                n = n2;
            }
            Xml2SomDatasets.inverseSearchAdd(this.inverseSearch, stack, shortName);
            this.name2Node.put(shortName, n2);
            this.order.add(shortName);
            return n2;
        }

        private static boolean hasChildren(Node n) {
            Node dataNodeN = n.getAttributes().getNamedItemNS(XfaForm.XFA_DATA_SCHEMA, "dataNode");
            if (dataNodeN != null) {
                String dataNode = dataNodeN.getNodeValue();
                if ("dataGroup".equals(dataNode)) {
                    return true;
                }
                if ("dataValue".equals(dataNode)) {
                    return false;
                }
            }
            if (!n.hasChildNodes()) {
                return false;
            }
            for (Node n2 = n.getFirstChild(); n2 != null; n2 = n2.getNextSibling()) {
                if (n2.getNodeType() != 1) continue;
                return true;
            }
            return false;
        }

        private void processDatasetsInternal(Node n) {
            if (n != null) {
                HashMap<String, Integer> ss = new HashMap<String, Integer>();
                for (Node n2 = n.getFirstChild(); n2 != null; n2 = n2.getNextSibling()) {
                    if (n2.getNodeType() != 1) continue;
                    String s = Xml2SomDatasets.escapeSom(n2.getLocalName());
                    Integer i = (Integer)ss.get(s);
                    i = i == null ? Integer.valueOf(0) : Integer.valueOf(i + 1);
                    ss.put(s, i);
                    if (Xml2SomDatasets.hasChildren(n2)) {
                        this.stack.push(s + "[" + i.toString() + "]");
                        this.processDatasetsInternal(n2);
                        this.stack.pop();
                        continue;
                    }
                    this.stack.push(s + "[" + i.toString() + "]");
                    String unstack = this.printStack();
                    this.order.add(unstack);
                    this.inverseSearchAdd(unstack);
                    this.name2Node.put(unstack, n2);
                    this.stack.pop();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Xml2Som {
        protected ArrayList<String> order;
        protected HashMap<String, Node> name2Node;
        protected HashMap<String, InverseStore> inverseSearch;
        protected Stack2<String> stack;
        protected int anform;

        public static String escapeSom(String s) {
            if (s == null) {
                return "";
            }
            int idx = s.indexOf(46);
            if (idx < 0) {
                return s;
            }
            StringBuffer sb = new StringBuffer();
            int last = 0;
            while (idx >= 0) {
                sb.append(s.substring(last, idx));
                sb.append('\\');
                last = idx;
                idx = s.indexOf(46, idx + 1);
            }
            sb.append(s.substring(last));
            return sb.toString();
        }

        public static String unescapeSom(String s) {
            int idx = s.indexOf(92);
            if (idx < 0) {
                return s;
            }
            StringBuffer sb = new StringBuffer();
            int last = 0;
            while (idx >= 0) {
                sb.append(s.substring(last, idx));
                last = idx + 1;
                idx = s.indexOf(92, idx + 1);
            }
            sb.append(s.substring(last));
            return sb.toString();
        }

        protected String printStack() {
            if (this.stack.empty()) {
                return "";
            }
            StringBuffer s = new StringBuffer();
            for (int k = 0; k < this.stack.size(); ++k) {
                s.append('.').append((String)this.stack.get(k));
            }
            return s.substring(1);
        }

        public static String getShortName(String s) {
            int idx = s.indexOf(".#subform[");
            if (idx < 0) {
                return s;
            }
            int last = 0;
            StringBuffer sb = new StringBuffer();
            while (idx >= 0) {
                sb.append(s.substring(last, idx));
                idx = s.indexOf("]", idx + 10);
                if (idx < 0) {
                    return sb.toString();
                }
                last = idx + 1;
                idx = s.indexOf(".#subform[", last);
            }
            sb.append(s.substring(last));
            return sb.toString();
        }

        public void inverseSearchAdd(String unstack) {
            Xml2Som.inverseSearchAdd(this.inverseSearch, this.stack, unstack);
        }

        public static void inverseSearchAdd(HashMap<String, InverseStore> inverseSearch, Stack2<String> stack, String unstack) {
            String last = stack.peek();
            InverseStore store = inverseSearch.get(last);
            if (store == null) {
                store = new InverseStore();
                inverseSearch.put(last, store);
            }
            for (int k = stack.size() - 2; k >= 0; --k) {
                InverseStore store2;
                last = (String)stack.get(k);
                int idx = store.part.indexOf(last);
                if (idx < 0) {
                    store.part.add(last);
                    store2 = new InverseStore();
                    store.follow.add(store2);
                } else {
                    store2 = (InverseStore)store.follow.get(idx);
                }
                store = store2;
            }
            store.part.add("");
            store.follow.add(unstack);
        }

        public String inverseSearchGlobal(ArrayList<String> parts) {
            if (parts.isEmpty()) {
                return null;
            }
            InverseStore store = this.inverseSearch.get(parts.get(parts.size() - 1));
            if (store == null) {
                return null;
            }
            for (int k = parts.size() - 2; k >= 0; --k) {
                String part = parts.get(k);
                int idx = store.part.indexOf(part);
                if (idx < 0) {
                    if (store.isSimilar(part)) {
                        return null;
                    }
                    return store.getDefaultName();
                }
                store = (InverseStore)store.follow.get(idx);
            }
            return store.getDefaultName();
        }

        public static Stack2<String> splitParts(String name) {
            String part;
            while (name.startsWith(".")) {
                name = name.substring(1);
            }
            Stack2<String> parts = new Stack2<String>();
            int last = 0;
            int pos = 0;
            while (true) {
                pos = last;
                while ((pos = name.indexOf(46, pos)) >= 0 && name.charAt(pos - 1) == '\\') {
                    ++pos;
                }
                if (pos < 0) break;
                part = name.substring(last, pos);
                if (!part.endsWith("]")) {
                    part = part + "[0]";
                }
                parts.add(part);
                last = pos + 1;
            }
            part = name.substring(last);
            if (!part.endsWith("]")) {
                part = part + "[0]";
            }
            parts.add(part);
            return parts;
        }

        public ArrayList<String> getOrder() {
            return this.order;
        }

        public void setOrder(ArrayList<String> order) {
            this.order = order;
        }

        public HashMap<String, Node> getName2Node() {
            return this.name2Node;
        }

        public void setName2Node(HashMap<String, Node> name2Node) {
            this.name2Node = name2Node;
        }

        public HashMap<String, InverseStore> getInverseSearch() {
            return this.inverseSearch;
        }

        public void setInverseSearch(HashMap<String, InverseStore> inverseSearch) {
            this.inverseSearch = inverseSearch;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Stack2<T>
    extends ArrayList<T> {
        private static final long serialVersionUID = -7451476576174095212L;

        public T peek() {
            if (this.size() == 0) {
                throw new EmptyStackException();
            }
            return (T)this.get(this.size() - 1);
        }

        public T pop() {
            if (this.size() == 0) {
                throw new EmptyStackException();
            }
            Object ret = this.get(this.size() - 1);
            this.remove(this.size() - 1);
            return (T)ret;
        }

        public T push(T item) {
            this.add(item);
            return item;
        }

        public boolean empty() {
            return this.size() == 0;
        }
    }

    public static class InverseStore {
        protected ArrayList<String> part = new ArrayList();
        protected ArrayList<Object> follow = new ArrayList();

        public String getDefaultName() {
            InverseStore store = this;
            Object obj;
            while (!((obj = store.follow.get(0)) instanceof String)) {
                store = (InverseStore)obj;
            }
            return (String)obj;
        }

        public boolean isSimilar(String name) {
            int idx = name.indexOf(91);
            name = name.substring(0, idx + 1);
            for (int k = 0; k < this.part.size(); ++k) {
                if (!this.part.get(k).startsWith(name)) continue;
                return true;
            }
            return false;
        }
    }
}

