/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.validator;

import cfca.sadk.tls.java.security.CFCAAlgorithmConstraints;
import cfca.sadk.tls.sun.security.util.CFCASSLHelper;
import cfca.sadk.tls.sun.security.validator.TLSKeyUsageChecker;
import cfca.sadk.tls.sun.security.validator.TLSPKIXValidator;
import cfca.sadk.tls.sun.security.validator.TLSValidatorVariant;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Set;

public abstract class TLSValidator {
    static final String OID_BASIC_CONSTRAINTS = "2.5.29.19";
    static final String OID_NETSCAPE_CERT_TYPE = "2.16.840.1.113730.1.1";
    static final String OID_KEY_USAGE = "2.5.29.15";
    static final String OID_EXTENDED_KEY_USAGE = "2.5.29.37";
    static final String OID_EKU_ANY_USAGE = "2.5.29.37.0";
    static final X509Certificate[] CHAIN0 = new X509Certificate[0];
    final TLSKeyUsageChecker endEntityChecker;
    final TLSValidatorVariant variant;

    TLSValidator(TLSValidatorVariant variant) {
        this.variant = variant;
        this.endEntityChecker = TLSKeyUsageChecker.getInstance(variant);
    }

    public static TLSValidator getInstance(TLSValidatorVariant variant, KeyStore keystore) {
        Set<X509Certificate> trustedCerts = CFCASSLHelper.getTrustedCerts(keystore);
        return TLSValidator.getInstance(variant, trustedCerts);
    }

    public static TLSValidator getInstance(TLSValidatorVariant variant, Collection<X509Certificate> trustedCerts) {
        return new TLSPKIXValidator(variant, trustedCerts);
    }

    public static TLSValidator getInstance(TLSValidatorVariant variant, PKIXBuilderParameters params) {
        return new TLSPKIXValidator(variant, params);
    }

    public final X509Certificate[] validate(X509Certificate[] chain) throws CertificateException {
        return this.validate(chain, null, null);
    }

    public final X509Certificate[] validate(X509Certificate[] chain, Collection<X509Certificate> otherCerts) throws CertificateException {
        return this.validate(chain, otherCerts, null);
    }

    public final X509Certificate[] validate(X509Certificate[] chain, Collection<X509Certificate> otherCerts, Object parameter) throws CertificateException {
        return this.validate(chain, otherCerts, null, parameter);
    }

    public final X509Certificate[] validate(X509Certificate[] chain, Collection<X509Certificate> otherCerts, CFCAAlgorithmConstraints constraints, Object parameter) throws CertificateException {
        if ((chain = this.engineValidate(chain, otherCerts, constraints, parameter)) != null && chain.length > 1) {
            this.endEntityChecker.check(chain[0], parameter);
        }
        return chain;
    }

    abstract X509Certificate[] engineValidate(X509Certificate[] var1, Collection<X509Certificate> var2, CFCAAlgorithmConstraints var3, Object var4) throws CertificateException;

    public abstract Collection<X509Certificate> getTrustedCertificates();
}

