/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.prf;

import cfca.sadk.tls.i18n.JSSEMessage;
import cfca.sadk.tls.sun.security.ssl.prf.HashPRF;
import cfca.sadk.tls.sun.security.ssl.prf.TlsKeyMaterialGenerator;
import cfca.sadk.tls.sun.security.ssl.prf.TlsKeyMaterials;
import cfca.sadk.tls.sun.security.ssl.prf.TlsKeyMaterialsTools;
import cfca.sadk.tls.sun.security.ssl.prf.TlsProtocolVersion;
import java.security.GeneralSecurityException;
import javax.crypto.SecretKey;

public final class TlsKeyMaterialParameters {
    private final SecretKey masterSecret;
    private final TlsProtocolVersion versions;
    private final byte[] clientRandom;
    private final byte[] serverRandom;
    private final String cipherAlgorithm;
    private final int cipherKeyLength;
    private final int ivLength;
    private final int macKeyLength;
    private final int expandedCipherKeyLength;
    private final HashPRF hashPRF;

    public TlsKeyMaterialParameters(SecretKey masterSecret, int majorVersion, int minorVersion, byte[] clientRandom, byte[] serverRandom, String cipherAlgorithm, int cipherKeyLength, int expandedCipherKeyLength, int ivLength, int macKeyLength, HashPRF hashPRF) {
        TlsKeyMaterialsTools.checkParameters(hashPRF, clientRandom, serverRandom);
        TlsKeyMaterialParameters.checkParameters(masterSecret, cipherAlgorithm);
        this.masterSecret = masterSecret;
        this.versions = new TlsProtocolVersion(majorVersion, minorVersion);
        this.clientRandom = (byte[])clientRandom.clone();
        this.serverRandom = (byte[])serverRandom.clone();
        this.cipherAlgorithm = cipherAlgorithm;
        this.cipherKeyLength = TlsKeyMaterialParameters.checkSign("cipherKeyLength", cipherKeyLength);
        this.expandedCipherKeyLength = TlsKeyMaterialParameters.checkSign("expandedCipherKeyLength", expandedCipherKeyLength);
        this.ivLength = TlsKeyMaterialParameters.checkSign("ivLength", ivLength);
        this.macKeyLength = TlsKeyMaterialParameters.checkSign("macKeyLength", macKeyLength);
        this.hashPRF = hashPRF;
    }

    private static void checkParameters(SecretKey masterSecret, String cipherAlgorithm) {
        if (cipherAlgorithm == null) {
            throw new IllegalArgumentException(JSSEMessage.getMessage("cfca.sadk.tls.parameters.notInitialized", "cipherAlgorithm"));
        }
        if (masterSecret == null) {
            throw new IllegalArgumentException(JSSEMessage.getMessage("cfca.sadk.tls.parameters.notInitialized", "masterSecret"));
        }
        if (!"TlsMasterSecret".equals(masterSecret.getAlgorithm())) {
            throw new IllegalArgumentException(JSSEMessage.getMessage("cfca.sadk.tls.parameters.mustBeMasterSecret", "masterSecret"));
        }
    }

    private static int checkSign(String name, int value) {
        if (value < 0) {
            throw new IllegalArgumentException(JSSEMessage.getMessage("cfca.sadk.tls.parameters.mustNotNegative", name));
        }
        return value;
    }

    public SecretKey getMasterSecret() {
        return this.masterSecret;
    }

    public int getMajorVersion() {
        return this.versions.majorVersion;
    }

    public int getMinorVersion() {
        return this.versions.minorVersion;
    }

    public byte[] getClientRandom() {
        return (byte[])this.clientRandom.clone();
    }

    public byte[] getServerRandom() {
        return (byte[])this.serverRandom.clone();
    }

    public String getCipherAlgorithm() {
        return this.cipherAlgorithm;
    }

    public int getCipherKeyLength() {
        return this.cipherKeyLength;
    }

    public int getExpandedCipherKeyLength() {
        if (this.versions.isGreaterThanTLSv11()) {
            return 0;
        }
        return this.expandedCipherKeyLength;
    }

    public int getIvLength() {
        return this.ivLength;
    }

    public int getMacKeyLength() {
        return this.macKeyLength;
    }

    public String getPRFHashAlg() {
        return this.hashPRF.prfHashAlg;
    }

    public int getPRFHashLength() {
        return this.hashPRF.prfHashLength;
    }

    public int getPRFBlockSize() {
        return this.hashPRF.prfBlockSize;
    }

    public HashPRF hashPRF() {
        return this.hashPRF;
    }

    public final TlsKeyMaterials generateWorkKeys() throws GeneralSecurityException {
        return new TlsKeyMaterialGenerator().generateWorkKeys(this);
    }
}

