/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.asn1.anssi;

import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.anssi.ANSSIObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.ecc.NamedCurves;
import cfca.sadk.org.bouncycastle.asn1.x9.X9ECParameters;
import cfca.sadk.org.bouncycastle.asn1.x9.X9ECParametersHolder;
import cfca.sadk.org.bouncycastle.math.ec.ECCurve;
import cfca.sadk.org.bouncycastle.math.ec.ECPoint;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;

public class ANSSINamedCurves {
    private static final HashMap objIds = new HashMap();
    private static final HashMap names = new HashMap();
    private static final HashMap curves = new HashMap();
    static X9ECParametersHolder frp256v1 = new X9ECParametersHolder(){

        protected X9ECParameters createParameters() {
            BigInteger p = new BigInteger("F1FD178C0B3AD58F10126DE8CE42435B3961ADBCABC8CA6DE8FCF353D86E9C03", 16);
            BigInteger a = new BigInteger("F1FD178C0B3AD58F10126DE8CE42435B3961ADBCABC8CA6DE8FCF353D86E9C00", 16);
            BigInteger b = new BigInteger("EE353FCA5428A9300D4ABA754A44C00FDFEC0C9AE4B1A1803075ED967B7BB73F", 16);
            BigInteger n = new BigInteger("F1FD178C0B3AD58F10126DE8CE42435B53DC67E140D2BF941FFDD459C6D655E1", 16);
            BigInteger gx = new BigInteger("B6B3D4C356C139EB31183D4749D423958C27D2DCAF98B70164C97A2DD98F5CFF", 16);
            BigInteger gy = new BigInteger("6142E0F7C8B204911F9271F0F3ECEF8C2701C307E8E4C9E183115A1554062CFB", 16);
            BigInteger h = new BigInteger("1", 16);
            ECCurve curve = ANSSINamedCurves.configureCurve(new ECCurve.Fp(p, a, b, n, h));
            ECPoint G = curve.createPoint(gx, gy);
            return new X9ECParameters(curve, G, n, h);
        }
    };

    private static ECCurve configureCurve(ECCurve curve) {
        return curve;
    }

    static void defineCurve(String name, ASN1ObjectIdentifier oid, X9ECParametersHolder holder) {
        objIds.put(name, oid);
        names.put(oid, name);
        curves.put(oid, holder);
    }

    public static X9ECParameters getByName(String name) {
        return NamedCurves.getByName(curves, objIds, name);
    }

    public static X9ECParameters getByOID(ASN1ObjectIdentifier oid) {
        return NamedCurves.getByOID(curves, oid);
    }

    public static ASN1ObjectIdentifier getOID(String name) {
        return NamedCurves.getOID(objIds, name);
    }

    public static String getName(ASN1ObjectIdentifier oid) {
        return NamedCurves.getName(names, oid);
    }

    public static Enumeration getNames() {
        return NamedCurves.getNames(objIds);
    }

    public static List getNameList() {
        return NamedCurves.getNameList(objIds);
    }

    static {
        ANSSINamedCurves.defineCurve("frp256v1", ANSSIObjectIdentifiers.frp256v1, frp256v1);
    }
}

