/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.sec;

import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.sec.SECNamedCurves;
import cfca.sadk.org.bouncycastle.asn1.x9.X9ECParameters;
import cfca.sadk.org.bouncycastle.crypto.ec.CustomNamedCurves;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import cfca.sadk.org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import cfca.sadk.org.bouncycastle.jce.spec.ECParameterSpec;
import cfca.sadk.org.bouncycastle.math.ec.ECCurve;
import cfca.sadk.org.bouncycastle.math.ec.ECPoint;
import cfca.sadk.tls.sun.security.util.CFCAKeyHelper;
import java.io.IOException;
import java.util.Enumeration;

public final class ECNamedCurve {
    public static final int sect163k1 = 1;
    public static final int sect163r1 = 2;
    public static final int sect163r2 = 3;
    public static final int sect193r1 = 4;
    public static final int sect193r2 = 5;
    public static final int sect233k1 = 6;
    public static final int sect233r1 = 7;
    public static final int sect239k1 = 8;
    public static final int sect283k1 = 9;
    public static final int sect283r1 = 10;
    public static final int sect409k1 = 11;
    public static final int sect409r1 = 12;
    public static final int sect571k1 = 13;
    public static final int sect571r1 = 14;
    public static final int secp160k1 = 15;
    public static final int secp160r1 = 16;
    public static final int secp160r2 = 17;
    public static final int secp192k1 = 18;
    public static final int secp192r1 = 19;
    public static final int secp224k1 = 20;
    public static final int secp224r1 = 21;
    public static final int secp256k1 = 22;
    public static final int secp256r1 = 23;
    public static final int secp384r1 = 24;
    public static final int secp521r1 = 25;
    public static final int brainpoolP256r1 = 26;
    public static final int brainpoolP384r1 = 27;
    public static final int brainpoolP512r1 = 28;
    public static final int sm2 = 64;
    public static final int arbitrary_explicit_prime_curves = 65281;
    public static final int arbitrary_explicit_char2_curves = 65282;

    private ECNamedCurve() {
    }

    public static final boolean isValid(int namedCurve) {
        return namedCurve >= 1 && namedCurve <= 28 || namedCurve == 64 || namedCurve == 65281 || namedCurve == 65282;
    }

    public static final boolean refersToASpecificNamedCurve(int namedCurve) {
        switch (namedCurve) {
            case 65281: 
            case 65282: {
                return false;
            }
        }
        return true;
    }

    public static final X9ECParameters getByName(String name) {
        return SECNamedCurves.getByName((String)name);
    }

    public static final X9ECParameters getByOID(ASN1ObjectIdentifier oid) {
        return SECNamedCurves.getByOID((ASN1ObjectIdentifier)oid);
    }

    public static final ASN1ObjectIdentifier getOID(String name) {
        return SECNamedCurves.getOID((String)name);
    }

    public static final String getName(ASN1ObjectIdentifier oid) {
        return SECNamedCurves.getName((ASN1ObjectIdentifier)oid);
    }

    public static final String getNamedCurveOid(ECParameterSpec params) {
        String namedCurveOid = null;
        if (params == null) {
            namedCurveOid = null;
        } else {
            Enumeration curves = SECNamedCurves.getNames();
            int fieldSize = params.getCurve().getFieldSize();
            X9ECParameters parameters = null;
            String name = null;
            while (curves.hasMoreElements()) {
                name = (String)curves.nextElement();
                parameters = SECNamedCurves.getByName((String)name);
                boolean match = ECNamedCurve.checkECParams(parameters, params, fieldSize);
                if (!match) continue;
                ASN1ObjectIdentifier oid = SECNamedCurves.getOID((String)name);
                if (oid == null) break;
                namedCurveOid = oid.getId();
                break;
            }
        }
        return namedCurveOid;
    }

    private static final boolean checkECParams(X9ECParameters parameters, ECParameterSpec params, int fieldSize) {
        boolean checkResult = true;
        if (parameters == null || params == null) {
            checkResult = false;
        } else if (parameters.getCurve().getFieldSize() != fieldSize) {
            checkResult = false;
        } else if (!parameters.getCurve().equals(params.getCurve())) {
            checkResult = false;
        } else if (!parameters.getG().equals(params.getG())) {
            checkResult = false;
        } else if (!parameters.getN().equals(params.getN())) {
            checkResult = false;
        } else if (!parameters.getH().equals(params.getH())) {
            checkResult = false;
        }
        return checkResult;
    }

    public static final ECParameterSpec getECParameterSpec(String namedCurveOid) {
        ASN1ObjectIdentifier oid = new ASN1ObjectIdentifier(namedCurveOid);
        X9ECParameters ecP = ECUtil.getNamedCurveByOid((ASN1ObjectIdentifier)oid);
        ECNamedCurveParameterSpec ecSpec = new ECNamedCurveParameterSpec(ECUtil.getCurveName((ASN1ObjectIdentifier)oid), ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
        return ecSpec;
    }

    public static final ECPoint decodePoint(byte[] encoded, ECCurve curve) throws IOException {
        return curve.decodePoint(encoded);
    }

    public static final byte[] encodePoint(ECPoint point, ECCurve curve) {
        int n = curve.getFieldSize() + 7 >> 3;
        byte[] xb = CFCAKeyHelper.trimZeroes(point.getAffineXCoord().getEncoded());
        byte[] yb = CFCAKeyHelper.trimZeroes(point.getAffineYCoord().getEncoded());
        if (xb.length > n || yb.length > n) {
            throw new RuntimeException("Point coordinates do not match field size");
        }
        byte[] b = new byte[1 + (n << 1)];
        b[0] = 4;
        System.arraycopy(xb, 0, b, n - xb.length + 1, xb.length);
        System.arraycopy(yb, 0, b, b.length - yb.length, yb.length);
        return b;
    }

    public static boolean isSM2NamedCurve(ECParameterSpec params) {
        if (params == null) {
            return false;
        }
        X9ECParameters parameters = SECNamedCurves.getByName((String)"sm2");
        if (parameters == null) {
            return false;
        }
        if (params.getCurve() == null) {
            return false;
        }
        int fieldSize = params.getCurve().getFieldSize();
        if (parameters.getCurve().getFieldSize() != fieldSize) {
            return false;
        }
        if (!parameters.getCurve().equals(params.getCurve())) {
            return false;
        }
        if (!parameters.getG().equals(params.getG())) {
            return false;
        }
        if (!parameters.getN().equals(params.getN())) {
            return false;
        }
        return parameters.getH().equals(params.getH());
    }

    public static void test(String[] args) {
        String namedCurveOid = "1.2.840.10045.3.1.7";
        System.err.println(ECNamedCurve.getECParameterSpec("1.2.840.10045.3.1.7"));
        X9ECParameters xxx = null;
        ASN1ObjectIdentifier oid = new ASN1ObjectIdentifier("1.2.840.10045.3.1.7");
        xxx = CustomNamedCurves.getByOID((ASN1ObjectIdentifier)oid);
        System.err.println(xxx);
    }
}

