/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.itextpdf.text.pdf.security;

import cfca.com.itextpdf.text.DocumentException;
import cfca.com.itextpdf.text.io.RASInputStream;
import cfca.com.itextpdf.text.io.RandomAccessSource;
import cfca.com.itextpdf.text.io.RandomAccessSourceFactory;
import cfca.com.itextpdf.text.io.StreamUtil;
import cfca.com.itextpdf.text.pdf.AcroFields;
import cfca.com.itextpdf.text.pdf.ByteBuffer;
import cfca.com.itextpdf.text.pdf.PdfArray;
import cfca.com.itextpdf.text.pdf.PdfDate;
import cfca.com.itextpdf.text.pdf.PdfDeveloperExtension;
import cfca.com.itextpdf.text.pdf.PdfDictionary;
import cfca.com.itextpdf.text.pdf.PdfName;
import cfca.com.itextpdf.text.pdf.PdfReader;
import cfca.com.itextpdf.text.pdf.PdfSignature;
import cfca.com.itextpdf.text.pdf.PdfSignatureAppearance;
import cfca.com.itextpdf.text.pdf.PdfString;
import cfca.com.itextpdf.text.pdf.security.CrlClient;
import cfca.com.itextpdf.text.pdf.security.DigestAlgorithms;
import cfca.com.itextpdf.text.pdf.security.ExternalDigest;
import cfca.com.itextpdf.text.pdf.security.ExternalSignature;
import cfca.com.itextpdf.text.pdf.security.ExternalSignatureContainer;
import cfca.com.itextpdf.text.pdf.security.OcspClient;
import cfca.com.itextpdf.text.pdf.security.PdfPKCS7;
import cfca.com.itextpdf.text.pdf.security.TSAClient;
import cfca.com.itextpdf.text.pdf.security.pkcs7.DefaultPKCS7Package;
import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.sm2.SM2HashZValue;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.bcsoft.BCSoftLib;
import cfca.sadk.org.bouncycastle.tsp.TSPException;
import cfca.sadk.util.Base64;
import cfca.sadk.util.HashUtil;
import cfca.sadk.x509.certificate.X509Cert;
import cfca.seal.sadk.cert.PdfX509Certificate;
import cfca.seal.sadk.security.deferred.ReservedPdfPKCS7;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakeSignature {
    private static final Logger logger = LoggerFactory.getLogger(MakeSignature.class);
    private static DefaultPKCS7Package p7Util = new DefaultPKCS7Package();

    public static void signDetached(PdfSignatureAppearance sap, ExternalDigest externalDigest, ExternalSignature externalSignature, Certificate[] chain, Collection<CrlClient> crlList, OcspClient ocspClient, TSAClient tsaClient, int estimatedSize, CryptoStandard sigtype, Option option) throws IOException, DocumentException, GeneralSecurityException {
        PdfPKCS7 sgn;
        logger.info("begin signDetached...");
        Collection<byte[]> crlBytes = null;
        int i = 0;
        while (crlBytes == null && i < chain.length) {
            crlBytes = MakeSignature.processCrl(chain[i++], crlList);
        }
        if (estimatedSize == 0) {
            estimatedSize = 8192;
            if (crlBytes != null) {
                for (byte[] element : crlBytes) {
                    estimatedSize += element.length + 10;
                }
            }
            if (ocspClient != null) {
                estimatedSize += 4192;
            }
            if (tsaClient != null) {
                estimatedSize += 4192;
            }
        }
        sap.setCertificate(chain[0]);
        if (sigtype == CryptoStandard.CADES) {
            sap.addDeveloperExtension(PdfDeveloperExtension.ESIC_1_7_EXTENSIONLEVEL2);
        }
        PdfSignature dic = null;
        String encryptionAlgorithm = externalSignature.getEncryptionAlgorithm();
        if ("RSA".equals(encryptionAlgorithm)) {
            dic = option.docHashBase64Encoding ? new PdfSignature(PdfName.CFCA_TrustSignPDF, PdfName.RSA_BASE64_SHA1) : new PdfSignature(PdfName.ADOBE_PPKLITE, sigtype == CryptoStandard.CADES ? PdfName.ETSI_CADES_DETACHED : PdfName.ADBE_PKCS7_DETACHED);
        } else if ("SM2".equals(encryptionAlgorithm)) {
            dic = new PdfSignature(PdfName.CFCA_TrustSignPDF, PdfName.CFCA_SM2_PKCS7_DETACHED);
        }
        if (null == dic) {
            throw new GeneralSecurityException("unsuported pdf signature filter!");
        }
        dic.setReason(sap.getReason());
        dic.setLocation(sap.getLocation());
        dic.setSignatureCreator(sap.getSignatureCreator());
        dic.setContact(sap.getContact());
        dic.setDate(new PdfDate(sap.getSignDate()));
        sap.setCryptoDictionary(dic);
        HashMap<PdfName, Integer> exc = new HashMap<PdfName, Integer>();
        exc.put(PdfName.CONTENTS, new Integer(estimatedSize * 2 + 2));
        sap.preClose(exc);
        String hashAlgorithm = externalSignature.getHashAlgorithm();
        InputStream data = sap.getRangeStream();
        byte[] encodedSig = new byte[]{};
        if ("RSA".equals(encryptionAlgorithm) && !option.docHashBase64Encoding) {
            sgn = new PdfPKCS7(null, chain, hashAlgorithm, null, externalDigest, false);
            byte[] hash = DigestAlgorithms.digest(data, externalDigest.getMessageDigest(hashAlgorithm));
            Calendar cal = Calendar.getInstance();
            byte[] ocsp = null;
            if (chain.length >= 2 && ocspClient != null) {
                ocsp = ocspClient.getEncoded((X509Certificate)chain[0], (X509Certificate)chain[1], null);
            }
            byte[] sh = sgn.getAuthenticatedAttributeBytes(hash, cal, ocsp, crlBytes, sigtype);
            byte[] extSignature = externalSignature.sign(sh);
            sgn.setExternalDigest(extSignature, null, externalSignature.getEncryptionAlgorithm());
            encodedSig = sgn.getEncodedPKCS7(hash, cal, tsaClient, ocsp, crlBytes, sigtype);
        } else if ("RSA".equals(encryptionAlgorithm) && option.docHashBase64Encoding) {
            sgn = new PdfPKCS7(null, chain, hashAlgorithm, null, externalDigest, false);
            byte[] srcBytes = IOUtils.toByteArray((InputStream)data);
            byte[] hash = DigestAlgorithms.digest(new ByteArrayInputStream(srcBytes), externalDigest.getMessageDigest(hashAlgorithm));
            hash = Base64.encode((byte[])hash);
            byte[] extSignature = externalSignature.sign(hash);
            sgn.setExternalDigest(extSignature, null, externalSignature.getEncryptionAlgorithm());
            encodedSig = sgn.getEncodedPKCS7(hash, null, tsaClient, null, null, sigtype);
        } else if ("SM2".equals(encryptionAlgorithm)) {
            int n;
            MessageDigest messageDigest = externalDigest.getMessageDigest(hashAlgorithm);
            byte[] userId = "1234567812345678".getBytes("UTF8");
            PdfX509Certificate pdfX509Certificate = (PdfX509Certificate)chain[0];
            SM2PublicKey sm2PublicKey = (SM2PublicKey)pdfX509Certificate.getPublicKey();
            BigInteger pubX = sm2PublicKey.getPubXByInt();
            BigInteger pubY = sm2PublicKey.getPubYByInt();
            byte[] z = SM2HashZValue.getZa((BigInteger)pubX, (BigInteger)pubY, (byte[])userId);
            messageDigest.update(z, 0, z.length);
            byte[] srcBuf = new byte[8192];
            while ((n = data.read(srcBuf)) > 0) {
                messageDigest.update(srcBuf, 0, n);
            }
            byte[] digest = messageDigest.digest();
            BCSoftLib bclib = new BCSoftLib();
            PrivateKey priKey = externalSignature.getPrivateKey();
            try {
                byte[] signture;
                Mechanism mechanism = new Mechanism("sm3WithSM2Encryption");
                byte[] tsaHashData = signture = bclib.signByHash(mechanism, priKey, digest);
                byte[] timeStampPKCS7 = null;
                if (null != tsaClient) {
                    tsaClient.setHashAlg("SM3");
                    tsaHashData = HashUtil.SM3HashData((byte[])signture, (SM2PublicKey)sm2PublicKey, (Session)bclib, (boolean)false);
                    timeStampPKCS7 = tsaClient.getTimeStampToken(tsaHashData);
                }
                encodedSig = DefaultPKCS7Package.packagePKCS7((Session)bclib, null, signture, mechanism, timeStampPKCS7, null, new X509Cert[]{pdfX509Certificate.getX509Cert()});
            }
            catch (PKIException e) {
                throw new GeneralSecurityException(e.getMessage());
            }
            catch (TSPException e) {
                throw new GeneralSecurityException(e.getMessage());
            }
        }
        if (estimatedSize < encodedSig.length) {
            throw new IOException("Not enough space");
        }
        byte[] paddedSig = new byte[estimatedSize];
        System.arraycopy(encodedSig, 0, paddedSig, 0, encodedSig.length);
        PdfDictionary dic2 = new PdfDictionary();
        dic2.put(PdfName.CONTENTS, new PdfString(paddedSig).setHexWriting(true));
        sap.close(dic2);
        logger.info("end signDetached...");
    }

    public static void signReserved(PdfSignatureAppearance sap, ExternalDigest externalDigest, ExternalSignature externalSignature, Certificate[] chain, Collection<CrlClient> crlList, OcspClient ocspClient, TSAClient tsaClient, int estimatedSize, CryptoStandard sigtype, ReservedPdfPKCS7 reservedPdfPKCS7, Option option) throws IOException, DocumentException, GeneralSecurityException {
        byte[] srcBuf;
        logger.info("begin signReserved...");
        if (reservedPdfPKCS7 == null) {
            throw new GeneralSecurityException("paramter reservedPdfPKCS7 must not null!");
        }
        Collection<byte[]> crlBytes = null;
        int i = 0;
        while (crlBytes == null && chain != null && i < chain.length) {
            crlBytes = MakeSignature.processCrl(chain[i++], crlList);
        }
        if (estimatedSize == 0) {
            estimatedSize = 8192;
            if (crlBytes != null) {
                for (byte[] element : crlBytes) {
                    estimatedSize += element.length + 10;
                }
            }
            if (ocspClient != null) {
                estimatedSize += 4192;
            }
            if (tsaClient != null) {
                estimatedSize += 4192;
            }
        }
        if (4 != (reservedPdfPKCS7.type & 4) && 16 != (reservedPdfPKCS7.type & 0x10)) {
            sap.setCertificate(chain[0]);
        }
        if (sigtype == CryptoStandard.CADES) {
            sap.addDeveloperExtension(PdfDeveloperExtension.ESIC_1_7_EXTENSIONLEVEL2);
        }
        PdfSignature dic = null;
        String encryptionAlgorithm = externalSignature.getEncryptionAlgorithm();
        if ("RSA".equals(encryptionAlgorithm)) {
            dic = option.docHashBase64Encoding ? new PdfSignature(PdfName.CFCA_TrustSignPDF, PdfName.RSA_BASE64_SHA1) : new PdfSignature(PdfName.ADOBE_PPKLITE, sigtype == CryptoStandard.CADES ? PdfName.ETSI_CADES_DETACHED : PdfName.ADBE_PKCS7_DETACHED);
        } else if ("SM2".equals(encryptionAlgorithm)) {
            dic = new PdfSignature(PdfName.CFCA_TrustSignPDF, PdfName.CFCA_SM2_PKCS7_DETACHED);
        }
        if (null == dic) {
            throw new GeneralSecurityException("unsuported pdf signature filter!");
        }
        dic.setReason(sap.getReason());
        dic.setLocation(sap.getLocation());
        dic.setSignatureCreator(sap.getSignatureCreator());
        dic.setContact(sap.getContact());
        dic.setDate(new PdfDate(sap.getSignDate()));
        sap.setCryptoDictionary(dic);
        sap.setEncryptionAlgorithm(encryptionAlgorithm);
        HashMap<PdfName, Integer> exc = new HashMap<PdfName, Integer>();
        exc.put(PdfName.CONTENTS, new Integer(estimatedSize * 2 + 2));
        sap.preClose(exc);
        InputStream data = sap.getRangeStream();
        String hashAlgorithm = externalSignature.getHashAlgorithm();
        if ("RSA".equals(encryptionAlgorithm) || "RSA_CUSTOM_COMMBANK".equals(encryptionAlgorithm)) {
            if (2 == (reservedPdfPKCS7.type & 2)) {
                if (!option.docHashBase64Encoding) {
                    srcBuf = IOUtils.toByteArray((InputStream)data);
                    PdfPKCS7 sgn = new PdfPKCS7(null, chain, hashAlgorithm, null, externalDigest, false);
                    byte[] hash = DigestAlgorithms.digest(new ByteArrayInputStream(srcBuf), externalDigest.getMessageDigest(hashAlgorithm));
                    byte[] ocsp = null;
                    if (chain.length >= 2 && ocspClient != null) {
                        ocsp = ocspClient.getEncoded((X509Certificate)chain[0], (X509Certificate)chain[1], null);
                    }
                    Calendar cal = Calendar.getInstance();
                    byte[] sh = sgn.getAuthenticatedAttributeBytes(hash, cal, ocsp, crlBytes, sigtype);
                    reservedPdfPKCS7.fieldName = sap.getFieldName();
                    reservedPdfPKCS7.encryptionAlgorithm = encryptionAlgorithm;
                    reservedPdfPKCS7.hashAlgorithm = hashAlgorithm;
                    reservedPdfPKCS7.pdfBytes = srcBuf;
                    reservedPdfPKCS7.hashPdf = hash;
                    reservedPdfPKCS7.signatureAttr = sh;
                    if (cal != null) {
                        reservedPdfPKCS7.calendarLocalString = new PdfDate(cal).toString();
                    }
                    if (tsaClient != null) {
                        reservedPdfPKCS7.tsaUrl = tsaClient.getTSAURL();
                        reservedPdfPKCS7.tsaUserName = tsaClient.getTSAUserName();
                        reservedPdfPKCS7.tsaPassword = tsaClient.getTSAPassword();
                        reservedPdfPKCS7.tsaEstimatedTokenSize = tsaClient.getTokenSizeEstimate();
                        reservedPdfPKCS7.tsaDigestAlgorithm = tsaClient.getMessageDigest().getAlgorithm();
                    }
                    reservedPdfPKCS7.ocspBytes = ocsp;
                    if (crlBytes != null) {
                        reservedPdfPKCS7.crlBytes = (byte[][])crlBytes.toArray((T[])new byte[0][]);
                    }
                    ArrayList<byte[]> collectionChain = new ArrayList<byte[]>();
                    for (i = 0; i < chain.length; ++i) {
                        X509Certificate x509Certificate = (X509Certificate)chain[i];
                        collectionChain.add(x509Certificate.getEncoded());
                    }
                    reservedPdfPKCS7.chainBytes = (byte[][])collectionChain.toArray((T[])new byte[0][]);
                    reservedPdfPKCS7.cryptostandard = CryptoStandard.CADES == sigtype ? CryptoStandard.CADES.ordinal() : CryptoStandard.CMS.ordinal();
                } else {
                    srcBuf = IOUtils.toByteArray((InputStream)data);
                    byte[] hash = DigestAlgorithms.digest(new ByteArrayInputStream(srcBuf), externalDigest.getMessageDigest(hashAlgorithm));
                    reservedPdfPKCS7.type = 1;
                    reservedPdfPKCS7.fieldName = sap.getFieldName();
                    reservedPdfPKCS7.encryptionAlgorithm = encryptionAlgorithm;
                    reservedPdfPKCS7.hashAlgorithm = hashAlgorithm;
                    reservedPdfPKCS7.hashPdf = hash;
                    reservedPdfPKCS7.pdfBytes = srcBuf;
                    hash = Base64.encode((byte[])hash);
                    reservedPdfPKCS7.signatureAttr = hash;
                    if (tsaClient != null) {
                        reservedPdfPKCS7.tsaUrl = tsaClient.getTSAURL();
                        reservedPdfPKCS7.tsaUserName = tsaClient.getTSAUserName();
                        reservedPdfPKCS7.tsaPassword = tsaClient.getTSAPassword();
                        reservedPdfPKCS7.tsaEstimatedTokenSize = tsaClient.getTokenSizeEstimate();
                        reservedPdfPKCS7.tsaDigestAlgorithm = tsaClient.getMessageDigest().getAlgorithm();
                    }
                    ArrayList<byte[]> collectionChain = new ArrayList<byte[]>();
                    for (i = 0; i < chain.length; ++i) {
                        X509Certificate x509Certificate = (X509Certificate)chain[i];
                        collectionChain.add(x509Certificate.getEncoded());
                    }
                    reservedPdfPKCS7.chainBytes = (byte[][])collectionChain.toArray((T[])new byte[0][]);
                    reservedPdfPKCS7.cryptostandard = CryptoStandard.CADES == sigtype ? CryptoStandard.CADES.ordinal() : CryptoStandard.CMS.ordinal();
                }
            } else if (4 == (reservedPdfPKCS7.type & 4)) {
                srcBuf = IOUtils.toByteArray((InputStream)data);
                byte[] hashPdf = DigestAlgorithms.digest(new ByteArrayInputStream(srcBuf), externalDigest.getMessageDigest(hashAlgorithm));
                reservedPdfPKCS7.fieldName = sap.getFieldName();
                reservedPdfPKCS7.encryptionAlgorithm = encryptionAlgorithm;
                reservedPdfPKCS7.hashAlgorithm = hashAlgorithm;
                reservedPdfPKCS7.hashPdf = hashPdf;
                reservedPdfPKCS7.pdfBytes = srcBuf;
                reservedPdfPKCS7.signatureAttr = srcBuf;
            }
        } else if ("SM2".equals(encryptionAlgorithm)) {
            srcBuf = IOUtils.toByteArray((InputStream)data);
            reservedPdfPKCS7.fieldName = sap.getFieldName();
            reservedPdfPKCS7.encryptionAlgorithm = encryptionAlgorithm;
            reservedPdfPKCS7.hashAlgorithm = hashAlgorithm;
            byte[] userId = "1234567812345678".getBytes("UTF8");
            PdfX509Certificate pdfX509Certificate0 = (PdfX509Certificate)chain[0];
            X509Cert x509Cert = pdfX509Certificate0.getX509Cert();
            try {
                SM2PublicKey sm2PublicKey = (SM2PublicKey)x509Cert.getPublicKey();
                BigInteger pubX = sm2PublicKey.getPubXByInt();
                BigInteger pubY = sm2PublicKey.getPubYByInt();
                byte[] sm3Bytes = HashUtil.SM2HashMessageByBCWithZValue((byte[])userId, (byte[])srcBuf, (BigInteger)pubX, (BigInteger)pubY);
                reservedPdfPKCS7.hashPdf = sm3Bytes;
            }
            catch (PKIException e) {
                e.printStackTrace();
            }
            reservedPdfPKCS7.signatureAttr = srcBuf;
            if (tsaClient != null) {
                reservedPdfPKCS7.tsaUrl = tsaClient.getTSAURL();
                reservedPdfPKCS7.tsaUserName = tsaClient.getTSAUserName();
                reservedPdfPKCS7.tsaPassword = tsaClient.getTSAPassword();
                reservedPdfPKCS7.tsaEstimatedTokenSize = tsaClient.getTokenSizeEstimate();
                reservedPdfPKCS7.tsaDigestAlgorithm = tsaClient.getMessageDigest().getAlgorithm();
            }
            byte[] ocsp = null;
            if (chain.length >= 2 && ocspClient != null) {
                ocsp = ocspClient.getEncoded((X509Certificate)chain[0], (X509Certificate)chain[1], null);
            }
            reservedPdfPKCS7.ocspBytes = ocsp;
            if (crlBytes != null) {
                reservedPdfPKCS7.crlBytes = (byte[][])crlBytes.toArray((T[])new byte[0][]);
            }
            ArrayList<byte[]> collectionChain = new ArrayList<byte[]>();
            for (i = 0; i < chain.length; ++i) {
                PdfX509Certificate pdfX509Certificate = (PdfX509Certificate)chain[i];
                collectionChain.add(pdfX509Certificate.getEncoded());
            }
            reservedPdfPKCS7.chainBytes = (byte[][])collectionChain.toArray((T[])new byte[0][]);
            if (CryptoStandard.CADES == sigtype) {
                reservedPdfPKCS7.cryptostandard = CryptoStandard.CADES.ordinal();
            } else if (CryptoStandard.CMS == sigtype) {
                reservedPdfPKCS7.cryptostandard = CryptoStandard.CMS.ordinal();
            }
        }
        byte[] paddedSig = new byte[estimatedSize];
        PdfDictionary dic2 = new PdfDictionary();
        dic2.put(PdfName.CONTENTS, new PdfString(paddedSig).setHexWriting(true));
        sap.close(dic2);
        logger.info("end signReserved...");
    }

    public static Collection<byte[]> processCrl(Certificate cert, Collection<CrlClient> crlList) {
        if (crlList == null) {
            return null;
        }
        ArrayList<byte[]> crlBytes = new ArrayList<byte[]>();
        for (CrlClient cc : crlList) {
            Collection<byte[]> b;
            if (cc == null || (b = cc.getEncoded((X509Certificate)cert, null)) == null) continue;
            crlBytes.addAll(b);
        }
        if (crlBytes.isEmpty()) {
            return null;
        }
        return crlBytes;
    }

    public static void signExternalContainer(PdfSignatureAppearance sap, ExternalSignatureContainer externalSignatureContainer, int estimatedSize) throws GeneralSecurityException, IOException, DocumentException {
        logger.info("begin signExternalContainer...");
        PdfSignature dic = new PdfSignature(null, null);
        dic.setReason(sap.getReason());
        dic.setLocation(sap.getLocation());
        dic.setSignatureCreator(sap.getSignatureCreator());
        dic.setContact(sap.getContact());
        dic.setDate(new PdfDate(sap.getSignDate()));
        externalSignatureContainer.modifySigningDictionary(dic);
        sap.setCryptoDictionary(dic);
        HashMap<PdfName, Integer> exc = new HashMap<PdfName, Integer>();
        exc.put(PdfName.CONTENTS, new Integer(estimatedSize * 2 + 2));
        sap.preClose(exc);
        InputStream data = sap.getRangeStream();
        byte[] encodedSig = externalSignatureContainer.sign(data);
        if (estimatedSize < encodedSig.length) {
            throw new IOException("Not enough space");
        }
        byte[] paddedSig = new byte[estimatedSize];
        System.arraycopy(encodedSig, 0, paddedSig, 0, encodedSig.length);
        PdfDictionary dic2 = new PdfDictionary();
        dic2.put(PdfName.CONTENTS, new PdfString(paddedSig).setHexWriting(true));
        sap.close(dic2);
        logger.info("end signExternalContainer...");
    }

    public static void signDeferred(PdfReader reader, String fieldName, OutputStream outs, ExternalSignatureContainer externalSignatureContainer) throws DocumentException, IOException, GeneralSecurityException {
        logger.info("begin signDeferred...");
        AcroFields af = reader.getAcroFields();
        PdfDictionary v = af.getSignatureDictionary(fieldName);
        if (v == null) {
            throw new DocumentException("No field");
        }
        if (!af.signatureCoversWholeDocument(fieldName)) {
            throw new DocumentException("Not the last signature");
        }
        PdfArray b = v.getAsArray(PdfName.BYTERANGE);
        long[] gaps = b.asLongArray();
        if (b.size() != 4 || gaps[0] != 0L) {
            throw new DocumentException("Single exclusion space supported");
        }
        RandomAccessSource readerSource = reader.getSafeFile().createSourceView();
        RASInputStream rg = new RASInputStream(new RandomAccessSourceFactory().createRanged(readerSource, gaps));
        byte[] signedContent = externalSignatureContainer.sign(rg);
        int spaceAvailable = (int)(gaps[2] - gaps[1]) - 2;
        if ((spaceAvailable & 1) != 0) {
            throw new DocumentException("Gap is not a multiple of 2");
        }
        if ((spaceAvailable /= 2) < signedContent.length) {
            throw new DocumentException("Not enough space");
        }
        StreamUtil.CopyBytes(readerSource, 0L, gaps[1] + 1L, outs);
        ByteBuffer bb = new ByteBuffer(spaceAvailable * 2);
        for (byte bi : signedContent) {
            bb.appendHex(bi);
        }
        int remain = (spaceAvailable - signedContent.length) * 2;
        for (int k = 0; k < remain; ++k) {
            bb.append((byte)48);
        }
        bb.writeTo(outs);
        bb.close();
        StreamUtil.CopyBytes(readerSource, gaps[2] - 1L, gaps[3] + 1L, outs);
        logger.info("end signDeferred...");
    }

    public static void signDeferred(PdfReader reader, String fieldName, OutputStream outs, byte[] signedContent) throws DocumentException, IOException {
        logger.info("begin signDeferred...");
        AcroFields af = reader.getAcroFields();
        PdfDictionary v = af.getSignatureDictionary(fieldName);
        if (v == null) {
            throw new DocumentException("No field");
        }
        if (!af.signatureCoversWholeDocument(fieldName)) {
            throw new DocumentException("Not the last signature");
        }
        PdfArray b = v.getAsArray(PdfName.BYTERANGE);
        long[] gaps = b.asLongArray();
        if (b.size() != 4 || gaps[0] != 0L) {
            throw new DocumentException("Single exclusion space supported");
        }
        RandomAccessSource readerSource = reader.getSafeFile().createSourceView();
        int spaceAvailable = (int)(gaps[2] - gaps[1]) - 2;
        if ((spaceAvailable & 1) != 0) {
            throw new DocumentException("Gap is not a multiple of 2");
        }
        if ((spaceAvailable /= 2) < signedContent.length) {
            throw new DocumentException("Not enough space");
        }
        StreamUtil.CopyBytes(readerSource, 0L, gaps[1] + 1L, outs);
        ByteBuffer bb = new ByteBuffer(spaceAvailable * 2);
        for (byte bi : signedContent) {
            bb.appendHex(bi);
        }
        int remain = (spaceAvailable - signedContent.length) * 2;
        for (int k = 0; k < remain; ++k) {
            bb.append((byte)48);
        }
        bb.writeTo(outs);
        bb.close();
        StreamUtil.CopyBytes(readerSource, gaps[2] - 1L, gaps[3] + 1L, outs);
        logger.info("end signDeferred...");
    }

    public static class Option {
        public boolean docHashBase64Encoding;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CryptoStandard {
        CMS,
        CADES;

    }
}

