/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.client.conf;

import cfca.sadk.timestamp.client.utils.TscPropsUtil;
import cfca.sadk.timestamp.exception.TSAException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.apache.http.util.TextUtils;

public final class TscCommonConf {
    private int warningThresholdTime;
    private String httpURL;
    private int httpConnectTimeout;
    private int httpSocketTimeout;
    private int httpRequestTimeout;
    private String httpProxyURL;
    private boolean httpProxyEnable;

    public TscCommonConf() {
        this.warningThresholdTime = 5000;
        this.httpURL = null;
        this.httpConnectTimeout = 5000;
        this.httpSocketTimeout = 5000;
        this.httpRequestTimeout = 5000;
        this.httpProxyURL = null;
        this.httpProxyEnable = false;
    }

    public TscCommonConf(Properties properties) throws TSAException {
        this.warningThresholdTime = TscPropsUtil.getInt(properties, "timestamp.loggingWarningTime", 5000);
        this.httpURL = this.checkURL(TscPropsUtil.getString(properties, "timestamp.http.url", null));
        this.httpConnectTimeout = TscPropsUtil.getInt(properties, "timestamp.http.connectTimeout", 5000);
        this.httpSocketTimeout = TscPropsUtil.getInt(properties, "timestamp.http.socketTimeout", 5000);
        this.httpRequestTimeout = TscPropsUtil.getInt(properties, "timestamp.http.requestTimeout", 5000);
        this.httpProxyURL = TscPropsUtil.getString(properties, "timestamp.http.proxy.url", null);
        this.httpProxyEnable = TscPropsUtil.getBoolean(properties, "timestamp.http.proxy.enable", false);
    }

    public String checkURL(String httpURL) throws TSAException {
        if (!TextUtils.isBlank((CharSequence)httpURL)) {
            URL serverUrl;
            try {
                serverUrl = new URL(httpURL);
            }
            catch (MalformedURLException e) {
                throw new TSAException("httpURL invalid other than start with http or https: " + httpURL, (Throwable)e);
            }
            String protocol = serverUrl.getProtocol();
            if (!protocol.equals("http") && !protocol.equals("https")) {
                throw new TSAException("httpURL do not support other than http or https: " + serverUrl);
            }
        }
        return httpURL;
    }

    public int getWarningThresholdTime() {
        return this.warningThresholdTime;
    }

    public TscCommonConf setLoggingWarningTime(int warningThresholdTime) {
        this.warningThresholdTime = warningThresholdTime;
        return this;
    }

    public String getHttpURL() {
        return this.httpURL;
    }

    public TscCommonConf setHttpURL(String httpURL) {
        this.httpURL = httpURL;
        return this;
    }

    public int getHttpConnectTimeout() {
        return this.httpConnectTimeout;
    }

    public TscCommonConf setHttpConnectTimeout(int httpConnectTimeout) {
        this.httpConnectTimeout = httpConnectTimeout;
        return this;
    }

    public int getHttpSocketTimeout() {
        return this.httpSocketTimeout;
    }

    public TscCommonConf setHttpSocketTimeout(int httpSocketTimeout) {
        this.httpSocketTimeout = httpSocketTimeout;
        return this;
    }

    public int getHttpRequestTimeout() {
        return this.httpRequestTimeout;
    }

    public TscCommonConf setHttpRequestTimeout(int httpRequestTimeout) {
        this.httpRequestTimeout = httpRequestTimeout;
        return this;
    }

    public String getHttpProxyURL() {
        return this.httpProxyURL;
    }

    public TscCommonConf setHttpProxyURL(String httpProxyURL) {
        this.httpProxyURL = httpProxyURL;
        return this;
    }

    public boolean isHttpProxyEnable() {
        return this.httpProxyEnable;
    }

    public TscCommonConf setHttpProxyEnable(boolean httpProxyEnable) {
        this.httpProxyEnable = httpProxyEnable;
        return this;
    }

    public boolean isHttps() {
        String https = "https://";
        boolean isHttps = false;
        if (!TextUtils.isBlank((CharSequence)this.httpURL)) {
            isHttps = this.httpURL.toLowerCase().startsWith("https://");
        }
        return isHttps;
    }

    public final String toString() {
        return this.append(new StringBuilder(128), false).toString();
    }

    public final StringBuilder append(StringBuilder builder, boolean hidden) {
        if (builder != null) {
            builder.append("\n\t TssCommonConf [");
            builder.append("\n\t\t loggingWarningTime=").append(this.warningThresholdTime);
            builder.append("\n\t\t httpURL=").append(this.httpURL);
            builder.append("\n\t\t httpConnectTimeout=").append(this.httpConnectTimeout);
            builder.append("\n\t\t httpSocketTimeout=").append(this.httpSocketTimeout);
            builder.append("\n\t\t httpRequestTimeout=").append(this.httpRequestTimeout);
            builder.append("\n\t\t httpProxyURL=").append(this.httpProxyURL);
            builder.append("\n\t\t httpProxyEnable=").append(this.httpProxyEnable);
            builder.append("\n\t\t ]");
        }
        return builder;
    }
}

