/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.base.ofd;

import cfca.com.google.typography.font.sfntly.Font;
import cfca.com.google.typography.font.sfntly.Tag;
import cfca.com.google.typography.font.sfntly.table.core.FontHeaderTable;
import cfca.com.google.typography.font.sfntly.table.core.HorizontalMetricsTable;
import cfca.com.google.typography.font.tools.fontinfo.FontInfo;
import cfca.com.google.typography.font.tools.fontinfo.FontUtils;
import cfca.com.google.typography.font.tools.sfnttool.GlyphCoverage;
import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.ofd.base.ofd.TextLocation;
import java.awt.FontFormatException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OFDContentParser {
    private static Logger businessLog = LoggerFactory.getLogger(OFDContentParser.class);
    private HashMap<String, Font> oneFileFontCacheMap = new HashMap();
    private HashMap<String, String> errorFontCacheMap = new HashMap();

    public String parseFontInfo(Map<String, byte[]> filesMap, List<TextLocation> pageTextLocations) throws IOException, FontFormatException {
        StringBuilder pageWords = new StringBuilder();
        for (int i = 0; i < pageTextLocations.size(); ++i) {
            TextLocation textLocation = pageTextLocations.get(i);
            String fontID = textLocation.getFontId();
            String glyphs = textLocation.getGlyphs();
            Font font = this.parseFontInfo(filesMap, fontID);
            String realText = FontInfo.listChars(font, glyphs);
            pageWords.append(realText);
        }
        return pageWords.toString();
    }

    public String parseFontInfo(Map<String, byte[]> filesMap, String fontID, String glyphs) throws IOException, FontFormatException {
        Font font = this.parseFontInfo(filesMap, fontID);
        String realText = FontInfo.listChars(font, glyphs);
        return realText;
    }

    private Font parseFontInfo(Map<String, byte[]> filesMap, String fontID) throws IOException, FontFormatException {
        Font resultFont = null;
        if (!this.oneFileFontCacheMap.containsKey(fontID) && !this.errorFontCacheMap.containsKey(fontID)) {
            for (Map.Entry<String, byte[]> entry : filesMap.entrySet()) {
                String filePath = entry.getKey();
                if (!filePath.endsWith("ttf") || !filePath.contains("font_" + fontID)) continue;
                byte[] fontData = filesMap.get(filePath);
                ByteArrayInputStream in = new ByteArrayInputStream(fontData);
                Font[] fontInfo = null;
                try {
                    fontInfo = FontUtils.getFonts(in);
                }
                catch (Throwable e) {
                    this.errorFontCacheMap.put(fontID, fontID);
                }
                if (fontInfo == null) continue;
                resultFont = this.oneFileFontCacheMap.put(fontID, fontInfo[0]);
                break;
            }
        } else {
            resultFont = this.oneFileFontCacheMap.get(fontID);
        }
        return resultFont;
    }

    public float getFontWidth(Map<String, byte[]> filesMap, String fontID, String text, float fontSize) {
        float textWidth = 0.0f;
        try {
            Font fontInfo = this.parseFontInfo(filesMap, fontID);
            textWidth = this.getFontWidthBySfntly(fontInfo, text, fontSize);
        }
        catch (Exception e) {
            this.errorFontCacheMap.put(fontID, fontID);
            textWidth = 0.0f;
        }
        return textWidth;
    }

    private float getFontWidthBySfntly(Font font, String text, float fontSize) {
        HashMap<String, List<Integer>> glyphs = GlyphCoverage.getGlyphCoverage(font, text);
        List<Integer> glyphList = glyphs.get("originGlyphs");
        HorizontalMetricsTable hmtx = (HorizontalMetricsTable)font.getTable(Tag.hmtx);
        FontHeaderTable fontHeadTable = (FontHeaderTable)font.getTable(Tag.head);
        int unitsPerEm = fontHeadTable.unitsPerEm();
        float sumWidth = 0.0f;
        for (int i = 0; i < glyphList.size(); ++i) {
            Integer glyphId = glyphList.get(i);
            sumWidth += (float)hmtx.advanceWidth(glyphId);
        }
        return sumWidth * fontSize / (float)unitsPerEm;
    }

    public void destroy() {
        if (this.oneFileFontCacheMap != null) {
            this.oneFileFontCacheMap.clear();
            this.oneFileFontCacheMap = null;
        }
        if (this.errorFontCacheMap != null) {
            this.errorFontCacheMap.clear();
            this.errorFontCacheMap = null;
        }
    }
}

