/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.base.util;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.util.BigIntegers;

public class PaperlessSM2Util {
    public static final byte[] SM2RStoASN1(byte[] signData) throws PKIException {
        byte[] outBytes = null;
        if (signData != null && signData.length == 64) {
            try {
                byte[] R32Bytes = new byte[32];
                byte[] S32Bytes = new byte[32];
                System.arraycopy(signData, 0, R32Bytes, 0, 32);
                System.arraycopy(signData, 32, S32Bytes, 0, 32);
                ASN1EncodableVector rsV = new ASN1EncodableVector();
                rsV.add((ASN1Encodable)BigIntegers.fromByteArray((byte[])R32Bytes, (int)32));
                rsV.add((ASN1Encodable)BigIntegers.fromByteArray((byte[])S32Bytes, (int)32));
                DERSequence rsSequence = new DERSequence(rsV);
                outBytes = rsSequence.getEncoded();
            }
            catch (Exception e) {
                throw new PKIException("SM2Signature Encoded Failure", (Throwable)e);
            }
        } else {
            outBytes = signData;
        }
        return outBytes;
    }
}

