/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.oss.config;

import com.aliyun.oss.OSSClient;
import com.obs.services.ObsClient;
import com.obs.services.ObsConfiguration;
import org.springblade.core.oss.HuaweiObsTemplate;
import org.springblade.core.oss.config.OssConfiguration;
import org.springblade.core.oss.props.OssProperties;
import org.springblade.core.oss.rule.BladeOssRule;
import org.springblade.core.oss.rule.OssRule;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={OssConfiguration.class})
@EnableConfigurationProperties(value={OssProperties.class})
@ConditionalOnClass(value={OSSClient.class})
@ConditionalOnProperty(value={"oss.name"}, havingValue="huaweiobs")
public class HuaweiObsConfiguration {
    private final OssProperties ossProperties;

    @Bean
    @ConditionalOnMissingBean(value={OssRule.class})
    public OssRule ossRule() {
        return new BladeOssRule(this.ossProperties.getTenantMode());
    }

    @Bean
    @ConditionalOnMissingBean(value={ObsClient.class})
    public ObsClient ossClient() {
        ObsConfiguration conf = new ObsConfiguration();
        conf.setEndPoint(this.ossProperties.getEndpoint());
        conf.setMaxConnections(1024);
        conf.setSocketTimeout(50000);
        conf.setConnectionTimeout(50000);
        conf.setConnectionRequestTimeout(1000);
        conf.setIdleConnectionTime(60000);
        conf.setMaxErrorRetry(5);
        return new ObsClient(this.ossProperties.getAccessKey(), this.ossProperties.getSecretKey(), conf);
    }

    @Bean
    @ConditionalOnMissingBean(value={HuaweiObsTemplate.class})
    @ConditionalOnBean(value={ObsClient.class, OssRule.class})
    public HuaweiObsTemplate huaweiobsTemplate(ObsClient obsClient, OssRule ossRule) {
        return new HuaweiObsTemplate(obsClient, this.ossProperties, ossRule);
    }

    public HuaweiObsConfiguration(OssProperties ossProperties) {
        this.ossProperties = ossProperties;
    }
}

