/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.styledxmlparser.jsoup.nodes;

import cfca.sadk.com.itextpdf.styledxmlparser.jsoup.helper.StringUtil;
import cfca.sadk.com.itextpdf.styledxmlparser.jsoup.nodes.Document;
import cfca.sadk.com.itextpdf.styledxmlparser.jsoup.nodes.Node;
import java.io.IOException;

public class DocumentType
extends Node {
    private static final String NAME = "name";
    private static final String PUBLIC_ID = "publicId";
    private static final String SYSTEM_ID = "systemId";

    public DocumentType(String name, String publicId, String systemId, String baseUri) {
        super(baseUri);
        this.attr(NAME, name);
        this.attr(PUBLIC_ID, publicId);
        this.attr(SYSTEM_ID, systemId);
    }

    @Override
    public String nodeName() {
        return "#doctype";
    }

    @Override
    void outerHtmlHead(Appendable accum, int depth, Document.OutputSettings out) throws IOException {
        if (out.syntax() == Document.OutputSettings.Syntax.html && !this.has(PUBLIC_ID) && !this.has(SYSTEM_ID)) {
            accum.append("<!doctype");
        } else {
            accum.append("<!DOCTYPE");
        }
        if (this.has(NAME)) {
            accum.append(" ").append(this.attr(NAME));
        }
        if (this.has(PUBLIC_ID)) {
            accum.append(" PUBLIC \"").append(this.attr(PUBLIC_ID)).append('\"');
        }
        if (this.has(SYSTEM_ID)) {
            accum.append(" \"").append(this.attr(SYSTEM_ID)).append('\"');
        }
        accum.append('>');
    }

    @Override
    void outerHtmlTail(Appendable accum, int depth, Document.OutputSettings out) {
    }

    private boolean has(String attribute) {
        return !StringUtil.isBlank(this.attr(attribute));
    }
}

