/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.card.c200r;

import cfca.sadk.lib.crypto.card.CardException;
import cfca.sadk.lib.crypto.card.CardParameterException;
import cfca.sadk.lib.crypto.card.c200r.BigIntegers;
import cfca.sadk.org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import java.math.BigInteger;

final class RSARefPrivateKeyParams {
    final byte[] keyData;
    final int bitLength;
    final RSAPrivateCrtKeyParameters params;

    RSARefPrivateKeyParams(byte[] keyData) throws CardException {
        int bitLength = BigIntegers.parseModulusBitLength(keyData);
        if (keyData.length < 2820) {
            throw new CardParameterException("decodePublicKeyParameters failure with invalid param#c200RKeyData");
        }
        int eMaxBitLength = 32;
        int maxLength = 512;
        int offset = 4;
        BigInteger modulus = BigIntegers.parseBigInteger(keyData, offset, 512, bitLength);
        BigInteger publicExponent = BigIntegers.parseBigInteger(keyData, offset += 512, 512, 32);
        BigInteger privateExponent = BigIntegers.parseBigInteger(keyData, offset += 512, 512, bitLength);
        int othersLength = 256;
        int othersBitLength = bitLength >> 1;
        BigInteger primeP = BigIntegers.parseBigInteger(keyData, offset += 512, 256, othersBitLength);
        BigInteger primeQ = BigIntegers.parseBigInteger(keyData, offset += 256, 256, othersBitLength);
        BigInteger exponentP = BigIntegers.parseBigInteger(keyData, offset += 256, 256, othersBitLength);
        BigInteger exponentQ = BigIntegers.parseBigInteger(keyData, offset += 256, 256, othersBitLength);
        BigInteger coefficient = BigIntegers.parseBigInteger(keyData, offset += 256, 256, othersBitLength);
        this.keyData = keyData;
        this.bitLength = bitLength;
        this.params = new RSAPrivateCrtKeyParameters(modulus, publicExponent, privateExponent, primeP, primeQ, exponentP, exponentQ, coefficient);
    }

    RSARefPrivateKeyParams(RSAPrivateCrtKeyParameters params) throws CardException {
        if (params == null) {
            throw new CardParameterException("RSARefPrivateKeyParams failure with invalid param#params");
        }
        BigInteger modulus = params.getModulus();
        int bitLength = BigIntegers.parseModulusBitLength(modulus);
        byte[] keyData = this.buildKeyData(bitLength, params);
        this.params = params;
        this.bitLength = bitLength;
        this.keyData = keyData;
    }

    private byte[] buildKeyData(int bitLength, RSAPrivateCrtKeyParameters params) throws CardException {
        byte[] keyData = new byte[2820];
        int offset = BigIntegers.copyBitLength(bitLength, keyData, 0);
        int maxLength = 512;
        BigIntegers.copyBigInteger("params#modulus", params.getModulus(), 512, keyData, offset);
        BigIntegers.copyBigInteger("params#publicExponent", params.getPublicExponent(), 512, keyData, offset += 512);
        BigIntegers.copyBigInteger("params#privateExponent", params.getExponent(), 512, keyData, offset += 512);
        int othersLength = 256;
        BigIntegers.copyBigInteger("params#primeP", params.getP(), 256, keyData, offset += 512);
        BigIntegers.copyBigInteger("params#primeQ", params.getQ(), 256, keyData, offset += 256);
        BigIntegers.copyBigInteger("params#exponentP", params.getDP(), 256, keyData, offset += 256);
        BigIntegers.copyBigInteger("params#exponentQ", params.getDQ(), 256, keyData, offset += 256);
        BigIntegers.copyBigInteger("params#coefficient", params.getQInv(), 256, keyData, offset += 256);
        if ((offset += 256) != keyData.length) {
            throw new CardParameterException("buildKeyData failure with invalid offset");
        }
        return keyData;
    }
}

