/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.crypto.engines;

import cfca.sadk.org.bouncycastle.crypto.BlockCipher;
import cfca.sadk.org.bouncycastle.crypto.CipherParameters;
import cfca.sadk.org.bouncycastle.crypto.InvalidCipherTextException;
import cfca.sadk.org.bouncycastle.crypto.Wrapper;
import cfca.sadk.org.bouncycastle.crypto.engines.RFC3394WrapEngine;
import cfca.sadk.org.bouncycastle.crypto.params.KeyParameter;
import cfca.sadk.org.bouncycastle.crypto.params.ParametersWithIV;
import cfca.sadk.org.bouncycastle.crypto.params.ParametersWithRandom;
import cfca.sadk.org.bouncycastle.util.Arrays;
import cfca.sadk.org.bouncycastle.util.Pack;

public class RFC5649WrapEngine
implements Wrapper {
    private BlockCipher engine;
    private KeyParameter param;
    private boolean forWrapping;
    private byte[] highOrderIV = new byte[]{-90, 89, 89, -90};
    private byte[] preIV = this.highOrderIV;
    private byte[] extractedAIV = null;

    public RFC5649WrapEngine(BlockCipher engine) {
        this.engine = engine;
    }

    public void init(boolean forWrapping, CipherParameters param) {
        this.forWrapping = forWrapping;
        if (param instanceof ParametersWithRandom) {
            param = ((ParametersWithRandom)param).getParameters();
        }
        if (param instanceof KeyParameter) {
            this.param = (KeyParameter)param;
        } else if (param instanceof ParametersWithIV) {
            this.preIV = ((ParametersWithIV)param).getIV();
            this.param = (KeyParameter)((ParametersWithIV)param).getParameters();
            if (this.preIV.length != 4) {
                throw new IllegalArgumentException("IV length not equal to 4");
            }
        }
    }

    public String getAlgorithmName() {
        return this.engine.getAlgorithmName();
    }

    private byte[] padPlaintext(byte[] plaintext) {
        int plaintextLength = plaintext.length;
        int numOfZerosToAppend = (8 - plaintextLength % 8) % 8;
        byte[] paddedPlaintext = new byte[plaintextLength + numOfZerosToAppend];
        System.arraycopy(plaintext, 0, paddedPlaintext, 0, plaintextLength);
        if (numOfZerosToAppend != 0) {
            byte[] zeros = new byte[numOfZerosToAppend];
            System.arraycopy(zeros, 0, paddedPlaintext, plaintextLength, numOfZerosToAppend);
        }
        return paddedPlaintext;
    }

    public byte[] wrap(byte[] in, int inOff, int inLen) {
        if (!this.forWrapping) {
            throw new IllegalStateException("not set for wrapping");
        }
        byte[] iv = new byte[8];
        byte[] mli = Pack.intToBigEndian(inLen);
        System.arraycopy(this.preIV, 0, iv, 0, this.preIV.length);
        System.arraycopy(mli, 0, iv, this.preIV.length, mli.length);
        byte[] relevantPlaintext = new byte[inLen];
        System.arraycopy(in, inOff, relevantPlaintext, 0, inLen);
        byte[] paddedPlaintext = this.padPlaintext(relevantPlaintext);
        if (paddedPlaintext.length == 8) {
            byte[] paddedPlainTextWithIV = new byte[paddedPlaintext.length + iv.length];
            System.arraycopy(iv, 0, paddedPlainTextWithIV, 0, iv.length);
            System.arraycopy(paddedPlaintext, 0, paddedPlainTextWithIV, iv.length, paddedPlaintext.length);
            this.engine.init(true, this.param);
            for (int i = 0; i < paddedPlainTextWithIV.length; i += this.engine.getBlockSize()) {
                this.engine.processBlock(paddedPlainTextWithIV, i, paddedPlainTextWithIV, i);
            }
            return paddedPlainTextWithIV;
        }
        RFC3394WrapEngine wrapper = new RFC3394WrapEngine(this.engine);
        ParametersWithIV paramsWithIV = new ParametersWithIV(this.param, iv);
        wrapper.init(true, paramsWithIV);
        return wrapper.wrap(paddedPlaintext, inOff, paddedPlaintext.length);
    }

    public byte[] unwrap(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        int upperBound;
        int lowerBound;
        byte[] paddedPlaintext;
        if (this.forWrapping) {
            throw new IllegalStateException("not set for unwrapping");
        }
        int n = inLen / 8;
        if (n * 8 != inLen) {
            throw new InvalidCipherTextException("unwrap data must be a multiple of 8 bytes");
        }
        if (n == 1) {
            throw new InvalidCipherTextException("unwrap data must be at least 16 bytes");
        }
        byte[] relevantCiphertext = new byte[inLen];
        System.arraycopy(in, inOff, relevantCiphertext, 0, inLen);
        byte[] decrypted = new byte[inLen];
        if (n == 2) {
            this.engine.init(false, this.param);
            for (int i = 0; i < relevantCiphertext.length; i += this.engine.getBlockSize()) {
                this.engine.processBlock(relevantCiphertext, i, decrypted, i);
            }
            this.extractedAIV = new byte[8];
            System.arraycopy(decrypted, 0, this.extractedAIV, 0, this.extractedAIV.length);
            paddedPlaintext = new byte[decrypted.length - this.extractedAIV.length];
            System.arraycopy(decrypted, this.extractedAIV.length, paddedPlaintext, 0, paddedPlaintext.length);
        } else {
            paddedPlaintext = decrypted = this.rfc3394UnwrapNoIvCheck(in, inOff, inLen);
        }
        byte[] extractedHighOrderAIV = new byte[4];
        byte[] mliBytes = new byte[4];
        System.arraycopy(this.extractedAIV, 0, extractedHighOrderAIV, 0, extractedHighOrderAIV.length);
        System.arraycopy(this.extractedAIV, extractedHighOrderAIV.length, mliBytes, 0, mliBytes.length);
        int mli = Pack.bigEndianToInt(mliBytes, 0);
        boolean isValid = true;
        if (!Arrays.constantTimeAreEqual(extractedHighOrderAIV, this.preIV)) {
            isValid = false;
        }
        if (mli <= (lowerBound = (upperBound = paddedPlaintext.length) - 8)) {
            isValid = false;
        }
        if (mli > upperBound) {
            isValid = false;
        }
        int expectedZeros = upperBound - mli;
        byte[] zeros = new byte[expectedZeros];
        byte[] pad = new byte[expectedZeros];
        System.arraycopy(paddedPlaintext, paddedPlaintext.length - expectedZeros, pad, 0, expectedZeros);
        if (!Arrays.constantTimeAreEqual(pad, zeros)) {
            isValid = false;
        }
        byte[] plaintext = new byte[mli];
        System.arraycopy(paddedPlaintext, 0, plaintext, 0, plaintext.length);
        if (!isValid) {
            throw new InvalidCipherTextException("checksum failed");
        }
        return plaintext;
    }

    private byte[] rfc3394UnwrapNoIvCheck(byte[] in, int inOff, int inLen) {
        byte[] iv = new byte[8];
        byte[] block = new byte[inLen - iv.length];
        byte[] a = new byte[iv.length];
        byte[] buf = new byte[8 + iv.length];
        System.arraycopy(in, inOff, a, 0, iv.length);
        System.arraycopy(in, inOff + iv.length, block, 0, inLen - iv.length);
        this.engine.init(false, this.param);
        int n = inLen / 8;
        --n;
        for (int j = 5; j >= 0; --j) {
            for (int i = n; i >= 1; --i) {
                System.arraycopy(a, 0, buf, 0, iv.length);
                System.arraycopy(block, 8 * (i - 1), buf, iv.length, 8);
                int t = n * j + i;
                int k = 1;
                while (t != 0) {
                    byte v = (byte)t;
                    int n2 = iv.length - k;
                    buf[n2] = (byte)(buf[n2] ^ v);
                    t >>>= 8;
                    ++k;
                }
                this.engine.processBlock(buf, 0, buf, 0);
                System.arraycopy(buf, 0, a, 0, 8);
                System.arraycopy(buf, 8, block, 8 * (i - 1), 8);
            }
        }
        this.extractedAIV = a;
        return block;
    }
}

