/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.client;

import cfca.sadk.timestamp.client.conf.TscAuthInfoConf;
import cfca.sadk.timestamp.exception.TSAErrorCode;
import cfca.sadk.timestamp.exception.TSAException;
import cfca.sadk.timestamp.exception.TSAVerifiedException;
import cfca.sadk.timestamp.exception.TSAVerifiedSubCode;
import cfca.sadk.x509.certificate.X509CRLFile;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.http.util.Args;

public final class BusinessTrustCerts {
    private static final int CRL_CACHE_FILE_SIZE = 5120000;
    private X509CRLFile x509CRL;
    private X509Cert trustCert;

    BusinessTrustCerts(TscAuthInfoConf authInfoConf) throws TSAException {
        Args.notNull((Object)authInfoConf, (String)"authInfoConf");
        this.setTrustCertPath(authInfoConf.getBusinessTrustCertPath());
        this.setTrustCRLPath(authInfoConf.getBusinessTrustCRLPath());
    }

    BusinessTrustCerts(String trustCertPath, String trustCRLPath) throws TSAException {
        this.setTrustCertPath(trustCertPath);
        this.setTrustCRLPath(trustCRLPath);
    }

    final boolean verifyCertSignature(X509Cert x509Cert) throws TSAVerifiedException {
        boolean verifiedResult;
        if (x509Cert != null && this.trustCert != null) {
            try {
                verifiedResult = x509Cert.verify(this.trustCert.getPublicKey());
            }
            catch (Exception e) {
                throw new TSAVerifiedException(TSAVerifiedSubCode.timestampSignedCertSignatureInvalid, "x509Cert signature verify failure: " + e.getMessage(), (Throwable)e);
            }
        } else {
            verifiedResult = true;
        }
        return verifiedResult;
    }

    final boolean verifyCertValidate(X509Cert x509Cert, boolean withTrustCertValidate) throws TSAVerifiedException {
        Date nowTime = new Date();
        boolean verifiedResult = false;
        if (x509Cert != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
            if (x509Cert.getNotBefore().after(nowTime)) {
                throw new TSAVerifiedException(TSAVerifiedSubCode.timestampSignedCertValidateInvalid, String.format("x509Cert validate notBefore invalid: {signerCert=%s, nowTime=%s}", dateFormat.format(x509Cert.getNotBefore()), dateFormat.format(nowTime)));
            }
            if (x509Cert.getNotAfter().before(nowTime)) {
                throw new TSAVerifiedException(TSAVerifiedSubCode.timestampSignedCertValidateInvalid, String.format("x509Cert validate notAfter invalid: {signerCert=%s, nowTime=%s}", dateFormat.format(x509Cert.getNotAfter()), dateFormat.format(nowTime)));
            }
            if (withTrustCertValidate && x509Cert != null && this.trustCert != null) {
                if (x509Cert.getNotBefore().before(this.trustCert.getNotBefore())) {
                    throw new TSAVerifiedException(TSAVerifiedSubCode.timestampSignedCertValidateInvalid, String.format("x509Cert validate notBefore invalid: {signerCert=%s, trustCert=%s}", dateFormat.format(x509Cert.getNotBefore()), dateFormat.format(this.trustCert.getNotBefore())));
                }
                if (x509Cert.getNotAfter().after(this.trustCert.getNotAfter())) {
                    throw new TSAVerifiedException(TSAVerifiedSubCode.timestampSignedCertValidateInvalid, String.format("x509Cert validate notAfter invalid: {signerCert=%s, trustCert=%s}", dateFormat.format(x509Cert.getNotAfter()), dateFormat.format(this.trustCert.getNotAfter())));
                }
                verifiedResult = true;
            } else {
                verifiedResult = true;
            }
        }
        return verifiedResult;
    }

    final boolean isRevoke(X509Cert x509Cert) throws TSAVerifiedException {
        boolean verifiedResult;
        if (x509Cert != null && this.x509CRL != null) {
            try {
                verifiedResult = this.x509CRL.isRevoke(x509Cert.getSerialNumber());
            }
            catch (Exception e) {
                throw new TSAVerifiedException(TSAVerifiedSubCode.timestampSignedCertRevokeStatusInvalid, "x509Cert check revoked failure: " + e.getMessage(), (Throwable)e);
            }
        } else {
            verifiedResult = false;
        }
        return verifiedResult;
    }

    public final void setTrustCert(X509Cert trustCert) {
        this.trustCert = trustCert;
    }

    public final void setTrustCertPath(String trustCertPath) throws TSAException {
        X509Cert trustCert = null;
        if (trustCertPath != null && trustCertPath.length() != 0) {
            File trustCertFile = new File(trustCertPath);
            if (trustCertFile.exists() && trustCertFile.isFile()) {
                try {
                    trustCert = new X509Cert(trustCertPath);
                }
                catch (Exception e) {
                    throw new TSAException(TSAErrorCode.businessTrustCertFileInvalid, "trustCertFile " + trustCertFile + " invalid: " + e.getMessage(), (Throwable)e);
                }
            } else {
                throw new TSAException(TSAErrorCode.businessTrustCertFileInvalid, "trustCertFile " + trustCertFile + " invalid!!!");
            }
        }
        this.trustCert = trustCert;
    }

    public final void setTrustCRL(X509CRLFile x509CRL) {
        this.x509CRL = x509CRL;
    }

    public final void setTrustCRLPath(String trustCRLPath) throws TSAException {
        X509CRLFile crlCert = null;
        if (trustCRLPath != null && trustCRLPath.length() != 0) {
            File trustCRLFile = new File(trustCRLPath);
            if (trustCRLFile.exists() && trustCRLFile.isFile()) {
                try {
                    boolean enableCacheCRL = trustCRLFile.length() < 5120000L;
                    crlCert = new X509CRLFile(trustCRLPath, enableCacheCRL);
                }
                catch (Exception e) {
                    throw new TSAException(TSAErrorCode.businessTrustCertFileInvalid, "trustCRLFile " + trustCRLFile + " invalid: " + e.getMessage(), (Throwable)e);
                }
                this.x509CRL = crlCert;
            } else {
                throw new TSAException(TSAErrorCode.businessTrustCertFileInvalid, "trustCRLFile " + trustCRLFile + " invalid!!!");
            }
        }
    }
}

