/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.client;

import cfca.sadk.algorithm.common.GMObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.crypto.Digest;
import cfca.sadk.org.bouncycastle.crypto.digests.SM3Digest;
import cfca.sadk.org.bouncycastle.operator.DigestCalculator;
import cfca.sadk.org.bouncycastle.operator.OperatorCreationException;
import cfca.sadk.timestamp.client.TSADigestProviderHelper;
import java.io.OutputStream;
import org.apache.http.util.Args;

final class TSADigestCalculator
implements DigestCalculator {
    final AlgorithmIdentifier digestAlgorithmIdentifier;
    final DigestOutputStream stream;

    TSADigestCalculator(AlgorithmIdentifier digestAlgorithmIdentifier) throws OperatorCreationException {
        DigestOutputStream stream;
        Args.notNull((Object)digestAlgorithmIdentifier, (String)"digestAlgorithmIdentifier");
        Object engine = GMObjectIdentifiers.sm3.equals((Object)digestAlgorithmIdentifier.getAlgorithm()) ? new SM3Digest() : TSADigestProviderHelper.lookup(digestAlgorithmIdentifier);
        this.stream = stream = new DigestOutputStream((Digest)engine);
        this.digestAlgorithmIdentifier = digestAlgorithmIdentifier;
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.digestAlgorithmIdentifier;
    }

    public OutputStream getOutputStream() {
        return this.stream;
    }

    public byte[] getDigest() {
        return this.stream.getDigest();
    }

    final class DigestOutputStream
    extends OutputStream {
        private Digest dig;

        DigestOutputStream(Digest dig) {
            this.dig = dig;
        }

        @Override
        public void write(byte[] bytes, int off, int len) {
            this.dig.update(bytes, off, len);
        }

        @Override
        public void write(byte[] bytes) {
            this.dig.update(bytes, 0, bytes.length);
        }

        @Override
        public void write(int b) {
            this.dig.update((byte)b);
        }

        byte[] getDigest() {
            byte[] d = new byte[this.dig.getDigestSize()];
            this.dig.doFinal(d, 0);
            return d;
        }
    }
}

