/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.client.conn;

import cfca.sadk.timestamp.client.conf.TscCommonConf;
import cfca.sadk.timestamp.client.conf.TscLayeredConf;
import cfca.sadk.timestamp.client.logging.TscLogging;
import cfca.sadk.timestamp.client.socket.TscPlainConnectionSocketFactory;
import cfca.sadk.timestamp.client.socket.TscSSLHelper;
import cfca.sadk.timestamp.client.utils.TscStrings;
import cfca.sadk.timestamp.exception.TSAErrorCode;
import cfca.sadk.timestamp.exception.TSAException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;

final class TimestampHttpClientBuilder {
    private TimestampHttpClientBuilder() {
    }

    static HttpClientBuilder build(final TscCommonConf tscCommonConf, TscLayeredConf tscLayeredConf, SSLContext sslContext) throws TSAException {
        Args.notNull((Object)tscCommonConf, (String)"tscCommonConf");
        Args.notNull((Object)tscLayeredConf, (String)"tscLayeredConf");
        RegistryBuilder registryBuilder = RegistryBuilder.create();
        long loggingWarnThresholdTime = tscCommonConf.getWarningThresholdTime();
        registryBuilder.register("http", (Object)TscPlainConnectionSocketFactory.getSocketFactory(loggingWarnThresholdTime));
        if (sslContext != null) {
            LayeredConnectionSocketFactory tscLayeredConnectionSocketFactory = TscSSLHelper.newLayeredConnectionSocketFactory(sslContext, tscLayeredConf, loggingWarnThresholdTime);
            registryBuilder.register("https", (Object)tscLayeredConnectionSocketFactory);
        }
        Registry registry = registryBuilder.build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(registry);
        HttpClientBuilder httpBuilder = HttpClientBuilder.create();
        httpBuilder.addInterceptorLast(new HttpResponseInterceptor(){

            public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
                String tscUUID = (String)context.getAttribute("CFCA-TSC-UUID");
                String url = tscCommonConf.getHttpURL();
                HttpClientContext localContext = HttpClientContext.adapt((HttpContext)context);
                int localPort = -1;
                if (localContext != null) {
                    HttpInetConnection conn = (HttpInetConnection)localContext.getConnection(HttpInetConnection.class);
                    if (conn != null) {
                        localPort = conn.getLocalPort();
                    } else {
                        TscLogging.ERROR_LOGGER.error("CFCA-TSC-UUID={} connect to {} findLocalPort failed: HttpInetConnection=null", (Object)tscUUID, (Object)url);
                    }
                } else {
                    TscLogging.ERROR_LOGGER.error("CFCA-TSC-UUID={} connect to {} findLocalPort failed: HttpClientContext=null", (Object)tscUUID, (Object)url);
                }
                if (tscCommonConf.isHttpProxyEnable()) {
                    TscLogging.SYSTEM_LOGGER.info("CFCA-TSC-UUID={} connect to {} / proxy={} withLocalPort={}", new Object[]{tscUUID, url, tscCommonConf.getHttpProxyURL(), localPort});
                } else {
                    TscLogging.SYSTEM_LOGGER.info("CFCA-TSC-UUID={} connect to {} withLocalPort={}", new Object[]{tscUUID, url, localPort});
                }
            }
        });
        if (tscCommonConf.isHttpProxyEnable()) {
            if (TscStrings.isEmpty(tscCommonConf.getHttpProxyURL())) {
                connManager.close();
                String message = "invalid proxy=" + tscCommonConf.getHttpProxyURL();
                TscLogging.ERROR_LOGGER.error(message);
                throw new TSAException(TSAErrorCode.serverUrlInvalidMalformedURL, message);
            }
            TscLogging.SYSTEM_LOGGER.info("connect to proxy {} ", (Object)tscCommonConf.getHttpProxyURL());
            try {
                String[] userpass;
                URL proxyURL = new URL(tscCommonConf.getHttpProxyURL());
                HttpHost proxyPost = new HttpHost(proxyURL.getHost(), proxyURL.getPort(), proxyURL.getProtocol());
                DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxyPost);
                httpBuilder.setRoutePlanner((HttpRoutePlanner)routePlanner);
                String userInfo = proxyURL.getUserInfo();
                if (!TscStrings.isEmpty(userInfo) && (userpass = userInfo.split(":")).length == 2) {
                    String proxyUserName = userpass[0];
                    String proxyPassword = userpass[1];
                    TscLogging.SYSTEM_LOGGER.info("connect to proxy with credentials {}:{} ", (Object)proxyUserName, (Object)proxyPassword);
                    UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxyUserName, proxyPassword);
                    AuthScope authScope = new AuthScope(proxyURL.getHost(), proxyURL.getPort());
                    BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                    credsProvider.setCredentials(authScope, (Credentials)credentials);
                    httpBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
                }
            }
            catch (MalformedURLException e) {
                connManager.close();
                String message = "invalid proxy=" + tscCommonConf.getHttpProxyURL();
                TscLogging.ERROR_LOGGER.error(message, (Throwable)e);
                throw new TSAException(TSAErrorCode.serverUrlInvalidMalformedURL, message, (Throwable)e);
            }
        }
        int socketTimeout = tscCommonConf.getHttpSocketTimeout();
        int connectTimeout = tscCommonConf.getHttpConnectTimeout();
        int requestTimeout = tscCommonConf.getHttpRequestTimeout();
        RequestConfig.Builder builder = RequestConfig.custom().setSocketTimeout(socketTimeout);
        builder.setConnectTimeout(connectTimeout);
        builder.setConnectionRequestTimeout(requestTimeout);
        RequestConfig config = builder.build();
        httpBuilder.setDefaultRequestConfig(config);
        httpBuilder.setConnectionManager((HttpClientConnectionManager)connManager);
        return httpBuilder;
    }
}

