/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.itextpdf.tool.xml.css.apply;

import cfca.com.itextpdf.tool.xml.Tag;
import cfca.com.itextpdf.tool.xml.css.CssUtils;
import cfca.com.itextpdf.tool.xml.css.FontSizeTranslator;
import cfca.com.itextpdf.tool.xml.css.apply.MarginMemory;
import cfca.com.itextpdf.tool.xml.html.pdfelement.NoNewLineParagraph;
import java.util.Map;

public class NoNewLineParagraphCssApplier {
    private final CssUtils utils = CssUtils.getInstance();

    public NoNewLineParagraph apply(NoNewLineParagraph p, Tag t, MarginMemory configuration) {
        float fontSize = FontSizeTranslator.getInstance().getFontSize(t);
        float lmb = 0.0f;
        boolean hasLMB = false;
        Map<String, String> css = t.getCSS();
        for (Map.Entry<String, String> entry : css.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if ("margin-top".equalsIgnoreCase(key)) {
                p.setSpacingBefore(p.getSpacingBefore() + this.utils.calculateMarginTop(value, fontSize, configuration));
                continue;
            }
            if ("padding-top".equalsIgnoreCase(key)) {
                p.setSpacingBefore(p.getSpacingBefore() + this.utils.parseValueToPt(value, fontSize));
                continue;
            }
            if ("margin-bottom".equalsIgnoreCase(key)) {
                float after = this.utils.parseValueToPt(value, fontSize);
                p.setSpacingAfter(p.getSpacingAfter() + after);
                lmb = after;
                hasLMB = true;
                continue;
            }
            if ("padding-bottom".equalsIgnoreCase(key)) {
                p.setSpacingAfter(p.getSpacingAfter() + this.utils.parseValueToPt(value, fontSize));
                continue;
            }
            if ("margin-left".equalsIgnoreCase(key)) {
                p.setIndentationLeft(p.getIndentationLeft() + this.utils.parseValueToPt(value, fontSize));
                continue;
            }
            if ("margin-right".equalsIgnoreCase(key)) {
                p.setIndentationRight(p.getIndentationRight() + this.utils.parseValueToPt(value, fontSize));
                continue;
            }
            if ("padding-left".equalsIgnoreCase(key)) {
                p.setIndentationLeft(p.getIndentationLeft() + this.utils.parseValueToPt(value, fontSize));
                continue;
            }
            if ("padding-right".equalsIgnoreCase(key)) {
                p.setIndentationRight(p.getIndentationRight() + this.utils.parseValueToPt(value, fontSize));
                continue;
            }
            if ("text-align".equalsIgnoreCase(key)) {
                if ("right".equalsIgnoreCase(value)) {
                    p.setAlignment(2);
                    continue;
                }
                if ("center".equalsIgnoreCase(value)) {
                    p.setAlignment(1);
                    continue;
                }
                if ("left".equalsIgnoreCase(value)) {
                    p.setAlignment(0);
                    continue;
                }
                if (!"justify".equalsIgnoreCase(value)) continue;
                p.setAlignment(3);
                continue;
            }
            if (!"text-indent".equalsIgnoreCase(key)) continue;
            p.setFirstLineIndent(this.utils.parseValueToPt(value, fontSize));
        }
        if (null != t.getParent()) {
            String parent = t.getParent().getName();
            if (css.get("margin-top") == null && configuration.getRootTags().contains(parent)) {
                p.setSpacingBefore(p.getSpacingBefore() + this.utils.calculateMarginTop(fontSize + "pt", 0.0f, configuration));
            }
            if (css.get("margin-bottom") == null && configuration.getRootTags().contains(parent)) {
                p.setSpacingAfter(p.getSpacingAfter() + fontSize);
                css.put("margin-bottom", fontSize + "pt");
                lmb = fontSize;
                hasLMB = true;
            }
            if (p.getAlignment() == -1) {
                p.setAlignment(0);
            }
        }
        if (hasLMB) {
            configuration.setLastMarginBottom(Float.valueOf(lmb));
        }
        return p;
    }
}

