/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.client.tx.transaction;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.org.slf4j.MDC;
import cfca.paperless.client.connector.HttpConnector;
import cfca.paperless.client.util.CommonUtil;
import cfca.paperless.client.util.JsonUtil;
import cfca.paperless.dto.RequestDto;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;

public abstract class AbstractTransaction {
    public static final Logger logger = LoggerFactory.getLogger(AbstractTransaction.class);

    public String handleRequest(HttpConnector httpConnector, RequestDto requestDto, List<byte[]> inputFileDataList, List<byte[]> outputFileDataList) throws Exception {
        String[] fileDataLengthStrGroup;
        logger.info("AbstractTransaction.handleRequest start.");
        String requestJSONString = JsonUtil.obj2Json(requestDto);
        logger.debug("requestJSONString=[{}]", (Object)requestJSONString);
        byte[] requestJSONData = requestJSONString.getBytes("UTF-8");
        String requestJSONLengthString = String.valueOf(requestJSONData == null ? 0 : requestJSONData.length);
        logger.info("requestJSONLengthString={}", (Object)requestJSONLengthString);
        byte[] requestFileData = new byte[]{};
        String requestFileDataLengthString = "";
        if (CommonUtil.isNotEmpty(inputFileDataList)) {
            int listSize = inputFileDataList.size();
            logger.info("inputFileDataList.size={}", (Object)listSize);
            for (int i = 0; i < listSize; ++i) {
                byte[] fileData = inputFileDataList.get(i);
                requestFileData = ArrayUtils.addAll((byte[])requestFileData, (byte[])fileData);
                long requestFileDataLength = fileData == null ? 0L : (long)fileData.length;
                logger.info("inputFileDataList index={} requestFileDataLength={}", (Object)i, (Object)requestFileDataLength);
                requestFileDataLengthString = requestFileDataLengthString + requestFileDataLength;
                if (i >= listSize - 1) continue;
                requestFileDataLengthString = requestFileDataLengthString + "||";
            }
        }
        logger.info("requestFileData.all.length={}", (Object)requestFileData.length);
        logger.info("requestFileDataLengthString={}", (Object)requestFileDataLengthString);
        LinkedHashMap<String, String> requestHttpHeadersMap = new LinkedHashMap<String, String>();
        requestHttpHeadersMap.put("jsonLength", requestJSONLengthString);
        requestHttpHeadersMap.put("fileDataLength", requestFileDataLengthString);
        requestHttpHeadersMap.put("TraceId", MDC.get((String)"ClientTraceId"));
        LinkedHashMap<String, String> responseHttpHeadersMap = new LinkedHashMap<String, String>();
        responseHttpHeadersMap.put("jsonLength", null);
        responseHttpHeadersMap.put("fileDataLength", null);
        byte[] requestHttpBodyData = ArrayUtils.addAll((byte[])requestJSONData, (byte[])requestFileData);
        logger.info("requestHttpBodyData.length={}", (Object)requestHttpBodyData.length);
        long start = System.currentTimeMillis();
        byte[] responseHttpBodyData = httpConnector.process(requestHttpHeadersMap, requestHttpBodyData, responseHttpHeadersMap);
        long end = System.currentTimeMillis();
        logger.info("httpConnector.process finish. time-taken={}ms. responseHttpBodyData.length={}", (Object)(end - start), (Object)responseHttpBodyData.length);
        String responseJSONLengthString = (String)responseHttpHeadersMap.get("jsonLength");
        logger.info("responseJSONLengthString={}", (Object)responseJSONLengthString);
        String responseFileDataLenthString = (String)responseHttpHeadersMap.get("fileDataLength");
        logger.info("responseFileDataLenthString={}", (Object)responseFileDataLenthString);
        byte[] responseJSONData = new byte[Integer.parseInt(responseJSONLengthString)];
        System.arraycopy(responseHttpBodyData, 0, responseJSONData, 0, Integer.parseInt(responseJSONLengthString));
        String responseJSONString = new String(responseJSONData, "UTF-8");
        logger.debug("responseJSONString=[{}]", (Object)responseJSONString);
        if (CommonUtil.isNotEmpty(responseFileDataLenthString) && (fileDataLengthStrGroup = responseFileDataLenthString.split("\\|\\|")) != null && fileDataLengthStrGroup.length > 0) {
            int position = Integer.parseInt(responseJSONLengthString);
            int listSize = fileDataLengthStrGroup.length;
            logger.info("outputFileDataList.size={}", (Object)listSize);
            for (int i = 0; i < listSize; ++i) {
                String fileDataLengthStr = fileDataLengthStrGroup[i];
                int fileDataLength = Integer.parseInt(fileDataLengthStr);
                byte[] bodyBuffer = new byte[fileDataLength];
                System.arraycopy(responseHttpBodyData, position, bodyBuffer, 0, fileDataLength);
                logger.info("outputFileDataList index={} responseFileDataLength={}", (Object)i, (Object)fileDataLength);
                outputFileDataList.add(bodyBuffer);
                position += fileDataLength;
            }
        }
        return responseJSONString;
    }
}

