/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.tls.sun.security.ssl.Alerts;
import cfca.sadk.tls.sun.security.ssl.ProtocolVersion;
import cfca.sadk.tls.sun.security.ssl.message.HandshakeMessage;
import java.security.cert.X509Certificate;

public class Debugger {
    public static final Logger handshaker = LoggerFactory.getLogger((String)"ssl.handshaker");
    public static final Logger record = LoggerFactory.getLogger((String)"ssl.record");
    public static final Logger packet = LoggerFactory.getLogger((String)"ssl.packet");
    public static final Logger check = LoggerFactory.getLogger((String)"ssl.check");
    public static final Logger sslctx = LoggerFactory.getLogger((String)"ssl.sslctx");
    public static final Logger text = LoggerFactory.getLogger((String)"ssl.text");
    public static final Logger env = LoggerFactory.getLogger((String)"ssl.env");

    private Debugger() {
    }

    public static final void debug(HandshakeMessage message) {
        if (message != null && handshaker.isDebugEnabled()) {
            handshaker.debug("{}", (Object)message);
        }
    }

    public static final void debug(String operation, ProtocolVersion version, byte level, byte description) {
        if (record.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append(operation).append(' ').append(version).append(" ALERT:  ");
            if (level == 2) {
                builder.append("fatal, ");
            } else if (level == 1) {
                builder.append("warning, ");
            } else {
                builder.append("<level " + (0xFF & level) + ">, ");
            }
            builder.append("\ndescription = " + Alerts.alertDescription(description));
            record.debug(builder.toString());
        }
    }

    public static final String dump(X509Certificate cert) {
        String message = null;
        try {
            message = cert == null ? "none" : cert.toString();
        }
        catch (Exception e) {
            message = "FailureX509Cert";
        }
        return message;
    }

    public static final String dump(X509Certificate[] certs) {
        String message = null;
        try {
            if (certs == null || certs.length == 0) {
                message = "none";
            } else {
                StringBuffer buffer = new StringBuffer();
                for (int i = 0; i < certs.length; ++i) {
                    buffer.append(certs[i]);
                }
                message = buffer.toString();
            }
        }
        catch (Exception e) {
            message = "FailureX509Cert";
        }
        return message;
    }
}

