/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.google.typography.font.sfntly.table.opentype;

import cfca.sadk.com.google.typography.font.sfntly.data.ReadableFontData;
import cfca.sadk.com.google.typography.font.sfntly.data.WritableFontData;
import cfca.sadk.com.google.typography.font.sfntly.table.FontDataTable;
import cfca.sadk.com.google.typography.font.sfntly.table.SubTable;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.component.VisibleSubTable;

abstract class OTSubTable
extends SubTable {
    final boolean dataIsCanonical;

    protected OTSubTable(ReadableFontData data, boolean dataIsCanonical) {
        super(data);
        this.dataIsCanonical = dataIsCanonical;
    }

    protected abstract Builder<? extends OTSubTable> builder();

    static abstract class Builder<T extends OTSubTable>
    extends VisibleSubTable.Builder<T> {
        private final boolean dataIsCanonical;
        private int serializedLength;

        protected Builder(ReadableFontData data, boolean dataIsCanonical) {
            super(data);
            boolean bl = this.dataIsCanonical = data == null ? false : dataIsCanonical;
            if (this.dataIsCanonical) {
                this.serializedLength = data.length();
            } else if (data == null || data.length() == 0) {
                this.serializedLength = 0;
            } else {
                this.serializedLength = -1;
                this.setModelChanged();
            }
        }

        protected Builder(T table) {
            this(((FontDataTable)table).readFontData(), ((OTSubTable)table).dataIsCanonical);
        }

        protected abstract boolean unedited();

        protected abstract void readModel(ReadableFontData var1, boolean var2);

        protected abstract int computeSerializedLength();

        protected abstract void writeModel(WritableFontData var1);

        protected void prepareToEdit() {
            if (this.unedited()) {
                this.readModel(this.internalReadData(), this.dataIsCanonical);
                this.serializedLength = -1;
                this.setModelChanged();
            }
        }

        @Override
        protected final boolean subReadyToSerialize() {
            return this.subDataSizeToSerialize() > 0;
        }

        @Override
        public final int subDataSizeToSerialize() {
            if (this.serializedLength == -1) {
                if (this.unedited()) {
                    this.prepareToEdit();
                }
                this.serializedLength = this.computeSerializedLength();
            }
            return this.serializedLength;
        }

        @Override
        public final int subSerialize(WritableFontData newData) {
            if (this.unedited()) {
                this.internalReadData().copyTo(newData);
            } else {
                this.writeModel(newData);
            }
            int length = this.serializedLength;
            this.serializedLength = -1;
            return length;
        }
    }
}

