/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.base.ofd;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.ofd.base.asn1.SES_ESPictureInfo;
import cfca.sadk.ofd.base.asn1.SES_Signature;
import cfca.sadk.ofd.base.asn1.TBS_Sign;
import cfca.sadk.ofd.base.common.Dom4jUtil;
import cfca.sadk.ofd.base.common.StringUtil;
import cfca.sadk.ofd.base.common.ZipUtil;
import cfca.sadk.ofd.base.convert.ConvertInterface;
import cfca.sadk.ofd.base.ofd.Appearance;
import cfca.sadk.ofd.base.ofd.ImageLocation;
import cfca.sadk.ofd.base.ofd.OFDContentParser;
import cfca.sadk.ofd.base.ofd.PathLocation;
import cfca.sadk.ofd.base.ofd.Rectangle;
import cfca.sadk.ofd.base.ofd.SignLocation;
import cfca.sadk.ofd.base.ofd.TextLocation;
import cfca.sadk.ofd.base.seal.SealXMLUtil;
import java.awt.FontFormatException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;

public class OFDParser {
    private static Logger businessLog = LoggerFactory.getLogger(OFDParser.class);
    private OFDContentParser fontParser = new OFDContentParser();
    private ConvertInterface converter = null;
    private HashMap<String, byte[]> oneFileFontCacheMap = new HashMap();
    private HashMap<String, String> systemFontMap = new HashMap();
    private Map<String, String> templateMap = null;
    private List<TextLocation> testLocationList = new ArrayList<TextLocation>();
    private List<ImageLocation> imageList = new ArrayList<ImageLocation>();
    private List<PathLocation> pathList = new ArrayList<PathLocation>();
    private List<SignLocation> signLocationList = new ArrayList<SignLocation>();
    private HashMap<String, byte[]> resourceMap = new HashMap();

    public void parseFile(byte[] ofdDatas, ConvertInterface converter) throws Exception {
        String baseDir;
        if (null == ofdDatas) {
            throw new IllegalArgumentException("ofdDatas is null");
        }
        if (null == converter) {
            throw new IllegalArgumentException("converter is null");
        }
        this.converter = converter;
        Map<String, byte[]> filesMap = ZipUtil.uncompress(new ByteArrayInputStream(ofdDatas));
        Element root = SealXMLUtil.getDocument(filesMap, baseDir = SealXMLUtil.getBaseDir(filesMap));
        Element commonData = root.element("CommonData");
        if (null != commonData) {
            String res;
            Element docRes;
            Element publicRes = commonData.element("PublicRes");
            if (null != publicRes) {
                String res2 = publicRes.getStringValue();
                Element resDocument = SealXMLUtil.getCommonDocument(filesMap, baseDir + res2);
                this.parseFontsInfo(filesMap, baseDir, resDocument);
                converter.setResFont(this.oneFileFontCacheMap);
                converter.setSystemFont(this.systemFontMap);
                this.parsePublicRes(filesMap, baseDir + "Res/", resDocument);
            }
            if (null != (docRes = commonData.element("DocumentRes")) && !(res = docRes.getStringValue()).isEmpty()) {
                Element resDocument = SealXMLUtil.getCommonDocument(filesMap, baseDir + res);
                this.parseFontsInfo(filesMap, baseDir, resDocument);
                converter.setResFont(this.oneFileFontCacheMap);
                converter.setSystemFont(this.systemFontMap);
                this.parsePublicRes(filesMap, baseDir + "Res/", resDocument);
            }
        }
        this.templateMap = SealXMLUtil.getTemplates(root, baseDir);
        Element pages = root.element("Pages");
        this.parsePages(filesMap, pages, baseDir, root);
        Element annotations = root.element("Annotations");
        this.parseAnnotations(annotations);
        Element ofdRoot = SealXMLUtil.getOFDRoot(filesMap);
        Element signatures = ofdRoot.element("Signatures");
        this.parseSignatures(filesMap, baseDir, root, signatures);
        converter.convert();
    }

    private void parsePages(Map<String, byte[]> filesMap, Element pages, String baseDir, Element root) throws Exception {
        List pageList = pages.elements("Page");
        for (int i = 0; i < pageList.size(); ++i) {
            Element pageBox;
            byte[] onePageData;
            int pageNum = i + 1;
            Element onePage = (Element)pageList.get(i);
            String id = onePage.attributeValue("ID");
            String baseLoc = onePage.attributeValue("BaseLoc");
            String pageFilePath = baseLoc.contains(baseDir) ? baseLoc : baseDir + baseLoc;
            if ((pageFilePath = pageFilePath.replace("../", "").replace("./", "")).startsWith("/")) {
                pageFilePath = pageFilePath.substring(1);
            }
            if (null == (onePageData = filesMap.get(pageFilePath))) {
                throw new Exception("onePageData is null,path is " + baseDir + baseLoc);
            }
            Document document = Dom4jUtil.parseFile(new ByteArrayInputStream(onePageData));
            Element body = document.getRootElement();
            Element area = body.element("Area");
            if (null == area) {
                Element commonData = root.element("CommonData");
                area = commonData.element("PageArea");
            }
            if (null == (pageBox = area.element("PhysicalBox"))) continue;
            Rectangle pageSize = new Rectangle(pageBox.getStringValue());
            Element content = body.element("Content");
            this.parseOnePage(filesMap, pageNum, pageSize, content);
            List templateList = body.elements("Template");
            this.parseTemplate(templateList, filesMap, pageNum, pageSize, baseDir);
        }
    }

    private void parseTemplate(List templateList, Map<String, byte[]> filesMap, int pageNo, Rectangle pageSize, String baseDir) throws Exception {
        if (null != templateList) {
            for (int m = 0; m < templateList.size(); ++m) {
                Element template = (Element)templateList.get(m);
                if (null == template) continue;
                String templateid = template.attributeValue("TemplateID");
                String templatePath = baseDir + this.templateMap.get(templateid);
                byte[] templateData = filesMap.get(templatePath);
                if (templateData != null) {
                    Document documentTmpl = Dom4jUtil.parseFile(new ByteArrayInputStream(templateData));
                    Element bodyTmpl = documentTmpl.getRootElement();
                    Element contentbodyTmpl = bodyTmpl.element("Content");
                    this.parseOnePage(filesMap, pageNo, pageSize, contentbodyTmpl);
                    continue;
                }
                businessLog.warn(templatePath + " is not found!");
            }
        }
    }

    private void parseOnePage(Map<String, byte[]> filesMap, int pageNo, Rectangle pageSize, Element content) throws Exception {
        Element layer = content.element("Layer");
        if (layer != null) {
            List list = layer.selectNodes("//ofd:TextObject");
            this.parseTextObject(list, filesMap, pageNo, pageSize);
            List pathObjectlist = layer.selectNodes("//ofd:PathObject");
            this.parsePathObject(pathObjectlist, filesMap, pageNo, pageSize);
            List imageObjectlist = layer.selectNodes("//ofd:ImageObject");
            this.parseImageObject(imageObjectlist, filesMap, pageNo, pageSize);
        }
    }

    private void parseImageObject(List list, Map<String, byte[]> filesMap, int pageNo, Rectangle pageSize) throws Exception {
        if (list != null && !list.isEmpty()) {
            long parseStart = System.currentTimeMillis();
            for (int i = 0; i < list.size(); ++i) {
                Element oneImage = (Element)list.get(i);
                String id = oneImage.attributeValue("ID");
                String boundary = oneImage.attributeValue("Boundary");
                String ctm = oneImage.attributeValue("CTM");
                String resourceID = oneImage.attributeValue("ResourceID");
                String alpha = oneImage.attributeValue("Alpha");
                byte[] imageData = this.resourceMap.get(resourceID);
                ImageLocation image = new ImageLocation(id, boundary, ctm, alpha, imageData);
                this.imageList.add(image);
            }
            this.converter.processImage(this.imageList, pageNo, pageSize);
            this.imageList.clear();
            long parseEnd = System.currentTimeMillis();
            businessLog.info("parseImageObject of pageNo=" + pageNo + " costTime=" + (parseEnd - parseStart) + "ms");
        }
    }

    private void parsePathObject(List list, Map<String, byte[]> filesMap, int pageNo, Rectangle pageSize) throws Exception {
        if (list != null && !list.isEmpty()) {
            long parseStart = System.currentTimeMillis();
            for (int i = 0; i < list.size(); ++i) {
                Element onePathObject = (Element)list.get(i);
                String id = onePathObject.attributeValue("ID");
                String boundary = onePathObject.attributeValue("Boundary");
                String ctm = onePathObject.attributeValue("CTM");
                String miterLimit = onePathObject.attributeValue("MiterLimit");
                String stroke = onePathObject.attributeValue("Stroke");
                String fill = onePathObject.attributeValue("Fill");
                String rule = onePathObject.attributeValue("Rule");
                Element fillColor = onePathObject.element("FillColor");
                String fillrgb = null;
                String fillAlpha = null;
                if (fillColor != null) {
                    fillrgb = fillColor.attributeValue("Value");
                    fillAlpha = fillColor.attributeValue("Alpha");
                }
                Element strokeColor = onePathObject.element("StrokeColor");
                String strokeColorValue = null;
                if (strokeColor != null) {
                    strokeColorValue = strokeColor.attributeValue("Value");
                }
                String lineWidth = onePathObject.attributeValue("LineWidth");
                Element abbreviatedData = onePathObject.element("AbbreviatedData");
                String abbreviatedValue = abbreviatedData.getStringValue();
                PathLocation pathLocation = new PathLocation(id, boundary, ctm, lineWidth, miterLimit, stroke, fill, rule, fillrgb, fillAlpha, strokeColorValue, abbreviatedValue);
                this.pathList.add(pathLocation);
            }
            this.converter.processPath(this.pathList, pageNo, pageSize);
            this.pathList.clear();
            long parseEnd = System.currentTimeMillis();
            businessLog.info("parsePathObject of pageNo=" + pageNo + " costTime=" + (parseEnd - parseStart) + "ms");
        }
    }

    private void parseTextObject(List list, Map<String, byte[]> filesMap, int pageNo, Rectangle pageSize) throws Exception {
        if (null != list) {
            long parseStart = System.currentTimeMillis();
            for (int i = 0; i < list.size(); ++i) {
                String newText;
                Element ontTextObj = (Element)list.get(i);
                String boundary = ontTextObj.attributeValue("Boundary");
                String ctm = ontTextObj.attributeValue("CTM");
                String fontSize = ontTextObj.attributeValue("Size");
                String fontID = ontTextObj.attributeValue("Font");
                String fontWeight = ontTextObj.attributeValue("Weight");
                Element cgTransform = ontTextObj.element("CGTransform");
                String glyphs = null;
                if (cgTransform != null) {
                    glyphs = cgTransform.element("Glyphs").getStringValue();
                }
                Element fillColor = ontTextObj.element("FillColor");
                String fillrgb = null;
                if (fillColor != null) {
                    fillrgb = fillColor.attributeValue("Value");
                }
                Element strokeColor = ontTextObj.element("StrokeColor");
                String strokeColorValue = null;
                if (strokeColor != null) {
                    strokeColorValue = strokeColor.attributeValue("Value");
                }
                List textCodeList = ontTextObj.elements("TextCode");
                StringBuffer oneTextObjText = new StringBuffer();
                float textObjX = 0.0f;
                float textObjY = 0.0f;
                float textObjLastX = 0.0f;
                String deltaX = null;
                String deltaY = null;
                StringBuffer textObjDeltaX = new StringBuffer();
                for (int m = 0; m < textCodeList.size(); ++m) {
                    Element textCode = (Element)textCodeList.get(m);
                    String text = textCode.getText();
                    oneTextObjText.append(text);
                    float x = Float.valueOf(textCode.attributeValue("X")).floatValue();
                    float y = Float.valueOf(textCode.attributeValue("Y")).floatValue();
                    if (m == 0) {
                        textObjX = x;
                        textObjY = y;
                        deltaX = textCode.attributeValue("DeltaX");
                        if (deltaX == null) {
                            deltaX = "0";
                        }
                        if ((deltaY = textCode.attributeValue("DeltaY")) == null) {
                            deltaY = "0";
                        }
                    } else if (m < textCodeList.size() - 1) {
                        textObjDeltaX.append(String.valueOf(x - textObjLastX) + " ");
                    } else {
                        textObjDeltaX.append(String.valueOf(x - textObjLastX));
                    }
                    textObjLastX = x;
                }
                if (textCodeList.size() > 1) {
                    deltaX = textObjDeltaX.toString();
                }
                if (StringUtil.isNotEmpty(newText = oneTextObjText.toString()) && (!StringUtil.isContainValidChar(newText) || newText.contains("\u00a4"))) {
                    newText = this.fontParser.parseFontInfo(filesMap, fontID, glyphs);
                }
                this.testLocationList.add(new TextLocation(pageNo, boundary, ctm, newText, textObjX, textObjY, deltaX, deltaY, Float.valueOf(fontSize).floatValue(), fontID, null, glyphs, "", strokeColorValue, fillrgb, fontWeight));
            }
            this.converter.processText(this.testLocationList, pageNo, pageSize);
            this.testLocationList.clear();
            list.clear();
            long parseEnd = System.currentTimeMillis();
            businessLog.info("parseTextObject of pageNo=" + pageNo + " costTime=" + (parseEnd - parseStart) + "ms");
        }
    }

    private void parseAnnotations(Element annotations) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseSignatures(Map<String, byte[]> filesMap, String baseDir, Element rootDoc, Element signatures) throws Exception {
        if (null != signatures) {
            long parseStart = System.currentTimeMillis();
            try {
                String filePath = signatures.getStringValue();
                Element sigsDocument = SealXMLUtil.getCommonDocument(filesMap, filePath);
                if (null != sigsDocument) {
                    Map<String, String> pageIdMap = SealXMLUtil.getPageIds(rootDoc, baseDir);
                    List signList = sigsDocument.elements("Signature");
                    if (null != signList) {
                        for (int i = 0; i < signList.size(); ++i) {
                            String signFilePath;
                            Element sigDocument;
                            Element oneSign = (Element)signList.get(i);
                            String type = oneSign.attributeValue("Type");
                            String baseLoc = oneSign.attributeValue("BaseLoc");
                            if (!"Seal".equals(type) || null == (sigDocument = SealXMLUtil.getCommonDocument(filesMap, signFilePath = baseDir + baseLoc))) continue;
                            Element signedInfo = sigDocument.element("SignedInfo");
                            List stampAnnot = signedInfo.elements("StampAnnot");
                            Element signedValue = sigDocument.element("SignedValue");
                            String signedValueName = signedValue.getStringValue();
                            int dirIndex = signFilePath.lastIndexOf("/");
                            String signedValuePath = signFilePath.substring(0, dirIndex) + "/" + signedValueName;
                            byte[] sealSignedData = filesMap.get(signedValuePath);
                            SES_Signature sesSign = SES_Signature.getInstance(sealSignedData);
                            TBS_Sign toSign = sesSign.getToSign();
                            SES_ESPictureInfo picture = toSign.getEseal().getEsealInfo().getPicture();
                            int height = picture.getHeight().getValue().intValue();
                            int width = picture.getWidth().getValue().intValue();
                            byte[] imageData = picture.getData().getOctets();
                            SignLocation signLocation = new SignLocation(height, width, imageData);
                            for (int j = 0; j < stampAnnot.size(); ++j) {
                                Element stamp = (Element)stampAnnot.get(j);
                                String boundary = stamp.attributeValue("Boundary");
                                String clip = stamp.attributeValue("Clip");
                                String pageRef = stamp.attributeValue("PageRef");
                                String pageNo = pageIdMap.get(pageRef);
                                String alpha = stamp.attributeValue("Alpha");
                                Appearance appearance = new Appearance(boundary, clip, pageNo, alpha);
                                signLocation.addAppearance(appearance);
                            }
                            this.signLocationList.add(signLocation);
                        }
                    }
                }
                this.converter.processSignLocation(this.signLocationList);
            }
            catch (Exception e) {
                businessLog.error("parseSignatures failed", (Throwable)e);
            }
            finally {
                this.signLocationList.clear();
                long parseEnd = System.currentTimeMillis();
                businessLog.info("parseSignatures costTime=" + (parseEnd - parseStart) + "ms");
            }
        }
    }

    private void parsePublicRes(Map<String, byte[]> filesMap, String baseDir, Element publicRes) {
        List multiMediaList = publicRes.selectNodes("//ofd:MultiMedia");
        if (null != multiMediaList) {
            for (int i = 0; i < multiMediaList.size(); ++i) {
                Element oneMedia = (Element)multiMediaList.get(i);
                String id = oneMedia.attributeValue("ID");
                Element mediaFile = oneMedia.element("MediaFile");
                if (null == mediaFile) continue;
                String fileName = mediaFile.getStringValue();
                byte[] fileData = filesMap.get(baseDir + fileName);
                this.resourceMap.put(id, fileData);
            }
        }
    }

    private void parseFontsInfo(Map<String, byte[]> filesMap, String baseDir, Element document) throws IOException, FontFormatException {
        List fontList;
        Element fonts = document.element("Fonts");
        if (fonts != null && (fontList = fonts.elements("Font")) != null) {
            for (int i = 0; i < fontList.size(); ++i) {
                Element oneFont = (Element)fontList.get(i);
                String fontID = oneFont.attributeValue("ID");
                String fontName = oneFont.attributeValue("FontName");
                String familyName = oneFont.attributeValue("FamilyName");
                Element fontFile = oneFont.element("FontFile");
                String fontPath = null;
                if (fontFile != null) {
                    fontPath = fontFile.getStringValue();
                }
                this.parseFontInfo(filesMap, baseDir, fontID, fontName, familyName, fontPath);
            }
        }
    }

    private void parseFontInfo(Map<String, byte[]> filesMap, String baseDir, String fontID, String fontName, String fontFamilyName, String fontPath) throws IOException, FontFormatException {
        if (null != fontPath && fontPath.endsWith("ttf")) {
            byte[] fontData = filesMap.get(baseDir + "Res/" + fontPath);
            this.oneFileFontCacheMap.put(fontID, fontData);
        } else {
            this.systemFontMap.put(fontID, fontName);
        }
    }

    public void clear() {
        this.oneFileFontCacheMap.clear();
        this.systemFontMap.clear();
        this.oneFileFontCacheMap = null;
        this.systemFontMap = null;
        this.fontParser.destroy();
    }
}

