/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.listener;

import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.EventType;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.data.IEventData;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.data.TextRenderInfo;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.listener.CharacterRenderInfo;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.listener.DefaultPdfTextLocation;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.listener.ILocationExtractionStrategy;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.listener.IPdfTextLocation;
import cfca.sadk.seal.base.util.PDFUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexBasedLocationExtractionStrategy
implements ILocationExtractionStrategy {
    private Pattern pattern;
    private List<CharacterRenderInfo> parseResult = new ArrayList<CharacterRenderInfo>();

    public RegexBasedLocationExtractionStrategy(String regex) {
        this.pattern = Pattern.compile(PDFUtil.escapeExprSpecialWord(regex));
    }

    public RegexBasedLocationExtractionStrategy(Pattern pattern) {
        this.pattern = pattern;
    }

    @Override
    public Collection<IPdfTextLocation> getResultantLocations() {
        Collections.sort(this.parseResult);
        ArrayList<IPdfTextLocation> retval = new ArrayList<IPdfTextLocation>();
        CharacterRenderInfo.StringConversionInfo txt = CharacterRenderInfo.mapString(this.parseResult);
        Matcher mat = this.pattern.matcher(txt.text);
        while (mat.find()) {
            int startIndex = txt.indexMap.get(mat.start());
            int endIndex = 0;
            if (txt.indexMap.size() == mat.end()) {
                endIndex = txt.indexMap.get(mat.end() - 1);
            } else {
                int tmpEndIndex = mat.end();
                try {
                    endIndex = txt.indexMap.get(tmpEndIndex);
                }
                catch (NullPointerException e) {
                    endIndex = txt.indexMap.get(tmpEndIndex - 1);
                }
            }
            if (startIndex == endIndex) {
                ++endIndex;
            }
            for (Rectangle r : this.toRectangles(this.parseResult.subList(startIndex, endIndex))) {
                retval.add(new DefaultPdfTextLocation(0, r, mat.group(0)));
            }
        }
        Collections.sort(retval, new Comparator<IPdfTextLocation>(){

            @Override
            public int compare(IPdfTextLocation l1, IPdfTextLocation l2) {
                Rectangle o1 = l1.getRectangle();
                Rectangle o2 = l2.getRectangle();
                if (o1.getY() == o2.getY()) {
                    return o1.getX() == o2.getX() ? 0 : (o1.getX() < o2.getX() ? -1 : 1);
                }
                return o1.getY() < o2.getY() ? 1 : -1;
            }
        });
        return retval;
    }

    @Override
    public void eventOccurred(IEventData data, EventType type) {
        if (data instanceof TextRenderInfo) {
            this.parseResult.addAll(this.toCRI((TextRenderInfo)data));
        }
    }

    @Override
    public Set<EventType> getSupportedEvents() {
        return null;
    }

    protected List<CharacterRenderInfo> toCRI(TextRenderInfo tri) {
        ArrayList<CharacterRenderInfo> cris = new ArrayList<CharacterRenderInfo>();
        for (TextRenderInfo subTri : tri.getCharacterRenderInfos()) {
            cris.add(new CharacterRenderInfo(subTri));
        }
        return cris;
    }

    protected List<Rectangle> toRectangles(List<CharacterRenderInfo> cris) {
        ArrayList<Rectangle> retval = new ArrayList<Rectangle>();
        if (cris.isEmpty()) {
            return retval;
        }
        int prev = 0;
        int curr = 0;
        while (curr < cris.size()) {
            while (curr < cris.size() && cris.get(curr).sameLine(cris.get(prev))) {
                ++curr;
            }
            float x = cris.get(prev).getBoundingBox().getX();
            float y = cris.get(prev).getBoundingBox().getY();
            float w = cris.get(curr - 1).getBoundingBox().getX() - cris.get(prev).getBoundingBox().getX() + cris.get(curr - 1).getBoundingBox().getWidth();
            float h = 0.0f;
            for (CharacterRenderInfo cri : cris.subList(prev, curr)) {
                h = Math.max(h, cri.getBoundingBox().getHeight());
            }
            retval.add(new Rectangle(x, y, w, h));
            prev = curr;
        }
        return retval;
    }
}

