/*
 * Decompiled with CFR 0.152.
 */
package cfca.integration.uarc.fn;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.integration.SimpsonIntegrator;

public class EllipseFunction
implements UnivariateFunction {
    private Logger logger = LoggerFactory.getLogger(EllipseFunction.class);
    private double a;
    private double b;

    public EllipseFunction(double a, double b) {
        this.a = a;
        this.b = b;
    }

    public double value(double radians) {
        double y = Math.sqrt(Math.pow(this.a * Math.sin(radians), 2.0) + Math.pow(this.b * Math.cos(radians), 2.0));
        return y;
    }

    public double getArcLength(double startAngle, double arcAngle) {
        SimpsonIntegrator integrator = new SimpsonIntegrator();
        double arcLength = integrator.integrate(1000, (UnivariateFunction)this, startAngle, startAngle + arcAngle);
        return arcLength;
    }

    /*
     * Unable to fully structure code
     */
    public double getEndAngle(double arcLength, double startAngle, double arcAngle0) {
        tmpArcLength = 0.0;
        tmpArcAngle0 = arcAngle0;
        stepAngle0 = arcAngle0;
        n = 1;
        cr = new int[2];
        cr[1] = 0;
        cr[0] = 0;
        isFirst = true;
        block0: while (true) {
            if (Math.abs((tmpArcLength = this.getArcLength(startAngle, tmpArcAngle0)) - arcLength) <= 1.0E-6) {
                return startAngle + tmpArcAngle0;
            }
            if (tmpArcLength - arcLength < -1.0E-6) {
                if (isFirst) {
                    cr[0] = -1;
                    isFirst = false;
                } else {
                    cr[1] = -1;
                    if (cr[0] != cr[1]) {
                        cr[0] = cr[1];
                        tmpArcAngle0 += stepAngle0 / (double)(++n);
                        continue;
                    }
                    cr[0] = cr[1];
                }
                tmpArcAngle0 += stepAngle0 / (double)n;
                continue;
            }
            if (!(tmpArcLength - arcLength > 1.0E-6)) continue;
            if (isFirst) {
                cr[0] = 1;
                isFirst = false;
            } else {
                cr[1] = 1;
                if (cr[0] != cr[1]) {
                    cr[0] = cr[1];
                    tmpArcAngle0 -= stepAngle0 / (double)(++n);
                    while (true) {
                        if (!(Math.abs(tmpArcAngle0) <= 1.0E-6)) continue block0;
                        tmpArcAngle0 += stepAngle0 / (double)(++n);
                    }
                }
                cr[0] = cr[1];
            }
            tmpArcAngle0 -= stepAngle0 / (double)n;
            while (true) {
                if (Math.abs(tmpArcAngle0) <= 1.0E-6) ** break;
                continue block0;
                tmpArcAngle0 += stepAngle0 / (double)(++n);
            }
            break;
        }
    }

    public double[] getAngles(double arcLength, double startAngle, double arcAngle, int nPoints) {
        double tmpArcAngle0 = arcAngle / (double)nPoints;
        double[] angles = new double[nPoints];
        angles[0] = startAngle;
        int nseg = nPoints - 1;
        double tmpEndArcLength = arcLength / (double)nseg;
        double tmpStartAngle = startAngle;
        for (int i = 1; i < nseg; ++i) {
            double tmpEndAngle;
            angles[i] = tmpEndAngle = this.getEndAngle(tmpEndArcLength, tmpStartAngle, tmpArcAngle0);
            tmpStartAngle = tmpEndAngle;
        }
        angles[nseg] = startAngle + arcAngle;
        return angles;
    }

    public UArcPoints getArcPoints(double[] angles) {
        int n = angles.length;
        UArcPoints uaps = new UArcPoints(n);
        for (int i = 0; i < n; ++i) {
            UArcPoint uap = new UArcPoint();
            uap.x0 = this.a * Math.cos(angles[i]);
            uap.y0 = this.b * Math.sin(angles[i]);
            uaps.add(uap);
        }
        return uaps;
    }

    public UArcPoints getCenterPoints(double[] angles, double slide, boolean rounding) {
        double tmpSlide = -slide;
        if (rounding) {
            UArcPoints arcPoints = this.getArcPoints(angles);
            int size = arcPoints.size();
            UArcPoints centerPoints = new UArcPoints(size);
            double tmpAngle = Double.NaN;
            for (int i = 0; i < size; ++i) {
                UArcPoint uap = arcPoints.get(i);
                double x0 = uap.x0;
                double y0 = uap.y0;
                if (Math.abs(x0) <= 1.0E-6 && y0 > 0.0) {
                    tmpAngle = 1.5707963267948966;
                } else if (x0 < 0.0 && Math.abs(y0) <= 1.0E-6) {
                    tmpAngle = Math.PI;
                } else if (Math.abs(x0) <= 1.0E-6 && y0 < 0.0) {
                    tmpAngle = 4.71238898038469;
                } else if (x0 > 0.0 && Math.abs(y0) <= 1.0E-6) {
                    tmpAngle = 0.0;
                } else {
                    double tangentValue = Math.pow(this.a / this.b, 2.0) * (y0 / x0);
                    if (x0 > 0.0 && y0 > 0.0) {
                        tmpAngle = Math.atan(tangentValue);
                    } else if (x0 < 0.0 && y0 > 0.0) {
                        tmpAngle = Math.atan(tangentValue);
                        tmpAngle += Math.PI;
                    } else if (x0 < 0.0 && y0 < 0.0) {
                        tmpAngle = Math.atan(tangentValue);
                        tmpAngle += Math.PI;
                    } else if (x0 > 0.0 && y0 < 0.0) {
                        tmpAngle = Math.atan(tangentValue);
                        tmpAngle += Math.PI * 2;
                    }
                }
                double newx0 = x0 - tmpSlide * Math.cos(tmpAngle);
                double newy0 = y0 - tmpSlide * Math.sin(tmpAngle);
                double newn = tmpAngle;
                UArcPoint newuap = new UArcPoint();
                newuap.x0 = newx0;
                newuap.y0 = newy0;
                newuap.normal0 = newn;
                centerPoints.add(newuap);
            }
            return centerPoints;
        }
        int n = angles.length;
        double sb = Math.sqrt(Math.pow(this.a * Math.cos(angles[n - 1]), 2.0) + Math.pow(this.b * Math.sin(angles[n - 1]), 2.0));
        double kb = (sb - tmpSlide) / tmpSlide;
        double cx = kb * this.a * Math.cos(angles[n - 1]) / (1.0 + kb);
        double cy = kb * this.b * Math.sin(angles[n - 1]) / (1.0 + kb);
        double sc = Math.sqrt(Math.pow(this.a * Math.cos(angles[0]), 2.0) + Math.pow(this.b * Math.sin(angles[0]), 2.0));
        double kc = (sc - tmpSlide) / tmpSlide;
        double bx = kc * this.a * Math.cos(angles[0]) / (1.0 + kc);
        double by = kc * this.b * Math.sin(angles[0]) / (1.0 + kc);
        double bcx = cx - bx;
        double bcy = cy - by;
        double bc = Math.sqrt(Math.pow(bcx, 2.0) + Math.pow(bcy, 2.0));
        double bcna = 0.0;
        if (bcx == 0.0 && bcy > 0.0) {
            bcna = 0.0;
        } else if (bcx == 0.0 && bcy < 0.0) {
            bcna = Math.PI;
        } else if (bcx < 0.0 && bcy == 0.0) {
            bcna = 1.5707963267948966;
        } else if (bcx > 0.0 && bcy == 0.0) {
            bcna = 4.71238898038469;
        } else if (bcx < 0.0 && bcy > 0.0) {
            bcna = Math.atan(-bcx / bcy);
        } else if (bcx < 0.0 && bcy < 0.0) {
            bcna = Math.atan(-bcx / bcy);
            bcna += Math.PI;
        } else if (bcx > 0.0 && bcy < 0.0) {
            bcna = Math.atan(-bcx / bcy);
            bcna += Math.PI;
        } else if (bcx > 0.0 && bcy > 0.0) {
            bcna = Math.atan(-bcx / bcy);
            bcna = Math.PI * 2 + bcna;
        }
        int nseg = n - 1;
        double sl = bc / (double)nseg;
        UArcPoints centerPoints = new UArcPoints(n);
        UArcPoint uap0 = new UArcPoint();
        uap0.x0 = bx;
        uap0.y0 = by;
        uap0.normal0 = bcna;
        centerPoints.add(uap0);
        for (int i = 1; i < nseg; ++i) {
            double kbc = sl * (double)i / (bc - sl * (double)i);
            UArcPoint uapi = new UArcPoint();
            double sx = (bx + kbc * cx) / (1.0 + kbc);
            double sy = (by + kbc * cy) / (1.0 + kbc);
            uapi.x0 = sx;
            uapi.y0 = sy;
            uapi.normal0 = bcna;
            centerPoints.add(uapi);
        }
        UArcPoint uapn = new UArcPoint();
        uapn.x0 = cx;
        uapn.y0 = cy;
        uapn.normal0 = bcna;
        centerPoints.add(uapn);
        return centerPoints;
    }

    public static class UArcPoints {
        private ArrayList<UArcPoint> uaps;
        private int[][] toArrayXY;
        private double[] toArrayNormal;
        private boolean isUpdate;
        private int size;

        public UArcPoints(int initialCapacity) {
            this.uaps = new ArrayList(initialCapacity);
            this.isUpdate = false;
        }

        public int[][] toArrayXY() {
            if (null == this.toArrayXY || !this.isUpdate) {
                this.size = this.size();
                this.toArrayXY = new int[2][this.size];
                for (int i = 0; i < this.size; ++i) {
                    UArcPoint uap = this.uaps.get(i);
                    this.toArrayXY[0][i] = (int)(uap.x0 + 0.5);
                    this.toArrayXY[1][i] = (int)(uap.y0 + 0.5);
                }
            }
            return this.toArrayXY;
        }

        public UArcPoint get(int index) {
            return this.uaps.get(index);
        }

        public double[] toArrayNormal() {
            if (null == this.toArrayNormal || !this.isUpdate) {
                this.size = this.size();
                this.toArrayNormal = new double[this.size];
                for (int i = 0; i < this.size; ++i) {
                    UArcPoint uap = this.uaps.get(i);
                    this.toArrayNormal[i] = uap.normal0;
                }
            }
            return this.toArrayNormal;
        }

        public boolean add(UArcPoint coord) {
            this.isUpdate = false;
            return this.uaps.add(coord);
        }

        public void add(int index, UArcPoint coord) {
            this.isUpdate = false;
            this.uaps.add(index, coord);
        }

        public int size() {
            if (!this.isUpdate) {
                this.size = this.uaps.size();
                this.isUpdate = true;
            }
            return this.size;
        }
    }

    public static class UArcPoint {
        public double x0;
        public double y0;
        public double normal0;

        public UArcPoint(double x0, double y0, double normal0) {
            this.x0 = x0;
            this.y0 = y0;
            this.normal0 = normal0;
        }

        public UArcPoint() {
        }
    }
}

