/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.cgb.toolkit;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.sm2.SM2Crypto;
import cfca.sadk.algorithm.sm2.SM2PrivateKey;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.algorithm.sm2.SM3Digest;
import cfca.sadk.asn1.pkcs.PKCS12_SM2;
import cfca.sadk.lib.crypto.bcsoft.BCSoftSM2;
import cfca.sadk.org.bouncycastle.crypto.generators.SM2KeyPairGenerator;
import cfca.sadk.system.FileHelper;
import cfca.sadk.util.Base64;
import cfca.sadk.x509.certificate.X509Cert;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;

public final class SM2Toolkit {
    public KeyPair SM2GenerateKeyPair() throws PKIException {
        try {
            return SM2KeyPairGenerator.SM2GenerateKeyPair();
        }
        catch (Exception e) {
            throw new PKIException("generate keypair failure", e);
        }
    }

    public KeyPair SM2BuildKeyPairByText(String sm2Base64Text, String sm2FilePassword) throws PKIException {
        if (sm2Base64Text == null) {
            throw new IllegalArgumentException("null not allowed for sm2Base64Text");
        }
        if (sm2FilePassword == null) {
            throw new IllegalArgumentException("null not allowed for sm2FilePassword");
        }
        try {
            return this.SM2BuildKeyPair(Base64.decode(sm2Base64Text), sm2FilePassword);
        }
        catch (Exception e) {
            throw new PKIException("build keypair failure", e);
        }
    }

    public KeyPair SM2BuildKeyPairByFile(String sm2FilePath, String sm2FilePassword) throws PKIException {
        byte[] sm2Bytes;
        if (sm2FilePath == null) {
            throw new IllegalArgumentException("null not allowed for sm2FilePath");
        }
        if (sm2FilePassword == null) {
            throw new IllegalArgumentException("null not allowed for sm2FilePassword");
        }
        try {
            sm2Bytes = FileHelper.read(sm2FilePath);
        }
        catch (Exception e) {
            throw new PKIException("sm2FilePath read failure", e);
        }
        return this.SM2BuildKeyPair(sm2Bytes, sm2FilePassword);
    }

    private KeyPair SM2BuildKeyPair(byte[] sm2Bytes, String sm2FilePassword) throws PKIException {
        if (sm2Bytes == null) {
            throw new IllegalArgumentException("null not allowed for sm2Bytes");
        }
        if (sm2FilePassword == null) {
            throw new IllegalArgumentException("null not allowed for sm2FilePassword");
        }
        PKCS12_SM2 pkcs12 = new PKCS12_SM2(sm2Bytes);
        try {
            SM2PrivateKey privateKey = pkcs12.getPrivateKey(sm2FilePassword);
            if (privateKey == null) {
                throw new PKIException("build keypair failure: not found sm2PrivateKey");
            }
            X509Cert[] certs = pkcs12.getPublicCert();
            if (certs == null || certs.length == 0) {
                throw new PKIException("build keypair failure: not found sm2PublicKey");
            }
            return new KeyPair(certs[0].getPublicKey(), privateKey);
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("build keypair failure", e);
        }
    }

    public PublicKey SM2BuildPublicKey(String sm2Base64PublicKey) throws PKIException {
        if (sm2Base64PublicKey == null) {
            throw new IllegalArgumentException("null not allowed for sm2Base64PublicKey");
        }
        try {
            byte[] encoding = Base64.decode(sm2Base64PublicKey);
            return new SM2PublicKey(encoding);
        }
        catch (Exception e) {
            throw new PKIException("build sm2PublicKey failure", e);
        }
    }

    public PrivateKey SM2BuildPrivateKey(String sm2Base64PrivateKey) throws PKIException {
        if (sm2Base64PrivateKey == null) {
            throw new IllegalArgumentException("null not allowed for sm2Base64PrivateKey");
        }
        try {
            byte[] encoding = Base64.decode(sm2Base64PrivateKey);
            return SM2PrivateKey.getInstance(encoding);
        }
        catch (Exception e) {
            throw new PKIException("build sm2PrivateKey failure", e);
        }
    }

    public byte[] SM2EncryptData(PublicKey sm2PublicKey, byte[] data) throws PKIException {
        if (sm2PublicKey == null || !(sm2PublicKey instanceof SM2PublicKey)) {
            throw new IllegalArgumentException("null/type not allowed for sm2PublicKey");
        }
        if (data == null) {
            throw new IllegalArgumentException("null not allowed for data");
        }
        SM2PublicKey publicKey = (SM2PublicKey)sm2PublicKey;
        try {
            SM2Crypto engine = new SM2Crypto();
            engine.initEncrypt(publicKey.getQ());
            return engine.encrypt(data);
        }
        catch (Exception e) {
            throw new PKIException("encrypted failure", e);
        }
    }

    public byte[] SM2DecryptData(PrivateKey sm2PrivateKey, byte[] data) throws PKIException {
        if (sm2PrivateKey == null || !(sm2PrivateKey instanceof SM2PrivateKey)) {
            throw new IllegalArgumentException("null/type not allowed for sm2PrivateKey");
        }
        if (data == null) {
            throw new IllegalArgumentException("null not allowed for data");
        }
        SM2PrivateKey privateKey = (SM2PrivateKey)sm2PrivateKey;
        try {
            SM2Crypto engine = new SM2Crypto();
            engine.initDecrypt(privateKey.dBigInteger());
            return engine.decrypt(data);
        }
        catch (Exception e) {
            throw new PKIException("decrypted failure", e);
        }
    }

    public byte[] SM2Sign(PrivateKey sm2PrivateKey, byte[] data) throws PKIException {
        if (sm2PrivateKey == null || !(sm2PrivateKey instanceof SM2PrivateKey)) {
            throw new IllegalArgumentException("null/type not allowed for sm2PrivateKey");
        }
        if (data == null) {
            throw new IllegalArgumentException("null not allowed for data");
        }
        SM2PrivateKey privateKey = (SM2PrivateKey)sm2PrivateKey;
        try {
            byte[] hash = this.SM3(data, privateKey.getSM2PublicKey().getDefaultZ());
            return BCSoftSM2.sign(hash, privateKey.dBigInteger(), true);
        }
        catch (Exception e) {
            throw new PKIException("signature signed failure", e);
        }
    }

    public boolean SM2Verify(PublicKey sm2PublicKey, byte[] data, byte[] signature) throws PKIException {
        if (sm2PublicKey == null || !(sm2PublicKey instanceof SM2PublicKey)) {
            throw new IllegalArgumentException("null/type not allowed for sm2PublicKey");
        }
        if (data == null) {
            throw new IllegalArgumentException("null not allowed for data");
        }
        if (signature == null || signature.length < 64) {
            return false;
        }
        SM2PublicKey publicKey = (SM2PublicKey)sm2PublicKey;
        try {
            byte[] hash = this.SM3(data, publicKey.getDefaultZ());
            return BCSoftSM2.verify(hash, signature, publicKey.getQ());
        }
        catch (Exception e) {
            throw new PKIException("signature verified failure", e);
        }
    }

    public byte[] SM2SignHash(PrivateKey sm2PrivateKey, byte[] hash) throws PKIException {
        if (sm2PrivateKey == null || !(sm2PrivateKey instanceof SM2PrivateKey)) {
            throw new IllegalArgumentException("null/type not allowed for sm2PrivateKey");
        }
        if (hash == null || hash.length != 32) {
            throw new IllegalArgumentException("null/length not allowed for hash");
        }
        return BCSoftSM2.sign(hash, ((SM2PrivateKey)sm2PrivateKey).dBigInteger(), true);
    }

    public boolean SM2VerifyHash(PublicKey sm2PublicKey, byte[] hash, byte[] signature) throws PKIException {
        if (sm2PublicKey == null || !(sm2PublicKey instanceof SM2PublicKey)) {
            throw new IllegalArgumentException("null/type not allowed for sm2PublicKey");
        }
        if (hash == null || hash.length != 32) {
            return false;
        }
        if (signature == null || signature.length < 64) {
            return false;
        }
        return BCSoftSM2.verify(hash, signature, ((SM2PublicKey)sm2PublicKey).getQ());
    }

    private byte[] SM3(byte[] data, byte[] zvalue) {
        byte[] hash = new byte[32];
        SM3Digest digest = new SM3Digest();
        digest.update(zvalue, 0, zvalue.length);
        digest.update(data, 0, data.length);
        digest.doFinal(hash, 0);
        return hash;
    }
}

