/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.signature;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKCS7AttachSourceFile;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.asn1.FastEncoding;
import cfca.sadk.asn1.parser.ASN1Parser;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.ASN1Object;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1OutputStream;
import cfca.sadk.org.bouncycastle.asn1.BERSet;
import cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import cfca.sadk.org.bouncycastle.asn1.DEROutputStream;
import cfca.sadk.org.bouncycastle.asn1.DERSet;
import cfca.sadk.org.bouncycastle.asn1.pkcs.ContentInfo;
import cfca.sadk.org.bouncycastle.asn1.pkcs.IssuerAndSerialNumber;
import cfca.sadk.org.bouncycastle.asn1.pkcs.SignedData;
import cfca.sadk.org.bouncycastle.asn1.x500.X500Name;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.system.logging.LoggerManager;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;

abstract class AbstractPKCS7Package {
    public static final ASN1Integer signInfoVersion = new ASN1Integer(1L);
    public static final ASN1Integer signedDataVersion = new ASN1Integer(1L);

    AbstractPKCS7Package() {
    }

    public void packageSignedFile(String sourceFile, String signFile, byte[] signature, Mechanism mechanism, X509Cert[] certs) throws PKIException {
        ASN1OutputStream dos = null;
        try {
            boolean createResult;
            if (certs == null || certs[0] == null) {
                throw new PKIException(PKIException.NULL_ENCRYPT_CERTS_ERR, PKIException.NULL_ENCRYPT_CERTS_ERR_DES);
            }
            BigInteger sn = certs[0].getSerialNumber();
            X500Name issuer = certs[0].getIssuerX500Name();
            IssuerAndSerialNumber issuerAndSn = new IssuerAndSerialNumber(issuer, sn);
            AlgorithmIdentifier digestAlgIdentifier = this.getDigestAlgIdentifier(mechanism);
            ASN1ObjectIdentifier signDataIdentifier = this.getSignDataIdentifier();
            ASN1Object signerInfo = this.getSignerInfo(signature, issuerAndSn, mechanism);
            ContentInfo contentInfo = this.getContentInfo(null, sourceFile);
            ASN1EncodableVector derV = new ASN1EncodableVector();
            derV.add(digestAlgIdentifier);
            BERSet digestAlgorithmSets = new BERSet(derV);
            derV = new ASN1EncodableVector();
            derV.add(signerInfo);
            DERSet signerInfos = new DERSet(derV);
            ASN1EncodableVector v = new ASN1EncodableVector();
            for (int i = 0; i < certs.length; ++i) {
                v.add(new FastEncoding(certs[i]));
            }
            BERSet setCert = new BERSet(v);
            SignedData signedData = new SignedData(signedDataVersion, digestAlgorithmSets, contentInfo, setCert, null, signerInfos);
            ContentInfo contentInfoTemp = new ContentInfo(signDataIdentifier, signedData);
            File sign_file = new File(signFile);
            if (!sign_file.exists() && !(createResult = sign_file.createNewFile())) {
                LoggerManager.exceptionLogger.error("createNewFile failed: " + sign_file.getAbsoluteFile());
            }
            FileOutputStream fos = new FileOutputStream(signFile);
            dos = new DEROutputStream(fos);
            ((DEROutputStream)dos).writeObject(contentInfoTemp);
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("build signedFile failure", e);
        }
        finally {
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (IOException e) {
                    throw new PKIException("build signedFile failure", e);
                }
            }
        }
    }

    public final byte[] packageSignedData(boolean ifAttach, String contentType, byte[] sourceData, byte[] signature, Mechanism mechanism, X509Cert[] certs) throws PKIException {
        if (certs == null || certs[0] == null) {
            throw new PKIException(PKIException.NULL_ENCRYPT_CERTS_ERR, PKIException.NULL_ENCRYPT_CERTS_ERR_DES);
        }
        BigInteger sn = certs[0].getSerialNumber();
        X500Name issuer = certs[0].getIssuerX500Name();
        IssuerAndSerialNumber issuerAndSn = new IssuerAndSerialNumber(issuer, sn);
        ASN1Object signerInfo = this.getSignerInfo(signature, issuerAndSn, mechanism);
        ASN1ObjectIdentifier signDataIdentifier = this.getSignDataIdentifier();
        ContentInfo contentInfo = this.getContentInfo(ifAttach, contentType, sourceData);
        ASN1EncodableVector derV = new ASN1EncodableVector();
        AlgorithmIdentifier digestAlgIdentifier = this.getDigestAlgIdentifier(mechanism);
        derV.add(digestAlgIdentifier);
        DERSet digestAlgorithmSets = new DERSet(derV);
        derV = new ASN1EncodableVector();
        derV.add(signerInfo);
        DERSet signerInfos = new DERSet(derV);
        ASN1EncodableVector v = new ASN1EncodableVector();
        for (int i = 0; i < certs.length; ++i) {
            v.add(new FastEncoding(certs[i]));
        }
        BERSet setCert = new BERSet(v);
        SignedData signedData = new SignedData(signedDataVersion, digestAlgorithmSets, contentInfo, setCert, null, signerInfos);
        ContentInfo contentInfoTemp = new ContentInfo(signDataIdentifier, signedData);
        return ASN1Parser.parseDERObj2Bytes(contentInfoTemp);
    }

    private ContentInfo getContentInfo(boolean ifAttach, String contentType, byte[] sourceData) throws PKIException {
        ContentInfo contentInfo = null;
        ASN1ObjectIdentifier contentIdentifier = this.getContentIdentifier();
        if (ifAttach) {
            DEROctetString derSourceData = new DEROctetString(sourceData);
            contentInfo = contentType == null ? new ContentInfo(contentIdentifier, derSourceData) : new ContentInfo(new ASN1ObjectIdentifier(contentType), derSourceData);
        } else {
            contentInfo = contentType == null ? new ContentInfo(contentIdentifier, null) : new ContentInfo(new ASN1ObjectIdentifier(contentType), null);
        }
        return contentInfo;
    }

    private ContentInfo getContentInfo(String contentType, String sourceFile) throws PKIException {
        ContentInfo contentInfo = null;
        ASN1ObjectIdentifier contentIdentifier = this.getContentIdentifier();
        PKCS7AttachSourceFile derSourceData = new PKCS7AttachSourceFile(new File(sourceFile));
        contentInfo = contentType == null ? new ContentInfo(contentIdentifier, derSourceData) : new ContentInfo(new ASN1ObjectIdentifier(contentType), derSourceData);
        return contentInfo;
    }

    protected abstract ASN1Object getSignerInfo(byte[] var1, IssuerAndSerialNumber var2, Mechanism var3) throws PKIException;

    protected abstract AlgorithmIdentifier getDigestAlgIdentifier(Mechanism var1) throws PKIException;

    protected abstract ASN1ObjectIdentifier getContentIdentifier() throws PKIException;

    protected abstract ASN1ObjectIdentifier getSignDataIdentifier() throws PKIException;
}

