/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.signature.rsa;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.util.PKCS8ToPKCS1Util;
import cfca.sadk.lib.crypto.jni.JNIRSA;
import cfca.sadk.org.bouncycastle.asn1.x509.DigestInfo;
import cfca.sadk.org.bouncycastle.crypto.InvalidCipherTextException;
import cfca.sadk.org.bouncycastle.crypto.params.RSAKeyParameters;
import cfca.sadk.org.bouncycastle.util.Arrays;
import cfca.sadk.signature.rsa.RSACrypt;
import cfca.sadk.signature.rsa.RSAKeyParamsDecoder;
import java.security.Key;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public class RSAPackageUtil {
    private static int HEADER_LENGTH = 10;

    private static byte[] addPKCS1Padding(byte[] derDigest, RSAPrivateKey priKey) {
        int bitLen = priKey.getModulus().bitLength();
        int blockLen = (bitLen + 7) / 8;
        byte[] block = new byte[blockLen];
        block[0] = 0;
        block[1] = 1;
        int inLen = derDigest.length;
        for (int i = 2; i != block.length - inLen - 1; ++i) {
            block[i] = -1;
        }
        block[block.length - inLen - 1] = 0;
        System.arraycopy(derDigest, 0, block, block.length - inLen, inLen);
        return block;
    }

    private static byte[] delPKCS1Padding(byte[] paddingData) throws Exception {
        byte pad;
        int start;
        byte type = paddingData[1];
        if (type != 1 && type != 2) {
            throw new InvalidCipherTextException("unknown block type");
        }
        for (start = 2; start != paddingData.length && (pad = paddingData[start]) != 0; ++start) {
            if (type != 1 || pad == -1) continue;
            throw new InvalidCipherTextException("block padding incorrect");
        }
        if (++start > paddingData.length || start < HEADER_LENGTH) {
            throw new InvalidCipherTextException("no data in block");
        }
        byte[] result = new byte[paddingData.length - start];
        System.arraycopy(paddingData, start, result, 0, result.length);
        return result;
    }

    public static byte[] encrypt(byte[] digestData, Key privateKey) throws Exception {
        if (digestData == null) {
            throw new Exception("the digest data is null,can not encrypt!!!");
        }
        RSACrypt signer = new RSACrypt();
        RSAPrivateKey priKey = (RSAPrivateKey)privateKey;
        RSAKeyParameters priParameter = RSAKeyParamsDecoder.generatePrivateKeyParameter(priKey);
        signer.init(true, priParameter);
        try {
            return signer.encrypt(digestData);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES, e);
        }
    }

    public static byte[] encryptByJNI(byte[] derDigest, Key privateKey) throws Exception {
        if (derDigest == null) {
            throw new Exception("the digest data is null,can not encrypt!!!");
        }
        RSAPrivateKey priKey = (RSAPrivateKey)privateKey;
        byte[] input = RSAPackageUtil.addPKCS1Padding(derDigest, priKey);
        byte[] output = new byte[input.length];
        byte[] pkcs1PriKey = PKCS8ToPKCS1Util.RSAP8ToP1PriKey(priKey);
        JNIRSA.dowithPrivateKey(input, pkcs1PriKey, output, priKey);
        return output;
    }

    public static byte[] decrypt(byte[] encryptedData, Key publicKey) throws Exception {
        if (encryptedData == null) {
            throw new Exception("the encrypt data is null,can not decrypt!!!");
        }
        RSACrypt signer = new RSACrypt();
        RSAPublicKey pubKey = (RSAPublicKey)publicKey;
        RSAKeyParameters pubParameter = RSAKeyParamsDecoder.generatePublicKeyParameter(pubKey);
        signer.init(false, pubParameter);
        return signer.decrypt(encryptedData);
    }

    public static byte[] decryptByJNI(byte[] encryptedData, Key publicKey) throws Exception {
        if (encryptedData == null) {
            throw new Exception("the encrypt data is null,can not decrypt!!!");
        }
        RSAPublicKey pubKey = (RSAPublicKey)publicKey;
        byte[] pkcs1PubKey = PKCS8ToPKCS1Util.RSAP8ToP1PubKey(pubKey);
        int bitLen = pubKey.getModulus().bitLength();
        int blockLen = (bitLen + 7) / 8;
        byte[] output = new byte[blockLen];
        JNIRSA.dowithPublicKey(encryptedData, pkcs1PubKey, output);
        return RSAPackageUtil.delPKCS1Padding(output);
    }

    public static boolean isRSAHashEqual(byte[] extractHash, byte[] calcuHash) {
        if (calcuHash == null || extractHash == null) {
            return false;
        }
        if (extractHash.length == calcuHash.length) {
            return Arrays.constantTimeAreEqual(extractHash, calcuHash);
        }
        if (extractHash.length == calcuHash.length - 2) {
            int i;
            DigestInfo dInfo = DigestInfo.getInstance(calcuHash);
            int len = dInfo.getDigest().length;
            int sigOffset = extractHash.length - len - 2;
            int expectedOffset = calcuHash.length - len - 2;
            calcuHash[1] = (byte)(calcuHash[1] - 2);
            calcuHash[3] = (byte)(calcuHash[3] - 2);
            int nonEqual = 0;
            for (i = 0; i < len; ++i) {
                nonEqual |= extractHash[sigOffset + i] ^ calcuHash[expectedOffset + i];
            }
            for (i = 0; i < sigOffset; ++i) {
                nonEqual |= extractHash[i] ^ calcuHash[i];
            }
            return nonEqual == 0;
        }
        return false;
    }
}

