/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.google.typography.font.sfntly.table.opentype;

import cfca.com.google.typography.font.sfntly.data.ReadableFontData;
import cfca.com.google.typography.font.sfntly.table.opentype.AlternateSubst;
import cfca.com.google.typography.font.sfntly.table.opentype.ChainContextSubst;
import cfca.com.google.typography.font.sfntly.table.opentype.ContextSubst;
import cfca.com.google.typography.font.sfntly.table.opentype.ExtensionSubst;
import cfca.com.google.typography.font.sfntly.table.opentype.LigatureSubst;
import cfca.com.google.typography.font.sfntly.table.opentype.MultipleSubst;
import cfca.com.google.typography.font.sfntly.table.opentype.NullTable;
import cfca.com.google.typography.font.sfntly.table.opentype.ReverseChainSingleSubst;
import cfca.com.google.typography.font.sfntly.table.opentype.SingleSubst;
import cfca.com.google.typography.font.sfntly.table.opentype.SubstSubtable;
import cfca.com.google.typography.font.sfntly.table.opentype.component.GsubLookupType;
import cfca.com.google.typography.font.sfntly.table.opentype.component.OffsetRecordTable;
import cfca.com.google.typography.font.sfntly.table.opentype.component.VisibleSubTable;

public class LookupTable
extends OffsetRecordTable<SubstSubtable> {
    private static final int FIELD_COUNT = 2;
    static final int LOOKUP_TYPE_INDEX = 0;
    private static final int LOOKUP_TYPE_DEFAULT = 0;
    private static final int LOOKUP_FLAG_INDEX = 1;

    protected LookupTable(ReadableFontData data, int base, boolean dataIsCanonical) {
        super(data, base, dataIsCanonical);
        int lookupFlag = this.getField(1);
        if (LookupFlagBit.USE_MARK_FILTERING_SET.getValue(lookupFlag) != 0) {
            throw new IllegalArgumentException("Lookup Flag has Use Mark Filtering Set which is unimplemented.");
        }
        if (LookupFlagBit.RESERVED.getValue(lookupFlag) != 0) {
            throw new IllegalArgumentException("Reserved bits of Lookup Flag are not 0");
        }
    }

    public GsubLookupType lookupType() {
        return GsubLookupType.forTypeNum(this.getField(0));
    }

    public GsubLookupType lookupFlag() {
        return GsubLookupType.forTypeNum(this.getField(1));
    }

    @Override
    protected SubstSubtable readSubTable(ReadableFontData data, boolean dataIsCanonical) {
        int lookupType = this.getField(0);
        GsubLookupType gsubLookupType = GsubLookupType.forTypeNum(lookupType);
        switch (gsubLookupType) {
            case GSUB_LIGATURE: {
                return new LigatureSubst(data, this.base, dataIsCanonical);
            }
            case GSUB_SINGLE: {
                return new SingleSubst(data, this.base, dataIsCanonical);
            }
            case GSUB_MULTIPLE: {
                return new MultipleSubst(data, this.base, dataIsCanonical);
            }
            case GSUB_ALTERNATE: {
                return new AlternateSubst(data, this.base, dataIsCanonical);
            }
            case GSUB_CONTEXTUAL: {
                return new ContextSubst(data, this.base, dataIsCanonical);
            }
            case GSUB_CHAINING_CONTEXTUAL: {
                return new ChainContextSubst(data, this.base, dataIsCanonical);
            }
            case GSUB_EXTENSION: {
                return new ExtensionSubst(data, this.base, dataIsCanonical);
            }
            case GSUB_REVERSE_CHAINING_CONTEXTUAL_SINGLE: {
                return new ReverseChainSingleSubst(data, this.base, dataIsCanonical);
            }
        }
        System.err.println("Unimplemented LookupType: " + gsubLookupType);
        return new NullTable(data, this.base, dataIsCanonical);
    }

    @Override
    public int fieldCount() {
        return 2;
    }

    Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends OffsetRecordTable.Builder<LookupTable, SubstSubtable> {
        Builder() {
        }

        Builder(ReadableFontData data, boolean dataIsCanonical) {
            this(data, 0, dataIsCanonical);
        }

        private Builder(ReadableFontData data, int base, boolean dataIsCanonical) {
            super(data, base, dataIsCanonical);
        }

        Builder(LookupTable table) {
            super(table);
        }

        @Override
        protected LookupTable readTable(ReadableFontData data, int base, boolean dataIsCanonical) {
            return new LookupTable(data, base, dataIsCanonical);
        }

        @Override
        protected VisibleSubTable.Builder<SubstSubtable> createSubTableBuilder() {
            return new LigatureSubst.Builder();
        }

        @Override
        protected VisibleSubTable.Builder<SubstSubtable> createSubTableBuilder(ReadableFontData data, boolean dataIsCanonical) {
            return new LigatureSubst.Builder(data, dataIsCanonical);
        }

        @Override
        protected VisibleSubTable.Builder<SubstSubtable> createSubTableBuilder(SubstSubtable subTable) {
            return new LigatureSubst.Builder(subTable);
        }

        @Override
        public int fieldCount() {
            return 2;
        }

        @Override
        public void initFields() {
            this.setField(0, 0);
            this.setField(1, 1);
        }
    }

    private static enum LookupFlagBit {
        RIGHT_TO_LEFT(1),
        IGNORE_BASE_GLYPHS(2),
        IGNORE_LIGATURES(4),
        IGNORE_MARKS(8),
        USE_MARK_FILTERING_SET(16),
        RESERVED(224),
        MARK_ATTACHMENT_TYPE(65280);

        private int bit;

        private LookupFlagBit(int bit) {
            this.bit = bit;
        }

        private int getValue(int value) {
            return this.bit & value;
        }
    }
}

