/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.x509.certificate;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.asn1.parser.ASN1Parser;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import cfca.sadk.org.bouncycastle.asn1.DERBitString;
import cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.asn1.sm2.ASN1SM2Signature;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.Extension;
import cfca.sadk.org.bouncycastle.asn1.x509.TBSCertList;
import cfca.sadk.org.bouncycastle.asn1.x509.Time;
import cfca.sadk.org.bouncycastle.asn1.x509.V2TBSCertListGenerator;
import cfca.sadk.org.bouncycastle.asn1.x509.X509Extension;
import cfca.sadk.org.bouncycastle.asn1.x509.X509Extensions;
import cfca.sadk.org.bouncycastle.asn1.x509.X509Name;
import cfca.sadk.system.Mechanisms;
import cfca.sadk.system.SADKDebugger;
import cfca.sadk.system.logging.LoggerManager;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public class X509CRLGenerator {
    public static final int UNSPECIFIED = 0;
    public static final int KEY_COMPROMISE = 1;
    public static final int CA_COMPROMISE = 2;
    public static final int AFFILIATION_CHANGED = 3;
    public static final int SUPERSEDED = 4;
    public static final int CESSATION_OF_OPERATION = 5;
    public static final int CERTIFICATE_HOLD = 6;
    public static final int REMOVE_FROM_CRL = 8;
    public static final int PRIVILEGE_WITHDRAWN = 9;
    public static final int AA_COMPROMISE = 10;
    private Mechanism mechanism = null;
    private V2TBSCertListGenerator tbsCRLGen = new V2TBSCertListGenerator();
    private AlgorithmIdentifier sigAlg = null;
    private TBSCertList tbsCRL = null;
    private DERBitString signature = null;
    private String issuerName = null;
    private Date thisUpdate = null;
    private Hashtable extensionSet = new Hashtable();

    public void addRevokeCert(String serialNumber, Date revokeTime) {
        BigInteger bigIntSN = new BigInteger(serialNumber, 16);
        this.tbsCRLGen.addCRLEntry(new ASN1Integer(bigIntSN), new Time(revokeTime), 0);
    }

    public void addRevokeCert(String serialNumber, Date revokeTime, int revokeReason) {
        BigInteger bigIntSN = new BigInteger(serialNumber, 16);
        this.tbsCRLGen.addCRLEntry(new ASN1Integer(bigIntSN), new Time(revokeTime), revokeReason);
    }

    public void addRevokeCert(BigInteger serialNumber, Date revokeTime) {
        this.tbsCRLGen.addCRLEntry(new ASN1Integer(serialNumber), new Time(revokeTime), 0);
    }

    public void addRevokeCert(BigInteger serialNumber, Date revokeTime, int revokeReason) {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("addRevokeCert>>>>>>Running");
            buffer.append("\n serialNumber: ");
            buffer.append(SADKDebugger.dump(serialNumber));
            buffer.append("\n revokeTime: ");
            buffer.append(revokeTime);
            buffer.append("\n revokeReason: ");
            buffer.append(revokeReason);
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        this.tbsCRLGen.addCRLEntry(new ASN1Integer(serialNumber), new Time(revokeTime), revokeReason);
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("addRevokeCert<<<<<<Finished");
        }
    }

    public void setIssuer(String issuerDN) {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("setIssuer>>>>>>Running: issuerDN=" + issuerDN);
        }
        if (issuerDN == null) {
            throw new IllegalArgumentException("issuerDN not allowed null");
        }
        this.issuerName = issuerDN;
        X509Name x509Issuer = new X509Name(issuerDN);
        this.tbsCRLGen.setIssuer(x509Issuer);
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("setIssuer<<<<<<Finished");
        }
    }

    public void setThisUpdate(Date thisUpdate) {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("setNextUpdate>>>>>>Running: thisUpdate=" + thisUpdate);
        }
        if (thisUpdate == null) {
            throw new IllegalArgumentException("thisUpdate not allowed null");
        }
        this.thisUpdate = thisUpdate;
        this.tbsCRLGen.setThisUpdate(new Time(thisUpdate));
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("setNextUpdate<<<<<<Finished");
        }
    }

    public void setNextUpdate(Date nextUpdate) {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("setNextUpdate>>>>>>Running: nextUpdate=" + nextUpdate);
        }
        if (nextUpdate != null) {
            this.tbsCRLGen.setNextUpdate(new Time(nextUpdate));
        }
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("setNextUpdate<<<<<<Finished");
        }
    }

    public void setSignatureAlg(String signatureAlgorithm) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("setSignatureAlg>>>>>>Running: signatureAlgorithm=" + signatureAlgorithm);
        }
        try {
            if (signatureAlgorithm == null) {
                throw new PKIException(PKIException.SIG_ALG_NULL, PKIException.SIG_ALG_NULL_DES);
            }
            this.mechanism = Mechanisms.signMechanismFrom(signatureAlgorithm);
            if (this.mechanism == null) {
                throw new PKIException(PKIException.NONSUPPORT_SIGALG, PKIException.NONSUPPORT_SIGALG_DES + ": " + signatureAlgorithm);
            }
            ASN1ObjectIdentifier oid = Mechanism.getObjectIdentifier(signatureAlgorithm);
            this.sigAlg = new AlgorithmIdentifier(oid);
            this.tbsCRLGen.setSignature(this.sigAlg);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("setSignatureAlg<<<<<<Finished");
            }
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("setSignatureAlg<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("setSignatureAlg<<<<<<Failure", e);
            throw new PKIException("setSignatureAlg Failure: " + e.getMessage(), e);
        }
    }

    public void addExtensions(Vector extensions) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("addExtensions>>>>>>Running: extension=" + extensions);
        }
        int size = extensions.size();
        for (int i = 0; i < size; ++i) {
            Extension extension = (Extension)extensions.get(i);
            this.addExtension(extension);
        }
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("addExtension<<<<<<Finished");
        }
    }

    public void addExtension(Extension extension) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("addExtension>>>>>>Running: extension=" + SADKDebugger.dump(extension));
        }
        ASN1ObjectIdentifier derOID = extension.getExtnId();
        boolean critical = extension.isCritical();
        DEROctetString derOctet = (DEROctetString)extension.getExtnValue();
        this.extensionSet.put(derOID, new X509Extension(critical, (ASN1OctetString)derOctet));
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("addExtension<<<<<<Finished");
        }
    }

    public byte[] generateCRL(PrivateKey privateKey, Session session) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("generateCRL>>>>>>Running: session=" + SADKDebugger.dump(session));
        }
        try {
            if (this.issuerName == null || this.issuerName.equals("")) {
                throw new PKIException(PKIException.ISSUER_NULL, PKIException.ISSUER_NULL_DES);
            }
            if (this.thisUpdate == null) {
                throw new PKIException(PKIException.THIS_UPDATE_NULL, PKIException.THIS_UPDATE_NULL_DES);
            }
            if (this.sigAlg == null) {
                throw new PKIException(PKIException.SIG_ALG_NULL, PKIException.SIG_ALG_NULL_DES);
            }
            this.generateSignature(privateKey, session);
            byte[] crlBytes = this.constructCRL();
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("generateCRL<<<<<<Finished: crlBytes=" + SADKDebugger.dump(crlBytes));
            }
            return crlBytes;
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("generateCRL<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("generateCRL<<<<<<Failure", e);
            throw new PKIException("generateCRL Failure: " + e.getMessage(), e);
        }
    }

    private void generateSignature(PrivateKey privateKey, Session session) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("generateSignature::>>>>>>Running: session=" + SADKDebugger.dump(session));
        }
        try {
            if (this.extensionSet.size() > 0) {
                this.tbsCRLGen.setExtensions(new X509Extensions(this.extensionSet));
            }
            this.tbsCRL = this.tbsCRLGen.generateTBSCertList();
            byte[] bTBSCRL = null;
            try {
                bTBSCRL = ASN1Parser.parseDERObj2Bytes(this.tbsCRL.toASN1Primitive());
            }
            catch (Exception ex) {
                throw new PKIException(PKIException.TBSCRL_BYTES, PKIException.TBSCRL_BYTES_DES, ex);
            }
            byte[] signatureData = null;
            try {
                signatureData = session.sign(this.mechanism, privateKey, bTBSCRL);
            }
            catch (Exception ex) {
                throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES, ex);
            }
            byte[] signatureBytes = null;
            if ("SM2".equalsIgnoreCase(privateKey.getAlgorithm()) || this.mechanism.getMechanismType().toUpperCase().contains("SM2")) {
                ASN1SM2Signature asn1Value = new ASN1SM2Signature(signatureData);
                signatureBytes = asn1Value.getEncoded();
            } else {
                signatureBytes = signatureData;
            }
            this.signature = new DERBitString(signatureBytes);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("generateSignature::<<<<<<Finished: signatureData=" + SADKDebugger.dump(signatureData));
            }
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("generateSignature::<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("generateSignature::<<<<<<Failure", e);
            throw new PKIException("generateSignature Failure: " + e.getMessage(), e);
        }
    }

    private byte[] constructCRL() throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("constructCRL::>>>>>>Running");
        }
        try {
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add(this.tbsCRL);
            v.add(this.sigAlg);
            v.add(this.signature);
            DERSequence derSeq = new DERSequence(v);
            byte[] crlData = null;
            try {
                crlData = ASN1Parser.parseDERObj2Bytes(derSeq.toASN1Primitive());
            }
            catch (Exception ex) {
                throw new PKIException(PKIException.CRL_BYTES, PKIException.CRL_BYTES_DES, ex);
            }
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("constructCRL::<<<<<<Finished: crlData=" + SADKDebugger.dump(crlData));
            }
            return crlData;
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("constructCRL::<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("constructCRL::<<<<<<Failure", e);
            throw new PKIException("constructCRL Failure: " + e.getMessage(), e);
        }
    }
}

