/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.base.common;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.bcsoft.BCSoftLib;
import cfca.sadk.system.Mechanisms;
import cfca.sadk.util.Base64;
import cfca.sadk.util.HashUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;

public class FileHashUtil {
    public static int maxDeep = 5;
    private static Logger businessLog = LoggerFactory.getLogger(FileHashUtil.class);

    public static void calculateHash(String fileDir, Mechanism mechanism, HashMap<String, String> fileHashMap, String dirPerfix) throws Exception {
        File dir = new File(fileDir);
        if (dir.isDirectory()) {
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    FileHashUtil.calculateHash(files[i].getPath(), mechanism, fileHashMap, dirPerfix);
                    continue;
                }
                String filePath = files[i].getName();
                boolean isSM2 = Mechanisms.isSM2WithSM3((Mechanism)mechanism);
                byte[] hashBytes = null;
                hashBytes = isSM2 ? HashUtil.SM3HashFileWithoutZValue((InputStream)new FileInputStream(files[i]), (Session)BCSoftLib.INSTANCE()) : HashUtil.RSAHashFile((InputStream)new FileInputStream(files[i]), (Mechanism)mechanism, (Session)BCSoftLib.INSTANCE(), (boolean)false);
                String hashValue = new String(Base64.encode((byte[])hashBytes), "UTF-8");
                String originPath = fileDir.replaceAll("\\\\", "/");
                int start = 0;
                if (dirPerfix != null) {
                    start = originPath.indexOf(dirPerfix);
                }
                if (start == -1) continue;
                String canonicalFilePath = originPath.substring(start);
                String[] deep = canonicalFilePath.split("/");
                if (deep.length > maxDeep) {
                    businessLog.error("Recursion times out of limit! Max times is " + maxDeep);
                    return;
                }
                fileHashMap.put(originPath.substring(start) + "/" + filePath, hashValue);
            }
        } else {
            throw new Exception("param must be directory");
        }
    }

    public static byte[] calculateHash(String filePath, Mechanism mechanism) throws Exception {
        boolean isSM2 = Mechanisms.isSM2WithSM3((Mechanism)mechanism);
        byte[] hashBytes = null;
        hashBytes = isSM2 ? HashUtil.SM3HashFileWithoutZValue((InputStream)new FileInputStream(filePath), (Session)BCSoftLib.INSTANCE()) : HashUtil.RSAHashFile((InputStream)new FileInputStream(filePath), (Mechanism)mechanism, (Session)BCSoftLib.INSTANCE(), (boolean)false);
        return hashBytes;
    }

    public static byte[] calculateHash(byte[] data, Mechanism mechanism, SM2PublicKey sm2PubKey) throws Exception {
        boolean isSM2 = Mechanisms.isSM2WithSM3((Mechanism)mechanism);
        byte[] hashBytes = null;
        hashBytes = isSM2 ? (null == sm2PubKey ? HashUtil.SM3HashFileWithoutZValue((InputStream)new ByteArrayInputStream(data), (Session)BCSoftLib.INSTANCE()) : HashUtil.SM3HashFileWithZValue((InputStream)new ByteArrayInputStream(data), (SM2PublicKey)sm2PubKey, (Session)BCSoftLib.INSTANCE())) : HashUtil.RSAHashFile((InputStream)new ByteArrayInputStream(data), (Mechanism)mechanism, (Session)BCSoftLib.INSTANCE(), (boolean)false);
        return hashBytes;
    }
}

