/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.util.encoders;

import cfca.sadk.org.bouncycastle.util.Strings;
import cfca.sadk.org.bouncycastle.util.encoders.DecoderException;
import cfca.sadk.org.bouncycastle.util.encoders.EncoderException;
import cfca.sadk.org.bouncycastle.util.encoders.HexEncoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Hex {
    public static String toHexString(byte[] data) {
        String hexText = null;
        hexText = data == null || data.length == 0 ? "" : Hex.toHexString(data, 0, data.length);
        return hexText;
    }

    public static String toHexString(byte[] data, int off, int length) {
        byte[] encoded = Hex.encode(data, off, length);
        return Strings.fromByteArray(encoded);
    }

    public static byte[] encode(byte[] data) {
        return Hex.encode(data, 0, data.length);
    }

    public static byte[] encode(byte[] data, int off, int length) {
        HexEncoder encoder = new HexEncoder();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            encoder.encode(data, off, length, bOut);
        }
        catch (Exception e) {
            throw new EncoderException("exception encoding Hex string: " + e.getMessage(), e);
        }
        return bOut.toByteArray();
    }

    public static int encode(byte[] data, OutputStream out) throws IOException {
        HexEncoder encoder = new HexEncoder();
        return encoder.encode(data, 0, data.length, out);
    }

    public static int encode(byte[] data, int off, int length, OutputStream out) throws IOException {
        HexEncoder encoder = new HexEncoder();
        return encoder.encode(data, off, length, out);
    }

    public static byte[] decode(byte[] data) {
        byte[] outBytes = null;
        if (data == null || data.length == 0) {
            outBytes = new byte[]{};
        } else {
            HexEncoder encoder = new HexEncoder();
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            try {
                encoder.decode(data, 0, data.length, bOut);
            }
            catch (Exception e) {
                throw new DecoderException("exception decoding Hex data: " + e.getMessage(), e);
            }
            outBytes = bOut.toByteArray();
        }
        return outBytes;
    }

    public static byte[] decode(String data) {
        byte[] outBytes = null;
        if (data == null || data.length() == 0) {
            outBytes = new byte[]{};
        } else {
            HexEncoder encoder = new HexEncoder();
            ByteArrayOutputStream bOut = new ByteArrayOutputStream(data.length() / 2);
            try {
                encoder.decode(data, bOut);
            }
            catch (Exception e) {
                throw new DecoderException("exception decoding Hex string: " + e.getMessage(), e);
            }
            outBytes = bOut.toByteArray();
        }
        return outBytes;
    }

    public static int decode(String data, OutputStream out) throws IOException {
        HexEncoder encoder = new HexEncoder();
        return encoder.decode(data, out);
    }
}

