/*
 * Decompiled with CFR 0.152.
 */
package io.github.autoffice.luckysheet.model.cell;

import com.fasterxml.jackson.annotation.JsonValue;
import io.github.autoffice.luckysheet.util.Util;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;

public enum TextRotateType {
    NONE(0, 0),
    CLOCKWISE_45(1, 45),
    ANTICLOCKWISE_45(2, 135),
    VERTICAL(3, 90),
    CLOCKWISE_90(4, 90),
    ANTICLOCKWISE_90(5, 180);

    @JsonValue
    private final Integer lsValue;
    private final short poiValue;
    private static final Map<Short, TextRotateType> TYPES;

    public static TextRotateType of(short rotation) {
        TextRotateType textRotateType = TYPES.get(rotation);
        return Util.requireNonNullElse(textRotateType, NONE);
    }

    @Generated
    private TextRotateType(Integer lsValue, short poiValue) {
        this.lsValue = lsValue;
        this.poiValue = poiValue;
    }

    @Generated
    public short getPoiValue() {
        return this.poiValue;
    }

    static {
        TYPES = Arrays.stream(TextRotateType.values()).collect(Collectors.toMap(TextRotateType::getPoiValue, Function.identity(), (existing, replacement) -> existing));
    }
}

