/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zz5V;
import asposewobfuscated.zzAN;
import com.aspose.words.Document;
import com.aspose.words.PageInfo;
import com.aspose.words.PageSetup;
import com.aspose.words.PrintHelper;
import com.aspose.words.zzZQ;
import com.aspose.words.zzZR;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.PageRanges;

public class AsposeWordsPrintDocument
implements Pageable,
Printable {
    private final Document zz80;
    private int zz7Z;
    private zzZQ[] zz7Y;
    private PageInfo zz7X;
    private zzAN zz7W;
    private String zz7V;
    private boolean zz7U = true;
    private MediaTray[] zz7T;

    public AsposeWordsPrintDocument(Document document) {
        if (document == null) {
            throw new IllegalArgumentException("Document cannot be null");
        }
        this.zz80 = document;
        try {
            if (this.zzv5()) {
                PageSetup pageSetup = this.zz80.getFirstSection().getPageSetup();
                this.zz7Y = zzZR.zzI(this.zz80.getPageCount(), pageSetup.getSheetsPerBooklet(), pageSetup.getMultiplePages());
                this.zz7Z = this.zz7Y.length;
            } else {
                this.zz7Z = document.getPageCount();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void zzv6() {
    }

    private boolean zzv5() {
        return this.zz80.zzZZx().zz1b();
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex >= this.zz7Z) {
            return 1;
        }
        try {
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.zzv5()) {
                if (pageIndex < 0 || pageIndex >= this.zz7Y.length) {
                    throw new IllegalStateException("Unexpected Booklet signature index.");
                }
                zzZQ zzZQ10 = this.zz7Y[pageIndex];
                this.zz80.zzZ(zzZQ10, this.zzv4().zzZln(), this.zzv4().getPaperTray(), graphics2D, (float)pageFormat.getImageableX(), (float)pageFormat.getImageableY(), (float)pageFormat.getWidth(), (float)pageFormat.getHeight());
            } else {
                this.zz80.renderToSize(pageIndex, graphics2D, (float)pageFormat.getImageableX(), (float)pageFormat.getImageableY(), (float)pageFormat.getWidth(), (float)pageFormat.getHeight());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    @Override
    public int getNumberOfPages() {
        return this.zz7Z;
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        PageFormat pageFormat = new PageFormat();
        try {
            PageInfo pageInfo = this.zzv5() ? this.zzv4() : this.zz80.getPageInfo(pageIndex);
            Paper paper = new Paper();
            float f = pageInfo.getWidthInPoints();
            float f2 = pageInfo.getHeightInPoints();
            if (pageInfo.getLandscape() && this.zz7U) {
                paper.setImageableArea(0.0, 0.0, f2, f);
                paper.setSize(f2, f);
                pageFormat.setOrientation(0);
            } else {
                paper.setImageableArea(0.0, 0.0, f, f2);
                paper.setSize(f, f2);
                pageFormat.setOrientation(1);
            }
            pageFormat.setPaper(paper);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return pageFormat;
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        return this;
    }

    void zzZ(zzAN zzAN2) {
        this.zz7W = zzAN2;
    }

    void zzW2(String string) {
        this.zz7V = string;
    }

    void print() {
        PrintService printService = this.getPrintService();
        if (printService == null) {
            throw new IllegalStateException("There are no available print Services.");
        }
        try {
            int n;
            int n2;
            this.zz7T = PrintHelper.getTrays(printService);
            this.zz7U = this.zzZ(printService);
            if (this.zz7Z == 0) {
                return;
            }
            if (this.zzv5()) {
                n2 = 1;
                n = this.zz7Z;
            } else {
                n2 = this.zz7W.getFromPage() == 0 ? 1 : this.zz7W.getFromPage();
                n = this.zz7W.getToPage() == 0 ? this.zz7Z : this.zz7W.getToPage();
            }
            PageInfo pageInfo = this.zz80.getPageInfo(n2 - 1);
            int n3 = n2 - 1;
            int n4 = pageInfo.getPaperTray();
            for (int i = n2; i < n; ++i) {
                pageInfo = this.zz80.getPageInfo(i);
                int n5 = pageInfo.getPaperTray();
                if (n5 == n4) continue;
                this.zzZ(printService, n3 + 1, i, n4);
                n4 = n5;
                n3 = i;
            }
            this.zzZ(printService, n3 + 1, n, n4);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void zzZ(PrintService printService, int n, int n2, int n3) throws PrinterException, NoSuchFieldException, IllegalAccessException {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintService(printService);
        printerJob.setPageable(this);
        PrintRequestAttributeSet printRequestAttributeSet = this.zz7W.zzAo();
        if (this.zz7V != null && this.zz7V.length() > 0) {
            printRequestAttributeSet.add(new JobName(this.zz7V, zz5V.getDefault()));
        }
        printRequestAttributeSet.add(new PageRanges(n, n2));
        MediaTray mediaTray = this.zzk(n3);
        if (mediaTray != null) {
            printRequestAttributeSet.add(mediaTray);
        }
        printerJob.print(printRequestAttributeSet);
    }

    MediaTray zzk(Object object) throws NoSuchFieldException, IllegalAccessException {
        for (MediaTray mediaTray : this.zz7T) {
            int n = PrintHelper.getTrayID(mediaTray);
            if (!object.equals(n)) continue;
            return mediaTray;
        }
        return null;
    }

    private PrintService getPrintService() {
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(null, this.zz7W.zzAn());
        PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
        if (printServiceArray.length == 0) {
            return printService;
        }
        if (printService != null) {
            for (PrintService printService2 : printServiceArray) {
                if (printService2 != printService) continue;
                return printService2;
            }
        }
        return printServiceArray[0];
    }

    private boolean zzZ(PrintService printService) throws PrinterException {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintService(printService);
        PageFormat pageFormat = printerJob.defaultPage();
        Paper paper = new Paper();
        paper.setImageableArea(0.0, 0.0, Double.MAX_VALUE, Double.MAX_VALUE);
        pageFormat.setPaper(paper);
        PageFormat pageFormat2 = printerJob.validatePage(pageFormat);
        return pageFormat.getHeight() != pageFormat2.getImageableHeight() || pageFormat.getWidth() != pageFormat2.getImageableWidth();
    }

    private PageInfo zzv4() {
        if (this.zz7X == null) {
            this.zz7X = this.zz80.zzv4();
        }
        return this.zz7X;
    }
}

