/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zzVE;
import com.aspose.words.Border;
import com.aspose.words.zzZTU;
import java.awt.Color;
import java.util.Iterator;

public class BorderCollection
implements Iterable<Border> {
    private zzZTU zz6E;

    BorderCollection(zzZTU parent) {
        this.zz6E = parent;
    }

    public Border getByBorderType(int borderType) throws Exception {
        Object v = this.zz6E.getPossibleBorderKeys().get(borderType);
        if (v == null) {
            throw new IllegalStateException("The requested border is not available for this object.");
        }
        int n = (Integer)v;
        Border border = (Border)this.zz6E.getDirectBorderAttr(n);
        if (border == null) {
            border = new Border(this.zz6E, n);
            this.zz6E.setBorderAttr(n, border);
        }
        return border;
    }

    public Border get(int index) throws Exception {
        int n = (Integer)this.zz6E.getPossibleBorderKeys().getKey(index);
        return this.getByBorderType(n);
    }

    public Border getLeft() throws Exception {
        return this.getByBorderType(1);
    }

    public Border getRight() throws Exception {
        return this.getByBorderType(2);
    }

    public Border getTop() throws Exception {
        return this.getByBorderType(3);
    }

    public Border getBottom() throws Exception {
        return this.getByBorderType(0);
    }

    public Border getHorizontal() throws Exception {
        return this.getByBorderType(4);
    }

    public Border getVertical() throws Exception {
        return this.getByBorderType(5);
    }

    public int getCount() {
        return this.zz6E.getPossibleBorderKeys().getCount();
    }

    public double getLineWidth() throws Exception {
        return this.get(0).getLineWidth();
    }

    public void setLineWidth(double value) throws Exception {
        Iterator iterator = this.zz6E.getPossibleBorderKeys().zzAR().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzSK(n)) continue;
            this.getByBorderType(n).setLineWidth(value);
        }
    }

    public int getLineStyle() throws Exception {
        return this.get(0).getLineStyle();
    }

    public void setLineStyle(int value) throws Exception {
        Iterator iterator = this.zz6E.getPossibleBorderKeys().zzAR().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzSK(n)) continue;
            this.getByBorderType(n).setLineStyle(value);
        }
    }

    public Color getColor() throws Exception {
        return this.zzui().zzTR();
    }

    public void setColor(Color value) throws Exception {
        this.zzs(zzVE.zzZ(value));
    }

    zzVE zzui() throws Exception {
        return this.get(0).zzui();
    }

    void zzs(zzVE zzVE2) throws Exception {
        Iterator iterator = this.zz6E.getPossibleBorderKeys().zzAR().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzSK(n)) continue;
            this.getByBorderType(n).zzs(zzVE2);
        }
    }

    public double getDistanceFromText() throws Exception {
        return this.get(0).getDistanceFromText();
    }

    public void setDistanceFromText(double value) throws Exception {
        Iterator iterator = this.zz6E.getPossibleBorderKeys().zzAR().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzSK(n)) continue;
            this.getByBorderType(n).setDistanceFromText(value);
        }
    }

    public boolean getShadow() throws Exception {
        return this.get(0).getShadow();
    }

    public void setShadow(boolean value) throws Exception {
        Iterator iterator = this.zz6E.getPossibleBorderKeys().zzAR().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzSK(n)) continue;
            this.getByBorderType(n).setShadow(value);
        }
    }

    public void clearFormatting() {
        for (Border border : this) {
            border.clearFormatting();
        }
    }

    @Override
    public Iterator iterator() {
        return new zzZ(this);
    }

    boolean isVisible() throws Exception {
        for (Border border : this) {
            if (!border.isVisible()) continue;
            return true;
        }
        return false;
    }

    private static boolean zzSK(int n) {
        return n != 6 && n != 7;
    }

    private class zzZ
    implements Iterator {
        private BorderCollection zz6o;
        private int zz6n;

        zzZ(BorderCollection borderCollection2) {
            this.zz6o = borderCollection2;
            this.zz6n = -1;
        }

        @Override
        public boolean hasNext() {
            if (this.zz6n >= this.zz6o.getCount() - 1) {
                return false;
            }
            ++this.zz6n;
            return true;
        }

        public Object next() {
            try {
                return this.zz6o.get(this.zz6n);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

