/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.List;
import com.aspose.words.ListCollection;
import com.aspose.words.ListLevel;
import com.aspose.words.zzYVM;
import com.aspose.words.zzZRD;
import com.aspose.words.zzZRK;

public class ListFormat {
    private zzZRK zzZ6l;
    private zzZRD zzZ6k;
    private ListCollection zzZAH;
    private ListLevel zzZ6j;

    ListFormat(zzZRK parentParaAttrs, zzZRD parentRunAttrs, ListCollection lists) {
        this.zzZ6l = parentParaAttrs;
        this.zzZ6k = parentRunAttrs;
        this.zzZAH = lists;
    }

    public void applyBulletDefault() {
        if (this.zzZAH.getCount() > 2046) {
            zzYVM.zzY(this.zzZAH.getDocument().getWarningCallback(), 18, "List count exceed maximum allowed, document can have problem while opened in MS Word.", new Object[0]);
        }
        this.zzG2(this.zzZAH.add(0).getListId());
        this.setListLevelNumber(0);
        this.invalidate();
    }

    public void applyNumberDefault() {
        if (this.zzZAH.getCount() > 2046) {
            zzYVM.zzY(this.zzZAH.getDocument().getWarningCallback(), 18, "List count exceed maximum allowed, document can have problem while opened in MS Word.", new Object[0]);
        }
        this.zzG2(this.zzZAH.add(6).getListId());
        this.setListLevelNumber(0);
        this.invalidate();
    }

    public void removeNumbers() {
        this.setList(null);
        this.invalidate();
    }

    public void listIndent() throws Exception {
        if (this.getListLevelNumber() < 8) {
            this.setListLevelNumber(this.getListLevelNumber() + 1);
            this.invalidate();
        }
    }

    public void listOutdent() throws Exception {
        if (this.getListLevelNumber() > 0) {
            this.setListLevelNumber(this.getListLevelNumber() - 1);
            this.invalidate();
        }
    }

    public int getListLevelNumber() throws Exception {
        return (Integer)this.zzZ6l.fetchParaAttr(1110);
    }

    public void setListLevelNumber(int value) {
        this.zzZ6l.setParaAttr(1110, value);
        this.invalidate();
    }

    public boolean isListItem() throws Exception {
        return this.getListId() != 0;
    }

    public List getList() throws Exception {
        int n = this.getListId();
        return n != 0 ? this.zzZAH.zzFV(n) : null;
    }

    public void setList(List value) {
        if (value == null) {
            this.zzG2(0);
            this.setListLevelNumber(0);
        } else {
            if (value.getDocument() != this.zzZAH.getDocument()) {
                throw new IllegalArgumentException("The list belongs to a different document.");
            }
            if (value.isListStyleDefinition()) {
                throw new IllegalArgumentException("The list is a definition of a list style.");
            }
            this.zzG2(value.getListId());
        }
        this.invalidate();
    }

    public ListLevel getListLevel() {
        try {
            if (this.zzZ6j == null) {
                List list = this.getList();
                ListLevel listLevel = list != null ? list.zzFW(this.getListLevelNumber()) : null;
                this.zzZ6j = listLevel != null ? new ListLevel(listLevel, this.zzZ6k) : null;
            }
            return this.zzZ6j;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    int getListId() throws Exception {
        return (Integer)this.zzZ6l.fetchParaAttr(1120);
    }

    void zzG2(int n) {
        this.zzZ6l.setParaAttr(1120, n);
        this.invalidate();
        if (n == 0 || this.zzZ6l.getDirectParaAttr(1160) == null || this.getListLevel() == null) {
            return;
        }
        int n2 = (Integer)this.zzZ6l.getDirectParaAttr(1160);
        if (n2 == 0) {
            this.zzZ6l.removeParaAttr(1160);
        } else {
            int n3 = n2 + this.getListLevel().zzZK7().zzZyl() + this.getListLevel().zzZK7().zzZyo();
            this.zzZ6l.setParaAttr(1160, n3);
        }
    }

    private void invalidate() {
        this.zzZ6j = null;
    }
}

