/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl;

import cfca.sadk.tls.sun.security.ssl.HandshakeInStream;
import cfca.sadk.tls.util.Hexifys;
import java.io.IOException;
import java.util.Random;

public final class RandomCookie {
    public final byte[] random = new byte[32];

    public RandomCookie(Random random) {
        random.nextBytes(this.random);
        int gmt_unix_time = (int)Math.min(Integer.MAX_VALUE, System.currentTimeMillis() / 1000L);
        this.random[0] = (byte)(gmt_unix_time >> 24);
        this.random[1] = (byte)(gmt_unix_time >> 16);
        this.random[2] = (byte)(gmt_unix_time >> 8);
        this.random[3] = (byte)gmt_unix_time;
    }

    public RandomCookie(HandshakeInStream in) throws IOException {
        in.read(this.random, 0, 32);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int gmt_unix_time = this.random[0] << 24;
        gmt_unix_time += this.random[1] << 16;
        gmt_unix_time += this.random[2] << 8;
        builder.append("GMT: " + (gmt_unix_time += this.random[3]) + " ");
        builder.append("bytes = 0x").append(Hexifys.hexify(this.random, 4, 28));
        return builder.toString();
    }
}

